/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.xhtml;

import java.util.ArrayList;

// TODO: Auto-generated Javadoc
/**
 * Classe représentant un arbre Javascript.
 * 
 * @author FBI
 */
public class JavascriptTree {

	/** Liste des éléments de l'arbre. */
	private ArrayList<JavascriptTreeItem> listItem = null;

	/**
	 * Constructeur.
	 */
	public JavascriptTree() {
		this.listItem = new ArrayList<JavascriptTreeItem>();
	}

	/**
	 * Ajoute un élément à la liste.
	 * 
	 * @param item
	 *            L'élément à ajouter
	 */
	public void addItem(JavascriptTreeItem item) {
		listItem.add(item);
	}

	/**
	 * Affiche l'arbre Javascript.
	 * 
	 * @return Le code Javascript d'affichage de l'arbre
	 */
	public String print() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < listItem.size(); i++) {
			sb.append(listItem.get(i).print());
		}
		return sb.toString();
	}
}
