/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.xhtml;

import org.apache.commons.lang3.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * Classe correspondant à un élément d'un menu Javascript.
 *
 * @author FBI
 */
public class JavascriptTreeItem {

	/** Code de l'élément parent. */
	private String codeParent = null;

	/** Code de l'élément. */
	private String code = null;

	/** Libellé de l'élément. */
	private String text = null;

	/** Etat ouvert(1) ou fermé (0) de l'élément. */
	private boolean opened = true;

	/** Elément sélectionnable (1) ou non (0). */
	private boolean selectable = true;

	/**
	 * Constructeur.
	 *
	 * @param codeParent
	 *            the code parent
	 * @param code
	 *            the code
	 * @param text
	 *            the text
	 * @param opened
	 *            the opened
	 * @param selectable
	 *            the selectable
	 */
	public JavascriptTreeItem(final String codeParent, final String code, final String text, final boolean opened, final boolean selectable) {
		this.codeParent = codeParent;
		this.code = code;
		this.text = text;
		this.opened = opened;
		this.selectable = selectable;
	}

	/**
	 * Affiche l'élément.
	 *
	 * @return the string
	 */
	public String print() {
		return "oTree.AddNode('" + StringUtils.replace(codeParent, "'", "\\'") + "', '" + StringUtils.replace(code, "'", "\\'") + "', '" + StringUtils.replace(text, "'", "\\'") + "', " + (opened ? "true" : "false") + ", " + (selectable ? "true" : "false") + ");\r\n";
	}
}
