/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.xhtml.pdf;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

import com.jsbsoft.jtf.exception.ErreurApplicative;

// TODO: Auto-generated Javadoc
/**
 * The Interface IGenerateurPDF.
 */
public interface IGenerateurPDF {

	/**
	 * Creates the pdf.
	 * 
	 * @param is
	 *            the is
	 * @param os
	 *            the os
	 * 
	 * @throws ErreurApplicative
	 *             the erreur applicative
	 */
	void createPDF(InputStream is, OutputStream os) throws ErreurApplicative;

	/**
	 * Creates the pdf.
	 * 
	 * @param fXml
	 *            the f xml
	 * @param fXslt
	 *            the f xslt
	 * @param os
	 *            the os
	 * 
	 * @throws ErreurApplicative
	 *             the erreur applicative
	 */
	void createPDF(File fXml, File fXslt, OutputStream os) throws ErreurApplicative;
}
