/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.xhtml.tags;

import org.htmlparser.tags.CompositeTag;

/**
 * A link tag.
 */
public class HeadLinkTag extends CompositeTag {

	/**
	 *
	 */
	private static final long serialVersionUID = -84511259414298318L;

	/**
	 * The set of names handled by this tag.
	 */
	private static final String[] mIds = new String[] { "LINK" };

	/**
	 * The set of end tag names that indicate the end of this tag.
	 */
	private static final String[] mEndTagEnders = new String[] { "HEAD", };

	/**
	 * Create a new div tag.
	 */
	public HeadLinkTag() {}

	/**
	 * Return the set of names handled by this tag.
	 * 
	 * @return The names to be matched that create tags of this type.
	 */
	@Override
	public String[] getIds() {
		return (mIds);
	}

	/**
	 * Return the set of end tag names that cause this tag to finish.
	 * 
	 * @return The names of following end tags that stop further scanning.
	 */
	@Override
	public String[] getEndTagEnders() {
		return (mEndTagEnders);
	}
}