/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.kportal.core.context.BeanUtil;
import com.kportal.core.context.MergedContextBean;
import com.kportal.core.context.OverridedContextBean;
import com.kportal.extension.ExtensionConfigurer;
import fr.kosmos.cluster.api.Cluster;
import fr.kosmos.cluster.api.MessageHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextManager
implements ApplicationContextAware,
MessageHandler<Serializable> {
    private static final String ID_BEAN = "applicationContextManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextManager.class);
    public static final String DEFAULT_CORE_CONTEXT = "core";
    private static Map<String, ApplicationContext> allApplicationContext;
    private static Map<String, OverridedContextBean> overridedBeans;
    private Cluster cluster;

    public void init() {
        if (this.cluster != null) {
            this.cluster.registerService((MessageHandler)this);
        }
    }

    public static synchronized void refresh() {
        ConfigurableApplicationContext configurableCtx = (ConfigurableApplicationContext)allApplicationContext.get(DEFAULT_CORE_CONTEXT);
        configurableCtx.refresh();
        LOGGER.info("Chargement des contextes applicatifs OK");
    }

    public static void refresh(ExtensionConfigurer extensionConfigurer) {
        ApplicationContext parentCtx = allApplicationContext.get(DEFAULT_CORE_CONTEXT);
        allApplicationContext.clear();
        overridedBeans.clear();
        allApplicationContext.put(DEFAULT_CORE_CONTEXT, parentCtx);
        allApplicationContext.putAll(extensionConfigurer.initAllApplicationContext(allApplicationContext.get(DEFAULT_CORE_CONTEXT)));
        Iterator<String> it = allApplicationContext.keySet().iterator();
        while (it.hasNext()) {
            String idExtension = it.next();
            ApplicationContext appCtx = allApplicationContext.get(idExtension);
            ApplicationContextManager.processOverride(idExtension, appCtx);
            if (ApplicationContextManager.processMerge(idExtension, appCtx)) continue;
            ((ConfigurableApplicationContext)appCtx).close();
            it.remove();
        }
        ((ClassBeanManager)parentCtx.getBean("classBeanManager")).refresh();
    }

    private static boolean processMerge(String idExtension, ApplicationContext appCtx) {
        for (String beanName : appCtx.getBeanNamesForType(MergedContextBean.class)) {
            MergedContextBean bean = (MergedContextBean)appCtx.getBean(beanName);
            if (StringUtils.isEmpty((CharSequence)bean.getIdBeanToMerge())) {
                bean.setIdBeanToMerge(beanName);
            }
            if (StringUtils.isEmpty((CharSequence)bean.getIdExtensionToMerge())) {
                bean.setIdExtensionToMerge(DEFAULT_CORE_CONTEXT);
            }
            if (allApplicationContext.get(bean.getIdExtensionToMerge()) != null) {
                if (allApplicationContext.get(bean.getIdExtensionToMerge()).containsBean(bean.getIdBeanToMerge())) {
                    try {
                        bean.merge();
                    }
                    catch (Exception e) {
                        LOGGER.error("Erreur extension id=" + idExtension + " : le bean id=" + bean.getIdBeanToMerge() + " impossible \u00e0 merger" + (bean.getIdExtensionToMerge().equals(DEFAULT_CORE_CONTEXT) ? " sur l'application" : " sur l'extension id=" + bean.getIdExtensionToMerge()), (Throwable)e);
                    }
                    continue;
                }
                LOGGER.error("Erreur extension id=" + idExtension + " : le bean id=" + bean.getIdBeanToMerge() + " \u00e0 merger" + (bean.getIdExtensionToMerge().equals(DEFAULT_CORE_CONTEXT) ? " sur l'application" : " sur l'extension id=" + bean.getIdExtensionToMerge()) + " n'existe pas");
                continue;
            }
            LOGGER.error("Erreur extension id=" + idExtension + " : l'extension id=" + bean.getIdExtensionToMerge() + " \u00e0 merger n'existe pas");
            if (!bean.isMandatory()) continue;
            LOGGER.error("Extension id=" + idExtension + "est ignor\u00e9e");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static void processOverride(String idExtension, ApplicationContext appCtx) {
        for (String beanName : appCtx.getBeanNamesForType(OverridedContextBean.class)) {
            OverridedContextBean bean = (OverridedContextBean)appCtx.getBean(beanName);
            if (StringUtils.isEmpty((CharSequence)bean.getIdBean())) {
                bean.setIdBean(beanName);
            }
            if (StringUtils.isEmpty((CharSequence)bean.getIdExtension())) {
                bean.setIdExtension(idExtension);
            }
            if (StringUtils.isEmpty((CharSequence)bean.getIdBeanToOverride())) {
                bean.setIdBeanToOverride(beanName);
            }
            if (StringUtils.isEmpty((CharSequence)bean.getIdExtensionToOverride())) {
                bean.setIdExtensionToOverride(DEFAULT_CORE_CONTEXT);
            }
            if (allApplicationContext.get(bean.getIdExtensionToOverride()) != null) {
                if (allApplicationContext.get(bean.getIdExtensionToOverride()).containsBean(bean.getIdBeanToOverride())) {
                    overridedBeans.put(BeanUtil.getBeanKey(bean.getIdBeanToOverride(), bean.getIdExtensionToOverride()), bean);
                    continue;
                }
                LOGGER.error("Erreur extension id=" + idExtension + " : le bean id=" + bean.getIdBeanToOverride() + " \u00e0 surcharger" + (bean.getIdExtensionToOverride().equals(DEFAULT_CORE_CONTEXT) ? " sur l'application" : " sur l'extension id=" + bean.getIdExtensionToOverride()) + " n'existe pas");
                continue;
            }
            LOGGER.error("Erreur extension id=" + idExtension + " : l'extension id=" + bean.getIdExtensionToOverride() + " \u00e0 surcharger n'existe pas");
        }
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        allApplicationContext = new HashMap<String, ApplicationContext>();
        allApplicationContext.put(DEFAULT_CORE_CONTEXT, arg0);
        overridedBeans = new HashMap<String, OverridedContextBean>();
    }

    public static Object getBean(String ctxName, String beanName, boolean includeOverrided) {
        if (includeOverrided && overridedBeans.get(BeanUtil.getBeanKey(beanName, ctxName)) != null) {
            OverridedContextBean over = overridedBeans.get(BeanUtil.getBeanKey(beanName, ctxName));
            return ApplicationContextManager.getBean(over.getIdExtension(), over.getIdBean());
        }
        ApplicationContext appCtx = allApplicationContext.get(ctxName);
        Object bean = null;
        if (appCtx == null) {
            LOGGER.warn("Contexte non trouv\u00e9 : " + ctxName);
        } else {
            bean = appCtx.getBean(beanName);
        }
        return bean;
    }

    public static Object getBean(String ctxName, String beanName) {
        return ApplicationContextManager.getBean(ctxName, beanName, true);
    }

    public static <T> T getBean(String ctxName, String beanName, Class<T> clazz) {
        Object bean = ApplicationContextManager.getBean(ctxName, beanName, true);
        if (bean != null && clazz.isInstance(bean)) {
            return clazz.cast(bean);
        }
        return null;
    }

    public static boolean containsBean(String ctxName, String beanName) {
        try {
            ApplicationContextManager.getBean(ctxName, beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
        return true;
    }

    public static boolean containsBean(String beanName) {
        return ApplicationContextManager.getEveryContextBean(beanName) != null;
    }

    public static Object getEveryContextBean(String beanName) {
        for (String idExtension : allApplicationContext.keySet()) {
            try {
                return ApplicationContextManager.getBean(idExtension, beanName);
            }
            catch (Exception exception) {
            }
        }
        LOGGER.warn("Le bean id=" + beanName + " n'existe dans aucun contexte applicatif");
        return null;
    }

    public static <T> T getEveryContextBean(String beanName, Class<T> clazz) {
        for (String idExtension : allApplicationContext.keySet()) {
            try {
                Object bean = ApplicationContextManager.getBean(idExtension, beanName);
                if (!clazz.isInstance(bean)) continue;
                return clazz.cast(bean);
            }
            catch (Exception exception) {
            }
        }
        LOGGER.warn("Le bean id=" + beanName + " n'existe dans aucun contexte applicatif");
        return null;
    }

    public static Object getCoreContextBean(String beanName) {
        return ApplicationContextManager.getBean(DEFAULT_CORE_CONTEXT, beanName);
    }

    public static <T> T getCoreContextBean(String beanName, Class<T> clazz) {
        return ApplicationContextManager.getBean(DEFAULT_CORE_CONTEXT, beanName, clazz);
    }

    public static <T> Map<String, T> getAllBeansOfType(Class<T> type) {
        HashMap<String, T> res = new HashMap<String, T>();
        for (String idExtension : allApplicationContext.keySet()) {
            res.putAll(ApplicationContextManager.getBeansOfType(idExtension, type));
        }
        return res;
    }

    public static <T> Map<String, T> getCoreContextBeansOfType(Class<T> type) {
        return ApplicationContextManager.getBeansOfType(DEFAULT_CORE_CONTEXT, type);
    }

    public static <T> Map<String, T> getBeansOfType(String ctxName, Class<T> type) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        ApplicationContext appCtx = allApplicationContext.get(ctxName);
        for (String beanName : appCtx.getBeanNamesForType(type)) {
            res.put(beanName, ApplicationContextManager.getBean(ctxName, beanName));
        }
        return res;
    }

    public static Map<String, ApplicationContext> getAllApplicationContext() {
        return allApplicationContext;
    }

    public static ApplicationContext getApplicationContext(String name) {
        return allApplicationContext.get(name);
    }

    public void handleMessage(Serializable message) {
        ApplicationContextManager.refresh();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public static ApplicationContextManager getInstance() {
        return (ApplicationContextManager)allApplicationContext.get(DEFAULT_CORE_CONTEXT).getBean(ID_BEAN);
    }
}

