/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassBeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClassBeanManager.class);
    public static final String ID_BEAN = "classBeanManager";
    public List<String> packages;
    public List<String> classes;
    GenericApplicationContext contexte;

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void refresh() {
        this.contexte = new GenericApplicationContext();
        try {
            ClassPathBeanDefinitionScanner s = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this.contexte, false);
            for (String classe : this.classes) {
                s.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Class.forName(classe)));
            }
            s.setIncludeAnnotationConfig(false);
            s.scan(this.packages.toArray(new String[this.packages.size()]));
        }
        catch (Exception e) {
            LOG.error("Erreur de chargement des beans utils", (Throwable)e);
        }
    }

    public <T> Collection<T> getBeanOfType(Class<T> classe) {
        return this.contexte.getBeansOfType(classe).values();
    }

    public Collection<?> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.contexte.getBeansWithAnnotation(annotationType).values();
    }

    public static ClassBeanManager getInstance() {
        return (ClassBeanManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }
}

