/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.kdecole.cache.aspect.TempCacheGet;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ExtensionHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLibelle {
    private static final String PROP_TABLE_REPERTOIRE_SPECIFIC = "table.repertoire.specific";
    public static final String ID_BEAN = "codeLibelle";
    public static final String TABLE_RELATIVE_PATH = "/WEB-INF/tables/";
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeLibelle.class);

    public static String getSuffixe(Locale _locale) {
        String suffixe = "_" + _locale.getLanguage();
        if (_locale.getCountry().length() > 0) {
            suffixe = suffixe + "_" + _locale.getCountry();
        }
        return suffixe;
    }

    public static String lireLibelle(String idCtx, String nomTable, String codes) {
        return CodeLibelle.lireLibelle(idCtx, nomTable, null, codes);
    }

    public static String lireLibelle(String idCtx, String nomTable, Locale locale, String codes) {
        String res = "";
        if (codes != null && !"".equals(codes) && !"0000".equals(codes)) {
            Hashtable<String, String> h = CodeLibelle.lireTable(CodeLibelle.getPathTable(idCtx, nomTable, locale));
            StringTokenizer st = new StringTokenizer(codes, ";");
            while (st.hasMoreTokens()) {
                String libelle;
                String code = st.nextToken();
                if (res.length() > 0) {
                    res = res + ";";
                }
                if ((libelle = h.get(code)) == null) {
                    libelle = "";
                }
                if ((libelle = libelle.trim()).startsWith("...") && libelle.endsWith("...")) {
                    while (libelle.startsWith(".")) {
                        libelle = libelle.substring(1);
                    }
                    while (libelle.endsWith(".")) {
                        libelle = libelle.substring(0, libelle.length() - 1);
                    }
                    libelle = libelle.trim();
                }
                res = res + libelle;
            }
        }
        return res;
    }

    private static Hashtable<String, String> lireTable(String pathTable) {
        return ((CodeLibelle)ApplicationContextManager.getCoreContextBean(ID_BEAN)).getTable(pathTable);
    }

    private static String getPathTable(String idCtx, String nomTable, Locale locale) {
        String rep;
        String repSpecific;
        String nomTableLocale = nomTable;
        if (StringUtils.isEmpty((CharSequence)idCtx)) {
            idCtx = "core";
        }
        File fTable = null;
        if (locale != null) {
            nomTableLocale = nomTableLocale + CodeLibelle.getSuffixe(locale);
        }
        if (StringUtils.isNotEmpty((CharSequence)(repSpecific = PropertyHelper.getProperty(idCtx, PROP_TABLE_REPERTOIRE_SPECIFIC)))) {
            fTable = CodeLibelle.getFileTable(nomTable, nomTableLocale, repSpecific);
        }
        if (fTable == null) {
            rep = WebAppUtil.getAbsolutePath() + repSpecific;
            fTable = CodeLibelle.getFileTable(nomTable, nomTableLocale, rep);
        }
        if (fTable == null) {
            rep = WebAppUtil.getAbsolutePath() + ExtensionHelper.getExtension(idCtx).getRelativePath() + TABLE_RELATIVE_PATH;
            fTable = CodeLibelle.getFileTable(nomTable, nomTableLocale, rep);
        }
        if (fTable == null && !idCtx.equals("core")) {
            rep = WebAppUtil.getAbsolutePath() + ExtensionHelper.getExtension("").getRelativePath() + TABLE_RELATIVE_PATH;
            fTable = CodeLibelle.getFileTable(nomTable, nomTableLocale, rep);
        }
        if (fTable != null && fTable.exists()) {
            return fTable.getAbsolutePath();
        }
        LOGGER.debug("Le fichier " + nomTable + " n'a pas \u00e9t\u00e9 trouv\u00e9");
        return "";
    }

    private static File getFileTable(String nomTable, String nomTableLocale, String rep) {
        File fTable = new File(rep + nomTableLocale + ".dat");
        if (!fTable.exists() && !nomTable.equals(nomTableLocale)) {
            fTable = new File(rep + nomTable + ".dat");
        }
        if (!fTable.exists()) {
            fTable = null;
        }
        return fTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TempCacheGet(key="CodeLibelle.getTable", contextual=false)
    public Hashtable<String, String> getTable(String pathTable) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (StringUtils.isEmpty((CharSequence)pathTable)) {
            return h;
        }
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(pathTable)), CharEncoding.DEFAULT_CHARSET));
            String line = br.readLine();
            if (line != null) {
                int iLastCarCle = line.length() - 1;
                while (!Character.isLetterOrDigit(line.charAt(iLastCarCle)) && line.charAt(iLastCarCle) != '$') {
                    --iLastCarCle;
                }
                int lgCle = 0;
                int i = iLastCarCle;
                while (Character.isLetterOrDigit(line.charAt(i)) || line.charAt(i) == '$') {
                    ++lgCle;
                    --i;
                }
                int lgLibelle = iLastCarCle - lgCle + 1;
                do {
                    if (line.length() <= 10) continue;
                    String cle = line.substring(lgLibelle, lgLibelle + lgCle);
                    int indiceDollar = cle.indexOf(36);
                    if (indiceDollar != -1) {
                        cle = cle.substring(0, indiceDollar);
                    }
                    h.put(cle, line.substring(0, lgLibelle));
                } while ((line = br.readLine()) != null);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Fichier table [" + pathTable + "] introuvable");
        }
        catch (IOException e) {
            LOGGER.error("Erreur de lecture du fichier [" + pathTable + "]", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Erreur de lecture du fichier [" + pathTable + "]", (Throwable)e);
            h = new Hashtable();
        }
        return h;
    }

    public static Hashtable<String, String> lireTable(String idCtx, String nomTable, Locale locale) {
        return CodeLibelle.lireTable(CodeLibelle.getPathTable(idCtx, nomTable, locale));
    }
}

