/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.CodeLibelle;
import java.sql.Date;
import java.sql.Time;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formateur {
    private static final Logger LOG = LoggerFactory.getLogger(Formateur.class);

    public static String formater(Object _o) {
        return Formateur.formater(_o, "");
    }

    public static String formater(Object _o, String format) {
        String res = "";
        if (_o instanceof Date) {
            res = Formateur.formaterDate(_o, format);
        }
        if (_o instanceof Time) {
            res = Formateur.formaterTime(_o, format);
        }
        if (_o instanceof Integer) {
            res = Formateur.formaterNombre(_o, format);
        }
        if (_o instanceof Long) {
            res = Formateur.formaterNombre(_o, format);
        }
        if (_o instanceof Double) {
            res = Formateur.formaterDecimal(_o, format);
        }
        if (_o instanceof String) {
            res = _o.toString();
        }
        return res;
    }

    public static String formaterDate(Object _date, String format) {
        String value = "";
        try {
            Date date = (Date)_date;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            if (Formateur.estSaisie(date)) {
                Object[] arguments = new Object[]{cal.get(5), cal.get(2) + 1, cal.get(1)};
                value = MessageFormat.format("{0,number,00}/{1,number,00}/{2,number,0000}", arguments);
            } else {
                value = "";
            }
        }
        catch (Exception e) {
            LOG.error("Erreur lors du formatage d'une Date", (Throwable)e);
        }
        return value;
    }

    public static String formaterTime(Object _time, String format) {
        String value = "";
        try {
            Time time;
            if (_time != null && StringUtils.isNotBlank((CharSequence)_time.toString()) && (time = (Time)_time).getTime() != -3599000L) {
                Date date = new Date(time.getTime());
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                value = sdf.format(date);
            }
        }
        catch (Exception e) {
            LOG.error("Erreur lors du formatage d'un Time", (Throwable)e);
        }
        return value;
    }

    public static String formaterLibelle(String idExt, Object _code, String nomTable) {
        String value = "";
        try {
            value = CodeLibelle.lireLibelle(idExt, nomTable, (String)_code);
        }
        catch (Exception e) {
            LOG.error("erreur lors du formatage d'un libelle", (Throwable)e);
        }
        return value;
    }

    public static String formaterNombre(Object _nombre, String format) {
        String value = "";
        try {
            value = _nombre.toString();
        }
        catch (Exception e) {
            LOG.error("erreur lors du formatage d'un nombre", (Throwable)e);
        }
        return value;
    }

    public static boolean estSaisie(Date _date) {
        boolean res = false;
        if (_date != null) {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(_date);
                res = cal.get(1) != 1970 || cal.get(2) != 0 || cal.get(5) != 1;
            }
            catch (Exception e) {
                LOG.error("erreur lors de la v\u00e9rification d'une date", (Throwable)e);
            }
        }
        return res;
    }

    public static boolean estSaisi(String siteWeb) {
        return StringUtils.isNotEmpty((CharSequence)siteWeb) && !"http://".equals(siteWeb);
    }

    public static String formaterDecimal(Object _nombre, String format) {
        String value = "";
        if (_nombre != null) {
            value = _nombre.toString();
        }
        return value;
    }

    public static Date parserDate(String valeur) throws Exception {
        if (valeur.length() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            GregorianCalendar cal = new GregorianCalendar();
            dateFormat.setLenient(false);
            cal.setTime(dateFormat.parse(valeur));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            return new Date(cal.getTimeInMillis());
        }
        return new Date(0L);
    }

    public static Date renvoyerDateJour(String valeur, boolean plus) throws Exception {
        Date res = new Date(0L);
        int jour = 0;
        if (valeur.length() > 0) {
            try {
                jour = Integer.parseInt(valeur);
            }
            catch (Exception e) {
                return res;
            }
            Date dateAujourdhui = new Date(System.currentTimeMillis());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateAujourdhui);
            if (plus) {
                cal.set(6, cal.get(6) + jour);
            } else {
                cal.set(6, cal.get(6) - jour);
            }
            res = new Date(cal.getTimeInMillis());
        }
        return res;
    }
}

