/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.webutils.FormateurHTML;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.tree.processus.GroupsJsTree;
import com.univ.tree.processus.RubriquesJsTree;
import com.univ.tree.processus.StructuresJsTree;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import java.io.Writer;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormateurJSP {
    private static final Logger LOG = LoggerFactory.getLogger(FormateurJSP.class);
    private static final String LN = "\n";
    public static final int FORMAT_TEXTE = 0;
    public static final int FORMAT_COMBO = 1;
    public static final int FORMAT_DATE = 2;
    public static final int FORMAT_ENTIER = 3;
    public static final int FORMAT_DECIMAL = 4;
    public static final int FORMAT_MULTI_LIGNE = 5;
    public static final int FORMAT_LONG = 6;
    public static final int FORMAT_CHECKBOX = 7;
    public static final int FORMAT_RADIO = 8;
    public static final int FORMAT_FICHIER = 9;
    public static final int FORMAT_TEXTE_CACHE = 10;
    public static final int FORMAT_HEURE_MINUTE = 11;
    public static final int FORMAT_MULTI_LIGNE_HTML = 12;
    public static final int FORMAT_LISTE_CHOIX_MULTIPLE = 9;
    public static final int BOUTON_VALIDER = 0;
    public static final int BOUTON_REVENIR = 1;
    public static final int BOUTON_ABANDONNER = 2;
    public static final int BOUTON_ANNULER = 3;
    public static final int BOUTON_SUPPRIMER = 4;
    public static final int BOUTON_RECHERCHER = 5;
    public static final int BOUTON_CONFIRMER = 6;
    public static final int BOUTON_DETAIL = 7;
    public static final int BOUTON_AJOUTER = 8;
    public static final int BOUTON_CREER = 9;
    public static final int BOUTON_SUITE = 10;
    public static final int BOUTON_MODIFIER = 11;
    public static final int BOUTON_TRADUIRE = 12;
    public static final int BOUTON_ENREGISTRER = 13;
    private static final String[][] images = new String[][]{{"VALIDER", "Valider"}, {"REVENIR", "Revenir"}, {"ABANDON", "Abandonner"}, {"ANNULER", "Annuler"}, {"SUPPRIMER", "Supprimer"}, {"RECHERCHER", "Rechercher"}, {"CONFIRMER", "Confirmer"}, {"DETAIL", "D&eacute;tail"}, {"AJOUTER", "Ajouter"}, {"CREER", "Cr&eacute;er"}, {"SUITE", "Suite"}, {"MODIFIER", "Modifier"}, {"TRADUIRE", "Traduire"}, {"ENREGISTRER", "Enregistrer"}};
    public static final int SAISIE_AFFICHAGE = 0;
    public static final int SAISIE_FACULTATIF = 1;
    public static final int SAISIE_OBLIGATOIRE = 2;
    public static final int SAISIE_OBLIGATOIRE_SELECTION_DEFAUT = 3;
    private int indiceChamp = 0;
    private int indiceRadio = -1;
    private String nomGroupeRadio = "";
    public static final int ORDRE_NORMAL = 0;
    public static final int ORDRE_INVERSE = 1;

    private String formaterCheckbox(String nomDonnee, String valeur, String idFormulaire, int optionModification) {
        String selected = "";
        if ("1".equals(valeur)) {
            selected = "checked=\"checked\"";
        }
        return "<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " class=\"checkbox\" type=\"checkbox\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" " + this.generateAttributeForm(idFormulaire) + " value=\"1\" " + selected + " />";
    }

    private String formaterRadioBouton(InfoBean infoBean, String nomDonnee, String idFormulaire, int optionModification) {
        String valeur = StringUtils.defaultString((String)infoBean.getString(nomDonnee));
        if (StringUtils.isEmpty((CharSequence)valeur) && infoBean.get("DONOT_PRESELECT_" + nomDonnee) == null) {
            valeur = "0";
        }
        if (nomDonnee.equalsIgnoreCase(this.nomGroupeRadio)) {
            ++this.indiceRadio;
        } else {
            this.nomGroupeRadio = nomDonnee;
            this.indiceRadio = 0;
        }
        String checked = "";
        String value = String.valueOf(this.indiceRadio);
        if (StringUtils.isNotEmpty((CharSequence)infoBean.getString(nomDonnee + this.indiceRadio))) {
            value = infoBean.getString(nomDonnee + this.indiceRadio);
            if (value.equals(valeur)) {
                checked = "checked=\"checked\"";
            }
        } else if (StringUtils.isNotEmpty((CharSequence)valeur) && Integer.parseInt(valeur) == this.indiceRadio) {
            checked = "checked=\"checked\"";
        }
        return "<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " class=\"radio\" type=\"radio\" id=\"" + nomDonnee + "_" + this.indiceRadio + "\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\" " + this.generateAttributeForm(idFormulaire) + " " + checked + " />";
    }

    public void insererBoutons(Writer out, InfoBean infoBean, int[] boutons) {
        try {
            out.write("<p class=\"validation\">");
            for (int bouton : boutons) {
                String libelle = images[bouton][1];
                try {
                    libelle = MessageHelper.getCoreMessage("JTF_BOUTON_" + images[bouton][1].toUpperCase());
                }
                catch (Exception e) {
                    libelle = images[bouton][1];
                }
                out.write("<input id=\"" + images[bouton][0].toLowerCase() + "\" type=\"submit\" name=\"" + images[bouton][0] + "\" value=\"" + libelle + "\" /> ");
            }
            out.write("</p>");
        }
        catch (Exception e) {
            LOG.error("erreur sur l'insertion des boutons", (Throwable)e);
        }
    }

    public void insererChampSaisie(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax) {
        this.insererChampSaisie(out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nbCarMax, "-");
    }

    public void insererChampSaisie(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, String format) {
        this.insererChampSaisie(out, infoBean, nomDonnee, optionModification, typeFormat, nbCarMin, nbCarMax, nbCarMax, format);
    }

    public void insererChampSaisie(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, int typeFormat, int nbCarMin, int nbCarMax, int size, String format) {
        String idFormulaire;
        try {
            if (optionModification != 0) {
                out.write("<input type=\"hidden\" name=\"#FORMAT_" + nomDonnee + "\" value=\"" + optionModification + ";" + typeFormat + ";" + nbCarMin + ";" + nbCarMax + ";" + this.transformerFormat(format) + ";" + this.indiceChamp++ + "\" />");
            }
        }
        catch (Exception e) {
            LOG.error("erreur sur l'\u00e9criture dans la sortie", (Throwable)e);
        }
        String string = idFormulaire = infoBean.get("ID_FORM") != null ? (String)infoBean.get("ID_FORM") : "";
        if (!infoBean.isControled(nomDonnee) && optionModification != 0) {
            block81: {
                String valeur = "";
                if (infoBean.get(nomDonnee) != null) {
                    valeur = (String)infoBean.get(nomDonnee);
                }
                try {
                    int nbCar = 32;
                    if (nbCarMax != 0) {
                        nbCar = nbCarMax;
                    }
                    if (typeFormat == 5 || typeFormat == 12) {
                        out.write(this.formaterTextArea(nomDonnee, valeur, nbCarMax, format, idFormulaire, optionModification));
                        out.write(LN);
                        break block81;
                    }
                    if (typeFormat == 7) {
                        out.write(this.formaterCheckbox(nomDonnee, valeur, idFormulaire, optionModification));
                        out.write(LN);
                        break block81;
                    }
                    if (typeFormat == 8) {
                        out.write(this.formaterRadioBouton(infoBean, nomDonnee, idFormulaire, optionModification));
                        out.write(LN);
                        break block81;
                    }
                    if (typeFormat == 9) {
                        out.write("<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"file\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "_FILE\" " + this.generateAttributeForm(idFormulaire) + " />");
                        if (valeur.length() > 0) {
                            out.write("<br />" + EscapeString.escapeHtml(valeur));
                        } else {
                            String alerte = "";
                            String array = "";
                            String maxSize = "";
                            if (StringUtils.isNotEmpty((CharSequence)infoBean.getString("MAX_FILE_SIZE"))) {
                                maxSize = infoBean.getString("MAX_FILE_SIZE");
                            } else if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("fichiergw.maxsize"))) {
                                maxSize = PropertyHelper.getCoreProperty("fichiergw.maxsize");
                            }
                            if (StringUtils.isNotBlank((CharSequence)maxSize)) {
                                try {
                                    alerte = alerte + "Taille maximum : " + Integer.parseInt(maxSize) / 1024 + " Mo";
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            String extensions = "";
                            if (infoBean.getString("KEY_FILE_EXTENSIONS_" + nomDonnee) != null) {
                                extensions = infoBean.getString("KEY_FILE_EXTENSIONS_" + nomDonnee);
                            } else if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("fichiergw.extensions"))) {
                                extensions = PropertyHelper.getCoreProperty("fichiergw.extensions");
                            }
                            if (StringUtils.isNotBlank((CharSequence)extensions)) {
                                String[] tExt = extensions.split(",");
                                String tmpExt = "";
                                for (String string2 : tExt) {
                                    if (tmpExt.length() > 0) {
                                        tmpExt = tmpExt + ", ";
                                        array = array + ",";
                                    }
                                    tmpExt = tmpExt + "." + string2 + "";
                                    array = array + "'." + string2 + "'";
                                }
                                if (alerte.length() > 0) {
                                    alerte = alerte + "<br />";
                                }
                                alerte = alerte + "Extension(s) : " + tmpExt;
                            }
                            if (StringUtils.isNotBlank((CharSequence)alerte)) {
                                out.write("<button type=\"button\" class=\"infobulle\" data-original-title=\"" + EscapeString.escapeAttributHtml(alerte) + "\"></button>");
                            }
                            if (StringUtils.isNotBlank((CharSequence)extensions)) {
                                out.write("<script type=\"text/javascript\">");
                                out.write("formFileExtensions['" + nomDonnee + "']= new Array(" + array + ");");
                                out.write("</script>");
                            }
                        }
                        out.write(LN);
                        break block81;
                    }
                    if (typeFormat == 2) {
                        StringBuilder champDate = new StringBuilder();
                        champDate.append("<input ").append(optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "").append(" class=\"type_date\" placeholder=\"JJ/MM/AAAA\" type=\"text\" id=\"").append(nomDonnee).append("\" name=\"").append(nomDonnee).append("\" value=\"").append(EscapeString.escapeAttributHtml(valeur));
                        if (nbCarMax != 0) {
                            champDate.append("\" maxlength=\"").append(nbCarMax);
                        }
                        champDate.append("\" size=\"").append(size).append("\" ");
                        champDate.append(this.generateAttributeForm(idFormulaire));
                        champDate.append(" />");
                        out.write(champDate.toString());
                    } else if (typeFormat == 3 || typeFormat == 6) {
                        nbCar = 9;
                        if (nbCarMax != 0) {
                            nbCar = nbCarMax;
                        }
                        out.write("<input class=\"numeric_input\" " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"text\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" " + this.generateAttributeForm(idFormulaire) + " size=\"" + size + "\" maxlength=\"" + nbCar + "\"/>");
                        out.write(LN);
                    } else if (typeFormat != 10) {
                        out.write(this.formaterChampTexte(nomDonnee, valeur, nbCar, nbCar, format, idFormulaire, optionModification));
                        out.write(LN);
                    }
                }
                catch (Exception e) {
                    LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
                }
            }
            return;
        }
        String value = "";
        if (typeFormat == 0) {
            try {
                value = (String)infoBean.get(nomDonnee);
                if (optionModification != 0) {
                    out.write(this.formaterChampTexte(nomDonnee, value, nbCarMax, size, format, idFormulaire, optionModification));
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 7) {
            try {
                value = (String)infoBean.get(nomDonnee);
                if (optionModification != 0) {
                    out.write(this.formaterCheckbox(nomDonnee, value, idFormulaire, optionModification));
                    out.write(LN);
                } else if ("0".equals(value = StringUtils.defaultString((String)value))) {
                    value = "";
                } else if ("1".equals(value)) {
                    value = "X";
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 8) {
            try {
                value = (String)infoBean.get(nomDonnee);
                out.write(this.formaterRadioBouton(infoBean, nomDonnee, idFormulaire, optionModification));
                out.write(LN);
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 3 || typeFormat == 6) {
            try {
                int nbCar = 9;
                if (nbCarMax != 0) {
                    nbCar = nbCarMax;
                }
                value = Formateur.formater(infoBean.get(nomDonnee));
                if (optionModification != 0) {
                    out.write("<input class=\"numeric_input\" " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"text\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\" " + this.generateAttributeForm(idFormulaire) + " size=\"" + size + "\" maxlength=\"" + nbCar + "\"/>");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 5 || typeFormat == 12) {
            try {
                value = Formateur.formater(infoBean.get(nomDonnee));
                if (optionModification != 0) {
                    out.write(this.formaterTextArea(nomDonnee, value, nbCarMax, format, idFormulaire, optionModification));
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 2) {
            try {
                value = Formateur.formater(infoBean.get(nomDonnee));
                if (optionModification != 0) {
                    out.write("<input type=\"text\" class=\"type_date\" placeholder=\"" + MessageHelper.getCoreMessage("ST_RECHERCHE_FORMAT_DATE") + "\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\" size=\"11\" title=\"" + MessageHelper.getCoreMessage("ST_RECHERCHE_FORMAT_DATE") + " " + (optionModification == 2 ? MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") : "") + "\" " + this.generateAttributeForm(idFormulaire) + " />");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 4) {
            try {
                value = Formateur.formater(infoBean.get(nomDonnee));
                if (optionModification != 0) {
                    out.write("<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"text\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\" " + this.generateAttributeForm(idFormulaire) + " size=\"10\" />");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 9) {
            try {
                if (optionModification != 0) {
                    out.write("<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"file\" name=\"" + nomDonnee + "_FILE\" " + this.generateAttributeForm(idFormulaire) + " />");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (typeFormat == 11) {
            try {
                value = Formateur.formater(infoBean.get(nomDonnee));
                if (optionModification != 0) {
                    out.write("<input type=\"text\" placeholder=\"HH:mm\" class=\"input-append type_time\" pattern=\"\\d\\d:\\d\\d\" id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" value=\"" + EscapeString.escapeAttributHtml(value) + "\" size=\"5\" title=\"" + MessageHelper.getCoreMessage("ST_RECHERCHE_FORMAT_TIME") + " " + (optionModification == 2 ? MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") : "") + "\"/ " + this.generateAttributeForm(idFormulaire) + " >");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
        if (optionModification == 0) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    out.write("<span>" + FormateurHTML.formaterEnHTML(value) + "</span>");
                    out.write(LN);
                } else {
                    out.write("<span>&nbsp;</span>");
                    out.write(LN);
                }
            }
            catch (Exception e) {
                LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
            }
        }
    }

    public void insererCombo(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, String nomTable) {
        this.insererCombo(out, infoBean, nomDonnee, optionModification, infoBean.getNomExtension(), nomTable, "");
    }

    public void insererCombo(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, String nomTable, String format) {
        this.insererCombo(out, infoBean, nomDonnee, optionModification, infoBean.getNomExtension(), nomTable, format);
    }

    public void insererCombo(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, String idExtention, String nomTable, String format) {
        try {
            Hashtable<String, String> table = CodeLibelle.lireTable(idExtention, nomTable, ContexteUtil.getContexteUniv().getLocale());
            this.insererCombo(out, infoBean, nomDonnee, optionModification, table, format);
        }
        catch (Exception e) {
            LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
        }
    }

    public void insererCombo(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, Map<String, String> table, String format) {
        this.insererComboMultiple(out, infoBean, nomDonnee, optionModification, table, format, 1);
    }

    public void insererComboMultiple(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, Map<String, String> table, String format, int size) {
        if (optionModification == -1) {
            return;
        }
        String idFormulaire = infoBean.get("ID_FORM") != null ? (String)infoBean.get("ID_FORM") : "";
        try {
            if (optionModification == 0) {
                String szTmp = nomDonnee;
                if (nomDonnee.startsWith("TMP_")) {
                    szTmp = szTmp.substring(4);
                }
                String valeurDonnee = StringUtils.defaultString((String)infoBean.getString(szTmp));
                StringTokenizer stValeurs = new StringTokenizer(valeurDonnee, ";");
                int i = 0;
                while (stValeurs.hasMoreTokens()) {
                    String valeurTable = StringUtils.defaultString((String)table.get(stValeurs.nextToken()));
                    if (i > 0) {
                        out.write(",");
                    }
                    out.write(EscapeString.escapeHtml(valeurTable));
                    ++i;
                }
                out.write(LN);
            } else {
                String szTmp = nomDonnee;
                if (szTmp.startsWith("TMP_")) {
                    szTmp = szTmp.substring(4);
                }
                out.write("<input type=\"hidden\" name=\"#FORMAT_" + szTmp + "\" value=\"" + optionModification + ";" + 1 + ";0;0;" + this.transformerFormat(format) + ";" + this.indiceChamp++ + "\" />");
                Object o = infoBean.get(nomDonnee);
                String valeurDonnee = "";
                if (o != null) {
                    valeurDonnee = StringUtils.defaultString((String)o.toString());
                }
                String multiple = "";
                if (size > 1) {
                    multiple = "multiple";
                }
                out.write("<select " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " " + multiple + " id=\"" + nomDonnee + "\" name=\"" + nomDonnee + "\" " + this.generateAttributeForm(idFormulaire) + " size=\"" + size + "\">");
                out.write(LN);
                if (table.get(" ") != null) {
                    out.write("<option value=\"\">" + (String)StringUtils.defaultIfEmpty((CharSequence)table.get(" "), (CharSequence)MessageHelper.getCoreMessage("JTF_SELECTIONNER_LISTE")) + "</option>");
                    out.write(LN);
                } else if (table.get("0000") != null) {
                    out.write("<option value=\"0000\">" + (String)StringUtils.defaultIfEmpty((CharSequence)table.get("0000"), (CharSequence)MessageHelper.getCoreMessage("JTF_SELECTIONNER_LISTE")) + "</option>");
                    out.write(LN);
                } else {
                    out.write("<option value=\"0000\">" + MessageHelper.getCoreMessage("JTF_SELECTIONNER_LISTE") + "</option>");
                    out.write(LN);
                }
                String cleItem = "";
                String libelleItem = "";
                Vector<String> vector = new Vector<String>(table.size());
                for (String key : table.keySet()) {
                    String elemVect;
                    Enumeration v;
                    int i;
                    cleItem = key;
                    if (" ".equals(cleItem)) continue;
                    libelleItem = table.get(cleItem);
                    if (format.contains("PAS_DE_TRI")) {
                        vector.insertElementAt(libelleItem + "," + cleItem, 0);
                        continue;
                    }
                    if (format.contains("TRI_CLE_NUM")) {
                        i = 0;
                        v = vector.elements();
                        while (v.hasMoreElements()) {
                            String cleElemVect;
                            float valCleElemVect;
                            elemVect = (String)v.nextElement();
                            float valCleItem = Float.parseFloat(cleItem);
                            if (!(valCleItem > (valCleElemVect = Float.parseFloat(cleElemVect = elemVect.substring(elemVect.indexOf(",") + 1))))) continue;
                            ++i;
                        }
                        vector.insertElementAt(libelleItem + "," + cleItem, i);
                        continue;
                    }
                    if (format.contains("TRI_CLE")) {
                        i = 0;
                        v = vector.elements();
                        while (v.hasMoreElements()) {
                            elemVect = (String)v.nextElement();
                            String cleElemVect = elemVect.substring(elemVect.lastIndexOf(",") + 1);
                            if (cleItem.compareTo(cleElemVect) <= 0) continue;
                            ++i;
                        }
                        vector.insertElementAt(libelleItem + "," + cleItem, i);
                        continue;
                    }
                    i = 0;
                    Collator collator = Collator.getInstance(Locale.FRANCE);
                    Enumeration v2 = vector.elements();
                    while (v2.hasMoreElements() && collator.compare(libelleItem, (String)v2.nextElement()) > 0) {
                        ++i;
                    }
                    vector.insertElementAt(libelleItem + "," + cleItem, i);
                }
                for (String element : vector) {
                    String nextElt = element;
                    if (nextElt.contains(",")) {
                        libelleItem = nextElt.substring(0, nextElt.lastIndexOf(","));
                        cleItem = nextElt.substring(nextElt.lastIndexOf(",") + 1);
                    } else {
                        libelleItem = nextElt;
                    }
                    String selection = "";
                    if (valeurDonnee.equals(cleItem)) {
                        selection = "selected = \"selected\"";
                    }
                    if (format.contains("TRI_CLE") && libelleItem.startsWith("#GROUPE#")) {
                        out.write("<optgroup id=\"opt" + EscapeString.escapeAttributHtml(cleItem) + "\" label=\"" + libelleItem.substring(8) + "\" >");
                    } else if (format.contains("TRI_CLE") && libelleItem.startsWith("#/GROUPE#")) {
                        out.write("</optgroup>");
                    } else if (!libelleItem.startsWith("#/GROUPE#") && !libelleItem.startsWith("#/GROUPE#")) {
                        out.write("<option value=\"" + EscapeString.escapeAttributHtml(cleItem) + "\" " + selection + " title=\"" + libelleItem + "\">" + libelleItem + "</option>");
                    }
                    out.write(LN);
                }
                out.write("</select>");
                out.write(LN);
            }
        }
        catch (Exception e) {
            LOG.error("erreur lors de l'insertion d'une combo multiple", (Throwable)e);
        }
    }

    public void insererComboHashtable(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, String nomHashtable) {
        this.insererComboHashtable(out, infoBean, nomDonnee, optionModification, nomHashtable, "");
    }

    public void insererComboHashtable(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, String nomHashtable, String format) {
        try {
            Hashtable<String, String> table = (Hashtable<String, String>)infoBean.get(nomHashtable);
            if (table == null) {
                table = new Hashtable<String, String>();
            }
            this.insererCombo(out, infoBean, nomDonnee, optionModification, table, format);
        }
        catch (Exception e) {
            LOG.error("erreur sur l'insertion d'une combo", (Throwable)e);
        }
    }

    @Deprecated
    public void insererMessageErreur(Writer out, InfoBean infoBean) {
    }

    public void insererVariablesCachees(Writer out, InfoBean infoBean) {
        try {
            Locale localeCourante = ContexteUtil.getContexteUniv().getLocale();
            if (infoBean.getModeEnchainement() == 0) {
                out.write("<input type=\"hidden\" name=\"BEANPU\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getBEANPU()) + "\" />");
                out.write(LN);
                out.write("<input type=\"hidden\" name=\"#ID_JSP#\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getIDJSP()) + "\" />");
                out.write(LN);
                out.write("<input type=\"hidden\" name=\"#ECRAN_LOGIQUE#\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getEcranLogique()) + "\" />");
                out.write(LN);
            } else {
                out.write("<input type=\"hidden\" name=\"PROC\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getNomProcessus()) + "\" />");
                out.write(LN);
                out.write("<input type=\"hidden\" name=\"EXT\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getNomExtension()) + "\" />");
                out.write(LN);
                out.write("<input type=\"hidden\" name=\"#ECRAN_LOGIQUE#\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getEcranLogique()) + "\" />");
                out.write(LN);
                out.write("<input type=\"hidden\" name=\"#ETAT#\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getEtatObjet()) + "\" />");
                out.write(LN);
                String nomObjet = (String)StringUtils.defaultIfBlank((CharSequence)infoBean.getString("OBJET"), (CharSequence)ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET")));
                out.write("<input type=\"hidden\" name=\"OBJET\" value=\"" + EscapeString.escapeAttributHtml(nomObjet) + "\" />");
                out.write(LN);
                if (infoBean.get("RH") != null) {
                    out.write("<input type=\"hidden\" name=\"RH\" value=\"" + EscapeString.escapeAttributHtml(infoBean.getString("RH")) + "\" />");
                    out.write(LN);
                }
            }
            out.write("<input type=\"hidden\" name=\"LOCALE\" value=\"" + LangueUtil.getLangueLocale(localeCourante) + "\" />");
            out.write(LN);
        }
        catch (Exception e) {
            LOG.error("erreur sur l'\u00e9criture sur la sortie", (Throwable)e);
        }
    }

    public static void decomposerHashtable(Hashtable<String, String> h, Vector<String> _vCle, Vector<String> _vLibelle, boolean triCle) {
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            Enumeration<String> v;
            String cleItem = e.nextElement();
            String libelleItem = h.get(cleItem);
            int i = 0;
            if (!triCle) {
                v = _vLibelle.elements();
                while (v.hasMoreElements() && libelleItem.compareTo(v.nextElement()) > 0) {
                    ++i;
                }
            } else {
                v = _vCle.elements();
                while (v.hasMoreElements() && cleItem.compareTo(v.nextElement()) > 0) {
                    ++i;
                }
            }
            _vCle.insertElementAt(cleItem, i);
            _vLibelle.insertElementAt(libelleItem, i);
        }
    }

    private String formaterChampTexte(String _nomDonnee, String _valeur, int nbCarMax, int _size, String _format, String idFormulaire, int optionModification) {
        String autoCompleteParam;
        String type = "text";
        String autoComplete = "";
        LOG.debug("FORMAT " + _nomDonnee + " = " + _format);
        String param = FormateurJSP.renvoyerValeurFormatage(_format, "password");
        if (param != null) {
            type = "password";
        }
        if ((autoCompleteParam = FormateurJSP.renvoyerValeurFormatage(_format, "noautocomplete")) != null) {
            autoComplete = "autocomplete=\"nope\"";
        }
        int size = 0;
        size = _size > 0 && _size != nbCarMax ? _size : (nbCarMax > 0 ? Math.min(nbCarMax, 50) : 32);
        String s = "<input " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " type=\"" + type + "\" id=\"" + _nomDonnee + "\" name=\"" + _nomDonnee + "\" value=\"" + (String)StringUtils.defaultIfBlank((CharSequence)EscapeString.escapeAttributHtml(_valeur), (CharSequence)"");
        if (nbCarMax != 0) {
            s = s + "\" maxlength=\"" + nbCarMax;
        }
        s = s + "\" " + this.generateAttributeForm(idFormulaire) + " size=\"" + size + "\" " + autoComplete + " />";
        return s;
    }

    private String formaterTextArea(String _nomDonnee, String _valeur, int nbCarMax, String _format, String idFormulaire, int optionModification) {
        String rows = "6";
        String param = FormateurJSP.renvoyerValeurFormatage(_format, "ROWS");
        if (param != null) {
            rows = param;
        }
        String cols = "40";
        param = FormateurJSP.renvoyerValeurFormatage(_format, "COLS");
        if (param != null) {
            cols = param;
        }
        String s = "<textarea " + (optionModification == 2 ? "title=\"" + MessageHelper.getCoreMessage("ST_CHAMP_OBLIGATOIRE") + "\" required=\"required\"" : "") + " id=\"" + _nomDonnee + "\" name=\"" + _nomDonnee + "\" " + this.generateAttributeForm(idFormulaire) + " cols=\"" + cols + "\" rows=\"" + rows + "\"";
        if (nbCarMax != 0) {
            s = s + " maxlength=\"" + nbCarMax + "\"";
        }
        s = s + ">" + EscapeString.escapeHtml(_valeur) + "</textarea>";
        return s;
    }

    protected static String renvoyerValeurFormatage(String _format, String _nomParametre) {
        String res = FormateurJSP.renvoyerValeurFormatageMinus(_format, _nomParametre);
        if (res != null) {
            res = res.toUpperCase();
        }
        return res;
    }

    protected static String renvoyerValeurFormatageMinus(String _format, String _nomParametre) {
        String res = null;
        StringTokenizer st = new StringTokenizer(_format, ",");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            if (val.toLowerCase().indexOf(_nomParametre.toLowerCase()) != 0) continue;
            if (_nomParametre.length() + 1 < val.length()) {
                res = val.substring(_nomParametre.length() + 1);
                continue;
            }
            res = "";
        }
        return res;
    }

    private String transformerFormat(String format) {
        String result = StringUtils.replace((String)format, (String)"\"", (String)" ");
        return StringUtils.replace((String)result, (String)"'", (String)"'");
    }

    public static Vector<String> trierHashtableParCle(Hashtable<String, String> h) {
        Vector<String> vCle = new Vector<String>();
        Vector<String> vLibelle = new Vector<String>();
        FormateurJSP.decomposerHashtable(h, vCle, vLibelle, true);
        return vCle;
    }

    public static Vector<String> trierHashtableParLibelle(Hashtable<String, String> h) {
        Vector<String> vCle = new Vector<String>();
        Vector<String> vLibelle = new Vector<String>();
        FormateurJSP.decomposerHashtable(h, vCle, vLibelle, false);
        return vCle;
    }

    public int getIndiceChamp() {
        return this.indiceChamp;
    }

    public void setIndiceChamp(int indiceChamp) {
        this.indiceChamp = indiceChamp;
    }

    public int getIndiceRadio() {
        return this.indiceRadio;
    }

    public void setIndiceRadio(int indiceRadio) {
        this.indiceRadio = indiceRadio;
    }

    public String genererHiddenInputs(boolean tmpField, String nomDonnee, int optionModification, String format, InfoBean infoBean, int context) {
        StringBuilder result = new StringBuilder();
        String szTmp = nomDonnee;
        if (szTmp.startsWith("TMP_")) {
            szTmp = szTmp.substring(4);
        }
        String value = "";
        if (infoBean.get(nomDonnee) != null) {
            value = infoBean.getString(nomDonnee);
        }
        String ariane = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] values = value.split(";");
            Object[] tips = new String[values.length];
            block5: for (int i = 0; i < values.length; ++i) {
                switch (context) {
                    case 2: {
                        tips[i] = RubriquesJsTree.getPath("", values[i], " > ");
                        continue block5;
                    }
                    case 1: {
                        tips[i] = StructuresJsTree.getPath("", values[i], " > ");
                        continue block5;
                    }
                    case 3: 
                    case 4: {
                        tips[i] = GroupsJsTree.getPath("", values[i], " > ");
                    }
                }
            }
            ariane = StringUtils.join((Object[])tips, (String)";");
        }
        String libelle = "";
        if (infoBean.get("LIBELLE_" + nomDonnee) != null) {
            libelle = infoBean.getString("LIBELLE_" + nomDonnee);
        }
        result.append("<!-- DEBUT GESTION LISTE ").append(szTmp).append(" -->\n");
        result.append("<input type=\"hidden\" name=\"#FORMAT_").append(szTmp).append("\" value=\"").append(optionModification).append(";").append(1).append(";0;0;").append(this.transformerFormat(format)).append(";").append(this.indiceChamp++).append("\" />");
        result.append("<input type=\"hidden\" id =\"").append(szTmp).append("\" name=\"").append(szTmp).append("\" value=\"").append(EscapeString.escapeAttributHtml(value)).append("\" ").append(optionModification == 2 ? "required=\"required\"" : "").append("/>\n");
        result.append("<input type=\"hidden\" name=\"LIBELLE_").append(nomDonnee).append("\" value=\"").append(EscapeString.escapeAttributHtml(libelle)).append("\"/>\n");
        if (tmpField) {
            result.append("<input type=\"hidden\" name=\"ARIANE_").append(nomDonnee).append("\" value=\"").append(EscapeString.escapeAttributHtml(ariane)).append("\"/>\n");
            result.append("<input type=\"hidden\" name=\"TMP_").append(nomDonnee).append("\" value=\"\"/>\n");
        }
        result.append(LN);
        return result.toString();
    }

    public String genererListe(Writer out, InfoBean infoBean, String nomDonnee, int optionModification, Map<String, String> table, String format, int context) {
        if (optionModification == -1) {
            return "";
        }
        StringBuilder htmlList = new StringBuilder();
        try {
            if (optionModification == 0) {
                String szTmp = nomDonnee;
                if (nomDonnee.startsWith("TMP_")) {
                    szTmp = szTmp.substring(4);
                }
                String valeurDonnee = StringUtils.defaultString((String)infoBean.getString(szTmp));
                StringTokenizer stValeurs = new StringTokenizer(valeurDonnee, ";");
                int i = 0;
                while (stValeurs.hasMoreTokens()) {
                    String valeurTable = StringUtils.defaultString((String)table.get(stValeurs.nextToken()));
                    if (i > 0) {
                        out.write(",");
                    }
                    htmlList.append("<li class=\"ignore\" data-value=\"").append(EscapeString.escapeAttributHtml(valeurDonnee)).append("\" title=\"").append(valeurTable).append("\">").append(valeurTable).append("</li>");
                    ++i;
                }
                htmlList.append(LN);
            } else {
                Object o = infoBean.get(nomDonnee);
                if (o != null) {
                    StringUtils.defaultString((String)o.toString());
                }
                String libelleItem = null;
                Vector<String> vector = new Vector<String>(table.size());
                for (String cleItem : table.keySet()) {
                    String elemVect;
                    Enumeration v;
                    int i;
                    if (!StringUtils.isNotBlank((CharSequence)cleItem)) continue;
                    libelleItem = table.get(cleItem);
                    if (format.contains("PAS_DE_TRI")) {
                        vector.insertElementAt(libelleItem + "," + cleItem, 0);
                        continue;
                    }
                    if (format.contains("TRI_CLE_NUM")) {
                        i = 0;
                        v = vector.elements();
                        while (v.hasMoreElements()) {
                            String cleElemVect;
                            float valCleElemVect;
                            elemVect = (String)v.nextElement();
                            float valCleItem = Float.parseFloat(cleItem);
                            if (!(valCleItem > (valCleElemVect = Float.parseFloat(cleElemVect = elemVect.substring(elemVect.indexOf(",") + 1))))) continue;
                            ++i;
                        }
                        vector.insertElementAt(libelleItem + "," + cleItem, i);
                        continue;
                    }
                    if (format.contains("TRI_CLE")) {
                        i = 0;
                        v = vector.elements();
                        while (v.hasMoreElements()) {
                            elemVect = (String)v.nextElement();
                            String cleElemVect = elemVect.substring(elemVect.lastIndexOf(",") + 1);
                            if (cleItem.compareTo(cleElemVect) <= 0) continue;
                            ++i;
                        }
                        vector.insertElementAt(libelleItem + "," + cleItem, i);
                        continue;
                    }
                    i = 0;
                    Collator collator = Collator.getInstance(Locale.FRANCE);
                    Enumeration v2 = vector.elements();
                    while (v2.hasMoreElements() && collator.compare(libelleItem, (String)v2.nextElement()) > 0) {
                        ++i;
                    }
                    vector.insertElementAt(libelleItem + "," + cleItem, i);
                }
                Iterator<String> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    String element;
                    String nextElt = element = iterator.next();
                    String cleItem = "";
                    if (nextElt.contains(",")) {
                        libelleItem = nextElt.substring(0, nextElt.lastIndexOf(","));
                        cleItem = nextElt.substring(nextElt.lastIndexOf(",") + 1);
                    } else {
                        libelleItem = nextElt;
                    }
                    htmlList.append("<li data-value=\"").append(EscapeString.escapeAttributHtml(cleItem)).append("\" ").append(" title=\"").append(libelleItem).append("\">").append(libelleItem).append("</li>");
                    htmlList.append(LN);
                }
            }
        }
        catch (Exception e) {
            LOG.error("erreur sur a g\u00e9n\u00e9ration d'une liste", (Throwable)e);
        }
        return htmlList.toString();
    }

    private String generateAttributeForm(String codeFormulaire) {
        if (StringUtils.isEmpty((CharSequence)codeFormulaire)) {
            return "";
        }
        return "form=\"" + codeFormulaire + "\"";
    }
}

