/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.Data;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBeanFilter;
import com.jsbsoft.jtf.core.TypeMessage;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.webapp.WebAppUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoBean
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(InfoBean.class);
    private static final long serialVersionUID = 1L;
    public static final String ECRAN_LOGIQUE_FIN = "FIN";
    public static final String ECRAN_LOGIQUE = "#ECRAN_LOGIQUE#";
    protected static final String ECRAN_REDIRECTION = "#ECRAN_REDIRECTION#";
    private static final String ECRAN_PHYSIQUE = "#ECRAN_PHYSIQUE#";
    private static final String TITRE_ECRAN = "#TITRE_ECRAN#";
    private static final String ECRAN_CONTENEUR = "#ECRAN_CONTENEUR#";
    private static final String ID_COMPOSANT = "#ID_COMPOSANT#";
    private static final String UPLOADED_FILE = "#FILE#";
    protected static final String MODE_ENCHAINEMENT = "#MODE_ENCHAINEMENT#";
    protected static final String ID_JSP = "#ID_JSP#";
    protected static final String BEANPU = "BEANPU";
    public static final String PROC = "PROC";
    public static final String EXT = "EXT";
    public static final String ACTION = "ACTION";
    public static final String ETAT_OBJET = "#ETAT#";
    public static final String ETAT_OBJET_MODIF = "MODIFICATION";
    public static final String ETAT_OBJET_CREATION = "CREATION";
    public static final String ETAT_OBJET_SUPPRESSION = "SUPPRESSION";
    public static final String ETAT_OBJET_RECHERCHE = "RECHERCHE";
    public static final String ACTION_VALIDER = "VALIDER";
    public static final String ACTION_ABANDON = "ABANDON";
    public static final String ACTION_REVENIR = "REVENIR";
    public static final String ACTION_ANNULER = "ANNULER";
    public static final String ACTION_SUPPRIMER = "SUPPRIMER";
    public static final String ACTION_RECHERCHER = "RECHERCHER";
    public static final String ACTION_CONFIRMER = "CONFIRMER";
    public static final String ACTION_DETAIL = "DETAIL";
    public static final String ACTION_AJOUTER = "AJOUTER";
    public static final String ACTION_CREER = "CREER";
    public static final String ACTION_SUITE = "SUITE";
    public static final String ACTION_MODIFIER = "MODIFIER";
    public static final String ACTION_TRADUIRE = "TRADUIRE";
    public static final String ACTION_DUPLIQUER = "DUPLIQUER";
    public static final String ACTION_ONGLET = "ONGLET";
    public static final String LIBELLE_DUPLICATION = "Copie";
    public static final String LIBELLE_TRADUCTION = "Traduction";
    private Map<String, Data> datas = new HashMap<String, Data>(100);
    private Map<String, List<String>> messages = new HashMap<String, List<String>>();
    private InfoBean infoBeanPere = null;
    public static final String ACTION_ENREGISTRER = "ENREGISTRER";
    protected static final String NOM_NOUVEL_ONGLET = "NOUVEL_ONGLET";
    private static final String NOM_ONGLET = "#ONGLET#";
    private transient HttpSession sessionHttp = null;
    private static long tsLastPurge = 0L;
    private static final long DELAI_PURGE = 600000L;
    private static final long DELAI_EXPIRATION = 3600000L;

    public InfoBean() {
    }

    public InfoBean(InfoBean pere) {
        this.infoBeanPere = pere;
    }

    public String formater(String name) {
        return Formateur.formater(this.get(name, true));
    }

    public String formaterLibelle(String name, String table) {
        return Formateur.formaterLibelle(this.getNomExtension(), this.get(name, true), table);
    }

    public Object get(String name) {
        return this.get(name, true);
    }

    public Object get(String name, boolean recursif) {
        Data data = this.datas.get(name);
        Object value = null;
        if (data == null) {
            if (recursif && this.infoBeanPere != null) {
                value = this.infoBeanPere.get(name, true);
            }
        } else {
            value = data.getValue();
        }
        return value;
    }

    public <T> T get(String name, Class<T> clazz) {
        Object data = this.get(name, true);
        if (clazz.isInstance(data)) {
            return clazz.cast(data);
        }
        return null;
    }

    public <T> Set<T> getHashSet(String name) {
        return (HashSet)this.get(name);
    }

    public <T> Collection<T> getCollection(String name) {
        return (Collection)this.get(name);
    }

    public <T> List<T> getList(String name) {
        return (List)this.get(name);
    }

    public <T1, T2> Map<T1, T2> getMap(String name) {
        return (Map)this.get(name);
    }

    public String getActionUtilisateur() {
        return (String)this.get(ACTION);
    }

    public String getEcranLogique() {
        return (String)this.get(ECRAN_LOGIQUE);
    }

    public String getEcranRedirection() {
        return (String)this.get(ECRAN_REDIRECTION);
    }

    public String getEcranPhysique() {
        return (String)this.get(ECRAN_PHYSIQUE);
    }

    public String getEcranConteneur() {
        return (String)this.get(ECRAN_CONTENEUR);
    }

    public String getIdComposant() {
        return (String)this.get(ID_COMPOSANT);
    }

    public String getEtatObjet() {
        return (String)this.get(ETAT_OBJET);
    }

    public String getIDJSP() {
        return (String)this.get(ID_JSP);
    }

    public String getBEANPU() {
        return (String)this.get(BEANPU);
    }

    public int getInt(String name) {
        return (Integer)this.get(name, true);
    }

    public Long getLong(String name) {
        return (Long)this.get(name, true);
    }

    public Integer getInteger(String name) {
        return new Integer((String)this.get(name, true));
    }

    public String getMessageErreur() {
        return this.getMessage(TypeMessage.ERREUR.getCode());
    }

    public String getMessageConfirmation() {
        return this.getMessage(TypeMessage.CONFIRMATION.getCode());
    }

    public String getMessageAlerte() {
        return this.getMessage(TypeMessage.ALERTE.getCode());
    }

    private String getMessage(String code) {
        String res = "";
        if (this.messages.get(code) != null) {
            for (String message : this.messages.get(code)) {
                res = res + (res.length() > 0 ? ", " : "") + message;
            }
        } else if (this.get(code) != null) {
            res = (String)this.get(code);
        }
        return res;
    }

    public Map<String, List<String>> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, List<String>> messages) {
        this.messages = messages;
    }

    public void setMessagesDansInfoBeanPere() {
        if (this.infoBeanPere != null && MapUtils.isNotEmpty(this.messages)) {
            this.infoBeanPere.setMessages(this.messages);
        }
    }

    public int getModeEnchainement() {
        return this.getInt(MODE_ENCHAINEMENT);
    }

    public String getNomProcessus() {
        return (String)this.get(PROC);
    }

    public String getNomExtension() {
        return (String)this.get(EXT);
    }

    public UploadedFile getUploadedFile() {
        return ((UploadedFile[])this.get(UPLOADED_FILE))[0];
    }

    public UploadedFile[] getUploadedFiles() {
        return (UploadedFile[])this.get(UPLOADED_FILE);
    }

    public boolean isControled(String name) {
        Data data = this.datas.get(name);
        boolean controled = false;
        if (data == null) {
            if (this.infoBeanPere != null) {
                controled = this.infoBeanPere.isControled(name);
            }
        } else {
            controled = data.isControled();
        }
        return controled;
    }

    public boolean isRequired(String name) {
        Data data = this.datas.get(name);
        boolean required = false;
        if (data != null) {
            required = data.isRequired();
        }
        return required;
    }

    public void remove(String name) {
        if (name != null) {
            this.datas.remove(name);
        }
    }

    public void removeMessage(String code) {
        if (code != null) {
            this.messages.remove(code);
        }
    }

    public void require(String name) {
        Data data = this.datas.get(name);
        if (data == null) {
            data = new Data(name, null, true);
            this.datas.put(name, data);
        } else {
            data.setRequired(true);
        }
    }

    public void set(String name, Object value) {
        Data data = this.datas.get(name);
        if (data == null) {
            this.datas.put(name, new Data(name, value, false));
        } else {
            data.setValue(value);
            data.setRequired(false);
            data.setControled(true);
        }
    }

    private void addMessage(String name, String value) {
        if (this.messages.get(name) == null) {
            this.messages.put(name, new ArrayList());
            if (this.get(name) != null) {
                this.messages.get(name).add((String)this.get(name));
            }
        }
        if (!this.messages.get(name).contains(value)) {
            this.messages.get(name).add(value);
        }
    }

    public void setActionUtilisateur(String newAction) {
        this.set(ACTION, newAction);
    }

    public void setAndRequire(String name, Object value) {
        Data data = this.datas.get(name);
        if (data == null) {
            this.datas.put(name, new Data(name, value, true));
        } else {
            data.setValue(value);
            data.setRequired(true);
            data.setControled(true);
        }
    }

    public void setDonneeSaisie(String name, Object value) {
        Data data = this.datas.get(name);
        if (data == null) {
            this.datas.put(name, new Data(name, value, false, false));
        } else {
            data.setValue(value);
            data.setRequired(false);
            data.setControled(false);
        }
    }

    public void setEcranLogique(String newEcranLogique) {
        this.set(ECRAN_LOGIQUE, newEcranLogique);
    }

    public void setEcranRedirection(String newRedirection) {
        this.set(ECRAN_REDIRECTION, newRedirection);
    }

    public void setEcranLogiqueFin() {
        this.setEcranLogique(ECRAN_LOGIQUE_FIN);
    }

    public void setEcranPhysique(String newEcranPhysique) {
        this.set(ECRAN_PHYSIQUE, newEcranPhysique);
    }

    public void setEcranConteneur(String newEcranConteneur) {
        this.set(ECRAN_CONTENEUR, newEcranConteneur);
    }

    public void setIdComposant(String idComposant) {
        this.set(ID_COMPOSANT, idComposant);
    }

    public void setEtatObjet(String newEtat) {
        this.set(ETAT_OBJET, newEtat);
    }

    public void setIDJSP(String newIDJSP) {
        this.set(ID_JSP, newIDJSP);
    }

    public void setBEANPU(String newIDBEAN) {
        this.set(BEANPU, newIDBEAN);
    }

    public void setInt(String name, int value) {
        this.set(name, value);
    }

    @Deprecated
    public void setMessageErreur(String newMsg) {
        this.addMessageErreur(newMsg);
    }

    public void addMessageErreur(String newMsg) {
        this.addMessage(TypeMessage.ERREUR.getCode(), newMsg);
    }

    public void addMessageConfirmation(String newMsg) {
        this.addMessage(TypeMessage.CONFIRMATION.getCode(), newMsg);
    }

    public void addMessageAlerte(String newMsg) {
        this.addMessage(TypeMessage.ALERTE.getCode(), newMsg);
    }

    public void setModeEnchainement(int mode) {
        this.setInt(MODE_ENCHAINEMENT, mode);
    }

    public void setNomProcessus(String processus) {
        this.set(PROC, processus);
    }

    public void setNomExtension(String processus) {
        this.set(EXT, processus);
    }

    public void setUploadedFile(UploadedFile _file) {
        UploadedFile[] files = new UploadedFile[]{_file};
        this.set(UPLOADED_FILE, files);
    }

    public void setUploadedFiles(UploadedFile[] file) {
        this.set(UPLOADED_FILE, file);
    }

    public String toString() {
        String chaine = "";
        for (Data data : this.datas.values()) {
            if (chaine.length() >= 500) continue;
            chaine = chaine + "\t\t" + data.toString() + "\r\n";
        }
        if (chaine.length() >= 500) {
            chaine = chaine + "\t\t(...)\r\n";
        }
        return chaine;
    }

    protected Map<String, Data> getDatas() {
        return this.datas;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (String key : this.datas.keySet()) {
            res.put(key, this.datas.get((Object)key).value);
        }
        return res;
    }

    public void setValues(Map<String, Object> map) {
        for (String key : map.keySet()) {
            this.set(key, map.get(key));
        }
    }

    public Collection<String> getDataKeys() {
        return this.getDatas().keySet();
    }

    protected void setDatas(Map<String, Data> _datas) {
        this.datas = _datas;
    }

    public String getNouvelOnglet() {
        String res = (String)this.get(NOM_NOUVEL_ONGLET);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getOnglet() {
        String res = (String)this.get(NOM_ONGLET);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public HttpSession getSessionHttp() {
        return this.sessionHttp;
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public Date getDate(String name) {
        return (Date)this.get(name);
    }

    protected void setData(String name, Data data) {
        this.datas.put(name, data);
    }

    public void setOnglet(String _nomOnglet) {
        this.set(NOM_ONGLET, _nomOnglet);
    }

    protected void setSessionHttp(HttpSession newSessionHttp) {
        this.sessionHttp = newSessionHttp;
    }

    public String getTitreEcran() {
        return (String)this.get(TITRE_ECRAN);
    }

    public void setTitreEcran(String titre) {
        this.set(TITRE_ECRAN, titre);
    }

    public synchronized void purgerFichiers(String ksession, String typeListe) throws Exception {
        long tsCourant;
        InfoBeanFilter filtre;
        File folder = new File(WebAppUtil.getWorkDefaultPath());
        File[] listeFiles = folder.listFiles(filtre = new InfoBeanFilter(ksession, typeListe));
        if (listeFiles.length > 5) {
            TreeSet<File> listeTriee = new TreeSet<File>(Arrays.asList(listeFiles));
            listeTriee.first().delete();
        }
        if ((tsCourant = System.currentTimeMillis()) - tsLastPurge > 600000L) {
            tsLastPurge = tsCourant;
            LOG.debug("Purge des fichiers de sessions");
            filtre = new InfoBeanFilter("", "");
            for (File listeFile : listeFiles = folder.listFiles(filtre)) {
                long tsFile = listeFile.lastModified();
                if (tsFile == 0L || tsCourant - tsFile <= 3600000L) continue;
                listeFile.delete();
            }
        }
    }

    public String sauvegarderDansFichier(HttpServletRequest request, String typeListe) throws Exception {
        HttpSession _session = request.getSession(false);
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)_session.getAttribute("session");
        Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
        String ksession = (String)infosSession.get("KSESSION");
        String idFichier = typeListe + "_" + System.currentTimeMillis();
        String pathFichier = WebAppUtil.getWorkDefaultPath() + File.separator + "datas_" + ksession + "_" + idFichier + ".tmp";
        FileOutputStream fos = null;
        ObjectOutputStream output = null;
        fos = new FileOutputStream(pathFichier);
        output = new ObjectOutputStream(fos);
        output.writeObject(this);
        output.close();
        fos.close();
        this.purgerFichiers(ksession, typeListe);
        return idFichier;
    }

    public static InfoBean restaurerDepuisFichier(HttpServletRequest request, String idFichier) throws Exception {
        HttpSession _session = request.getSession(false);
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)_session.getAttribute("session");
        Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
        String ksession = (String)infosSession.get("KSESSION");
        int count = (Integer)(infosSession.get(idFichier) != null ? infosSession.get(idFichier) : Integer.valueOf(1)) + 1;
        infosSession.put(idFichier, count);
        String pathFichier = WebAppUtil.getWorkDefaultPath() + File.separator + "datas_" + ksession + "_" + idFichier + ".tmp";
        FileInputStream fis = null;
        ObjectInputStream in = null;
        fis = new FileInputStream(pathFichier);
        in = new ObjectInputStream(fis);
        InfoBean infoBean = (InfoBean)in.readObject();
        in.close();
        fis.close();
        infoBean.setSessionHttp(_session);
        return infoBean;
    }

    public static void supprimerDatas(String _ksession) {
        File[] listeFiles;
        File folder = new File(WebAppUtil.getWorkDefaultPath());
        InfoBeanFilter filtre = new InfoBeanFilter(_ksession, "");
        for (File listeFile : listeFiles = folder.listFiles(filtre)) {
            listeFile.delete();
        }
    }

    public List<String> getMessages(String code) {
        if (TypeMessage.valueOf(code) != null) {
            return this.messages.get(code);
        }
        return new ArrayList<String>();
    }
}

