/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.Langue;
import com.kportal.core.config.LangueConfig;
import com.kportal.core.config.MessageLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangueUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LangueUtil.class);
    public static final int DEFAULT_LANGUE_INDICE = 0;

    public static String construireLibelleMultiLangue(String[] libelleLangue) {
        String libelle = "";
        for (int i = 0; i < LangueUtil.getNbLangues(); ++i) {
            libelle = i < libelleLangue.length ? libelle + libelleLangue[i] + ";" : libelle + ";";
        }
        return libelle;
    }

    public static String[] decomposerLibelleMultiLangue(String libelle) {
        String[] libelleLangue = new String[LangueUtil.getNbLangues()];
        int indice = 0;
        for (int i = 0; i < LangueUtil.getNbLangues(); ++i) {
            int nextSeparator = libelle.indexOf(";", indice);
            if (nextSeparator != -1) {
                libelleLangue[i] = libelle.substring(indice, nextSeparator);
                indice = nextSeparator + 1;
                continue;
            }
            libelleLangue[i] = "";
        }
        return libelleLangue;
    }

    public static String extraireDefaultLibelleMultiLangue(String libelle) {
        return LangueUtil.extraireLibelleMultiLangue(libelle, Locale.FRANCE);
    }

    public static String extraireLibelleMultiLangue(String libelle, Locale _locale) {
        String[] libelles = LangueUtil.decomposerLibelleMultiLangue(libelle);
        int indice = LangueUtil.getIndiceLocale(_locale);
        return libelles[indice];
    }

    public static String getDisplayName(String _indiceLocale) {
        int indice = LangueUtil.getIndiceLocale(_indiceLocale);
        if (indice != -1) {
            return LangueUtil.getDisplayName(indice);
        }
        return "";
    }

    public static String getDisplayName(int _indiceLocale) {
        return LangueUtil.getLocale(_indiceLocale).getDisplayLanguage(LangueUtil.getDefaultLocale());
    }

    public static String[] getDisplayNames() {
        String[] labels = new String[LangueUtil.getNbLangues()];
        int i = 0;
        for (Langue langue : LangueUtil.getLangues().values()) {
            labels[i] = langue.getLocale().getDisplayLanguage(LangueUtil.getDefaultLocale());
            ++i;
        }
        return labels;
    }

    public static int getIndiceLocale(Locale _locale) {
        int indice = -1;
        for (Langue langue : LangueUtil.getLangues().values()) {
            if (!langue.getLocale().equals(_locale)) continue;
            indice = langue.getIndice();
        }
        return indice;
    }

    public static Locale getDefaultLocale() {
        return LangueUtil.getLocale(0);
    }

    public static int getIndiceFromCodeISO(String codeISO) {
        int indiceLocale = -1;
        for (Langue langue : LangueUtil.getLangues().values()) {
            if (!langue.getLocale().getLanguage().equalsIgnoreCase(codeISO)) continue;
            indiceLocale = langue.getIndice();
        }
        return indiceLocale;
    }

    public static String getLangueLocale(Locale _locale) {
        return Integer.toString(LangueUtil.getIndiceLocale(_locale));
    }

    @Deprecated
    public static Hashtable<String, String> getListeLangues() {
        return LangueUtil.getListeLangues(Locale.FRANCE);
    }

    public static Hashtable<String, String> getListeLangues(Locale locale) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int i = 0;
        for (Langue langue : LangueUtil.getLangues().values()) {
            String libelle = langue.getLocale().getDisplayName(locale);
            int indice = libelle.indexOf("(");
            if (indice != -1) {
                libelle = libelle.substring(0, indice);
            }
            h.put("" + i, libelle);
            ++i;
        }
        return h;
    }

    public static Locale getLocale(int indice) {
        if (LangueUtil.getLangues().get(indice) != null) {
            return LangueUtil.getLangues().get(indice).getLocale();
        }
        return null;
    }

    public static String getPathImageDrapeau(String indiceLocale) {
        int indice = LangueUtil.getIndiceLocale(indiceLocale);
        if (indice != -1) {
            return LangueUtil.getLangues().get(indice).getUrl() + "/" + "drapeau.png";
        }
        return "";
    }

    public static String getPathImageDrapeau(Locale locale) {
        int indice = LangueUtil.getIndiceLocale(locale);
        if (indice != -1) {
            return LangueUtil.getLangues().get(indice).getUrl() + "/" + "drapeau.png";
        }
        return "";
    }

    public static Locale getLocale(String indiceLocale) {
        Locale locale = LangueUtil.getLocale(LangueUtil.getIndiceLocale(indiceLocale));
        if (locale == null) {
            locale = LangueUtil.getDefaultLocale();
        }
        return locale;
    }

    @Deprecated
    public static String getMessage(String indiceLocale, String key) {
        return LangueUtil.getMessage(LangueUtil.getLocale(indiceLocale), key);
    }

    @Deprecated
    public static String getMessage(Locale locale, String key) {
        String res;
        if (locale == null || !LangueUtil.isActiveLocale(locale)) {
            locale = LangueUtil.getDefaultLocale();
        }
        if ((res = MessageLoader.getInstance().getProperties(LangueUtil.getLanguageCountry(locale)).getProperty(key)) == null && !key.contains(".")) {
            LOG.warn("Chaine " + key + " absente des messages " + locale.getCountry());
            if (!locale.getCountry().equals(LangueUtil.getDefaultLocale().getCountry())) {
                res = LangueUtil.getMessage(LangueUtil.getDefaultLocale(), key);
            }
        }
        if (StringUtils.isEmpty((CharSequence)res)) {
            res = "";
        }
        return res;
    }

    public static boolean isActiveLocale(Locale locale) {
        return LangueUtil.getIndiceLocale(locale) != -1;
    }

    private static int getIndiceLocale(String indiceLocale) {
        if (StringUtils.isNotBlank((CharSequence)indiceLocale) && StringUtils.isNumeric((CharSequence)indiceLocale)) {
            int res = Integer.parseInt(indiceLocale);
            if (LangueUtil.getLangues().get(res) != null) {
                return res;
            }
        }
        return -1;
    }

    @Deprecated
    public static String getMessage(OMContext ctx, String key) {
        String res = LangueUtil.getMessage(ctx.getLocale(), key);
        if (StringUtils.isEmpty((CharSequence)res)) {
            res = LangueUtil.getMessage(LangueUtil.getDefaultLocale(), key);
        }
        return res;
    }

    public static String getLanguageCountry(Locale locale) {
        String res = locale.getLanguage();
        if (StringUtils.isNotEmpty((CharSequence)locale.getCountry())) {
            res = res + "_" + locale.getCountry();
        }
        return res;
    }

    public static LangueConfig getLangueConfig() {
        return (LangueConfig)ApplicationContextManager.getCoreContextBean("langueConfig");
    }

    public static int getNbLangues() {
        return LangueUtil.getLangueConfig().getNbLangues();
    }

    public static Map<Integer, Langue> getLangues() {
        return LangueUtil.getLangueConfig().getLangues();
    }

    @Deprecated
    public static Locale getLocaleBO() {
        return LangueUtil.getLocale(LangueUtil.getLangueConfig().getIndiceLangueBo());
    }

    public static List<Locale> getLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        for (Langue langue : LangueUtil.getLangues().values()) {
            list.add(langue.getLocale());
        }
        return list;
    }

    public static Locale getEffectiveLocale(Locale locale) {
        Locale currentLocale = locale;
        List<Locale> allLocales = LangueUtil.getLocales();
        if (!allLocales.contains(locale)) {
            Boolean hasLocaleByLanguage = Boolean.FALSE;
            for (int i = 0; !hasLocaleByLanguage.booleanValue() && i < allLocales.size(); ++i) {
                Locale appDefineLocale = allLocales.get(i);
                if (!appDefineLocale.getLanguage().equals(locale.getLanguage())) continue;
                currentLocale = appDefineLocale;
                hasLocaleByLanguage = Boolean.TRUE;
            }
            if (!hasLocaleByLanguage.booleanValue()) {
                currentLocale = LangueUtil.getDefaultLocale();
            }
        }
        return currentLocale;
    }
}

