/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.core.config.PropertyConfigurer;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class LogAppFilter
implements Filter {
    public static final String FILE_NAME_REQUETES = "requetes";
    private static final String LOGAPP_APPENDER_NAME = "LOGAPP";
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(LogAppFilter.class);
    private static final String PROP_LOGAPP_FILTER = "logapp.filter";
    private AsyncAppender asyncAppender = null;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filter) throws IOException, ServletException {
        if (this.isActivated()) {
            long timerStart = System.currentTimeMillis();
            String uuid = UUID.randomUUID().toString();
            HttpServletRequest request = (HttpServletRequest)req;
            String codeSite = "";
            String userAgent = "";
            String hostReferer = "";
            String remoteAddr = "";
            SessionUtilisateur sessionUtilisateur = null;
            String url = request.getRequestURI();
            String requete = request.getQueryString();
            try {
                HttpSession _session;
                InfosSite infosSite = Site.renvoyerItemSiteParHost(request.getServerName());
                codeSite = infosSite.getAlias();
                if (request.getHeader("referer") != null && request.getHeader("referer").length() > 0 && (hostReferer = request.getHeader("referer")) != null) {
                    if (requete == null && hostReferer.indexOf("?") != -1) {
                        requete = hostReferer.substring(hostReferer.indexOf("?") + 1) + "(referer)";
                    }
                    if (hostReferer.indexOf("//") != -1) {
                        if ((hostReferer = hostReferer.substring(hostReferer.indexOf("//") + 2)).indexOf("/") != -1) {
                            hostReferer = hostReferer.substring(0, hostReferer.indexOf("/"));
                        }
                        if (hostReferer.indexOf(":") != -1) {
                            hostReferer = hostReferer.substring(0, hostReferer.indexOf(":"));
                        }
                    }
                }
                if (request.getHeader("user-agent") != null && request.getHeader("user-agent").length() > 0) {
                    userAgent = request.getHeader("user-agent");
                }
                remoteAddr = request.getRemoteAddr();
                if (request.getHeader("REMOTE_ADDR") != null && request.getHeader("REMOTE_ADDR").length() > 0) {
                    remoteAddr = request.getHeader("REMOTE_ADDR");
                }
                if ((_session = request.getSession(false)) != null) {
                    sessionUtilisateur = (SessionUtilisateur)_session.getAttribute("session");
                }
                this.logTraceActiviteWeb(sessionUtilisateur, uuid, 0L, hostReferer, remoteAddr, userAgent, codeSite, url, requete, null);
                Map<String, String> postParams = null;
                this.logTraceActiviteWeb(sessionUtilisateur, uuid, timerStart, hostReferer, remoteAddr, userAgent, codeSite, url, requete, postParams);
            }
            catch (Throwable throwable) {
                Map<String, String> postParams = null;
                this.logTraceActiviteWeb(sessionUtilisateur, uuid, timerStart, hostReferer, remoteAddr, userAgent, codeSite, url, requete, postParams);
                throw throwable;
            }
        }
        filter.doFilter(req, res);
    }

    private void logTraceActiviteWeb(SessionUtilisateur sessionUtilisateur, String uuid, long timerStart, String hostReferer, String ip, String userAgent, String codeSite, String url, String requete, Map<String, String> paramsPost) {
        try {
            long timerNow = System.currentTimeMillis();
            Hashtable<String, Object> infosSession = null;
            if (sessionUtilisateur != null) {
                infosSession = sessionUtilisateur.getInfos();
            }
            String logLine = uuid + ";" + timerNow + ";" + (timerStart > 0L ? Long.valueOf(timerNow - timerStart) : "") + ";" + ip + ";";
            logLine = logLine + (infosSession != null ? (String)infosSession.get("KSESSION") : "") + ";" + (infosSession != null && infosSession.get("CODE") != null ? (String)infosSession.get("CODE") : "") + ";" + codeSite + ";;;" + url + ";" + (requete != null ? requete : "") + ";";
            logLine = logLine + hostReferer + ";\"" + userAgent + "\";";
            LOGGER.trace(logLine);
        }
        catch (Exception e) {
            LOGGER.error("Impossible de tracer l'activite web : ", (Throwable)e);
        }
    }

    public boolean isActivated() {
        if (!"1".equals(PropertyHelper.getCoreProperty(PROP_LOGAPP_FILTER))) {
            if (this.asyncAppender != null) {
                LOGGER.detachAppender((Appender)this.asyncAppender);
                this.asyncAppender.stop();
                this.asyncAppender = null;
            }
            return Boolean.FALSE;
        }
        if (this.asyncAppender == null) {
            this.asyncAppender = new AsyncAppender();
            this.asyncAppender.setDiscardingThreshold(0);
            this.asyncAppender.setContext((Context)LOGGER.getLoggerContext());
            this.asyncAppender.setName(LOGAPP_APPENDER_NAME);
            RollingFileAppender fileAppender = new RollingFileAppender();
            fileAppender.setContext((Context)LOGGER.getLoggerContext());
            File folderApp = new File(WebAppUtil.getLogsPath() + File.separator + "app");
            if (!folderApp.exists()) {
                folderApp.mkdir();
            }
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setPattern("%d{HH:mm:ss,SSS};%m %n");
            encoder.setContext((Context)LOGGER.getLoggerContext());
            DefaultTimeBasedFileNamingAndTriggeringPolicy timeTrigger = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
            timeTrigger.setContext((Context)LOGGER.getLoggerContext());
            TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
            policy.setContext((Context)LOGGER.getLoggerContext());
            policy.setFileNamePattern(folderApp.getAbsolutePath() + File.separator + FILE_NAME_REQUETES + ".log" + "." + PropertyConfigurer.getProperty("logs.fileNamePattern"));
            policy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)timeTrigger);
            if (StringUtils.isNotEmpty((CharSequence)PropertyConfigurer.getProperty("logs.maxHistory"))) {
                try {
                    policy.setMaxHistory(Integer.parseInt(PropertyConfigurer.getProperty("logs.maxHistory")));
                }
                catch (Exception e) {
                    LOGGER.error("La valeur de la propri\u00e9t\u00e9e \"logs.maxHistory\" n'est pas num\u00e9rique");
                }
            }
            timeTrigger.setTimeBasedRollingPolicy(policy);
            fileAppender.setRollingPolicy((RollingPolicy)policy);
            fileAppender.setEncoder((Encoder)encoder);
            fileAppender.setFile(folderApp.getAbsolutePath() + File.separator + FILE_NAME_REQUETES + ".log");
            fileAppender.setAppend(true);
            policy.setParent((FileAppender)fileAppender);
            policy.start();
            encoder.start();
            fileAppender.start();
            this.asyncAppender.addAppender((Appender)fileAppender);
            this.asyncAppender.setQueueSize(1500);
            this.asyncAppender.start();
            LOGGER.addAppender((Appender)this.asyncAppender);
            LOGGER.setLevel(Level.TRACE);
            LOGGER.setAdditive(false);
        }
        return Boolean.TRUE;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

