/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.kportal.core.config.PropertyHelper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletResponse response = null;
    private final HttpServletRequest request = null;
    private static final Boolean isSecurise = "1".equals(PropertyHelper.getCoreProperty("https.cookies.securise"));
    private static final Logger LOG = LoggerFactory.getLogger(MyRequestWrapper.class);

    public MyRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpSession getSession() {
        HttpSession session = super.getSession();
        if (!isSecurise.booleanValue()) {
            this.processSessionCookie(session);
        }
        return session;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = null;
        session = isSecurise == false ? this.getCookieSessionNonSecurise(create) : super.getSession(create);
        return session;
    }

    private HttpSession getCookieSessionNonSecurise(boolean create) {
        HttpSession session = super.getSession(create);
        this.processSessionCookie(session);
        return session;
    }

    private void processSessionCookie(HttpSession session) {
        if (null == this.response || null == session) {
            LOG.debug("response or session is null");
            return;
        }
        Object cookieOverWritten = this.getAttribute("COOKIE_OVERWRITTEN_FLAG");
        LOG.debug("cookieOverWritten" + cookieOverWritten + " isSecure" + this.isSecure() + " isNew" + session.isNew() + " id = " + session.getId());
        if (null == cookieOverWritten && this.isSecure() && session.isNew()) {
            Cookie cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = this.getContextPath();
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            this.response.addCookie(cookie);
            this.setAttribute("COOKIE_OVERWRITTEN_FLAG", "true");
            LOG.debug("cookie overwritten");
        }
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }
}

