/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.AbstractProcessusBean;
import com.jsbsoft.jtf.core.Data;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.ProcedureBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurFormatage;
import com.jsbsoft.jtf.upload.ExtendedRequest;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserRequete {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserRequete.class);
    private ProcedureBean procedure = null;
    public static final String REFRESH_PARAM = "PARAM";

    public ParserRequete(ProcedureBean _procedure) {
        this.procedure = _procedure;
    }

    private Date controlerDate(String valeur, String cle, String formatSupplementaire) throws ErreurFormatage {
        Date res = null;
        try {
            res = Formateur.parserDate(valeur);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            if (StringUtils.isNotEmpty((CharSequence)valeur) && !valeur.equals(sdf.format(res))) {
                throw new Exception("Date not exist");
            }
        }
        catch (Exception e) {
            String msg = ParserRequete.getLibelleZone(cle, formatSupplementaire) + ", " + MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FMT_DATE");
            throw new ErreurFormatage(msg);
        }
        return res;
    }

    private int getIndice(String valeurFormat) throws ErreurApplicative {
        int indice = -1;
        if (valeurFormat != null) {
            int i = 0;
            StringTokenizer st = new StringTokenizer(valeurFormat, ";");
            while (st.hasMoreTokens()) {
                String format = st.nextToken();
                if (i == 5) {
                    try {
                        indice = Integer.parseInt(format);
                    }
                    catch (NumberFormatException e) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("ERREUR_FORMAT_INDICE_FORMULAIRE"));
                    }
                }
                ++i;
            }
        }
        return indice;
    }

    public void getUploadedFile(HttpServletRequest req) throws Exception {
        ExtendedRequest ereq = (ExtendedRequest)req;
        try {
            UploadedFile[] f = ereq.getFileParameterValues("FICHIER");
            if (f != null) {
                this.procedure.getInfoBean().setUploadedFiles(f);
                for (UploadedFile element : f) {
                    LOGGER.debug("fichier upload\u00e9 : " + element.getTemporaryFile().getPath());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void recueillirDonneesSaisies(HttpServletRequest req) {
        InfoBean information = this.procedure.getInfoBean();
        try {
            Object oCI;
            String valeurAction;
            String[] paramValues;
            String idJSP;
            Object valeurCI = null;
            LOGGER.debug("Traitement des donn\u00e9es ...");
            information.set("#user-agent", req.getHeader("user-agent"));
            information.set("#remote-addr", req.getRemoteAddr());
            if (this.procedure.getModeEnchainement() == 0 && (idJSP = req.getParameter("#ID_JSP#")) != null && !idJSP.equals(information.getIDJSP())) {
                information.setEcranLogique(req.getParameter("#ECRAN_LOGIQUE#"));
            }
            InfosSite infosSite = Site.renvoyerItemSiteParHost(req.getServerName());
            AbstractProcessusBean processus = this.procedure.getProcessus();
            if (processus instanceof ProcessusBean) {
                ((ProcessusBean)processus).setInfosSite(infosSite);
                ((ProcessusBean)processus).setSecure("https".equals(URLResolver.getRequestScheme(req)));
            }
            information.setActionUtilisateur("");
            boolean donneesAControlerSurActionCachee = false;
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String cle = (String)en.nextElement();
                if (cle.equals("VALIDER") || cle.equalsIgnoreCase("VALIDER.x")) {
                    information.setActionUtilisateur("VALIDER");
                    continue;
                }
                if (cle.equals("ENREGISTRER") || cle.equalsIgnoreCase("ENREGISTRER.x")) {
                    information.setActionUtilisateur("ENREGISTRER");
                    continue;
                }
                if (cle.equals("REVENIR") || cle.equals("REVENIR.x")) {
                    information.setActionUtilisateur("REVENIR");
                    continue;
                }
                if (cle.equals("ABANDON") || cle.equals("ABANDON.x")) {
                    information.setActionUtilisateur("ABANDON");
                    continue;
                }
                if (cle.equals("ANNULER") || cle.equals("ANNULER.x")) {
                    information.setActionUtilisateur("ANNULER");
                    continue;
                }
                if (cle.equals("SUPPRIMER") || cle.equals("SUPPRIMER.x")) {
                    information.setActionUtilisateur("SUPPRIMER");
                    continue;
                }
                if (cle.equals("CONFIRMER") || cle.equals("CONFIRMER.x")) {
                    information.setActionUtilisateur("CONFIRMER");
                    continue;
                }
                if (cle.equals("AJOUTER") || cle.equals("AJOUTER.x")) {
                    information.setActionUtilisateur("AJOUTER");
                    continue;
                }
                if (cle.equals("DETAIL") || cle.equals("DETAIL.x")) {
                    information.setActionUtilisateur("DETAIL");
                    continue;
                }
                if (cle.equals("RECHERCHER") || cle.equals("RECHERCHER.x")) {
                    information.setActionUtilisateur("RECHERCHER");
                    continue;
                }
                if (cle.equals("CREER") || cle.equals("CREER.x")) {
                    information.setActionUtilisateur("CREER");
                    continue;
                }
                if (cle.equals("SUITE") || cle.equals("SUITE.x")) {
                    information.setActionUtilisateur("SUITE");
                    continue;
                }
                if (cle.equals("MODIFIER") || cle.equals("MODIFIER.x")) {
                    information.setActionUtilisateur("MODIFIER");
                    continue;
                }
                if (cle.equals("TRADUIRE") || cle.equals("TRADUIRE.x")) {
                    information.setActionUtilisateur("TRADUIRE");
                    continue;
                }
                if (cle.length() <= 6 || !cle.substring(0, 7).equals("ACTION_")) continue;
                information.setActionUtilisateur(cle.substring(7, cle.length()));
            }
            if ("".equals(information.getActionUtilisateur()) && (paramValues = req.getParameterValues("ACTION")) != null && (valeurAction = paramValues[0]) != null && valeurAction.length() > 0) {
                information.setActionUtilisateur(valeurAction);
                if (!("ABANDON".equals(valeurAction) || "ANNULER".equals(valeurAction) || "SUPPRIMER".equals(valeurAction) || valeurAction.startsWith("NOCTRL"))) {
                    donneesAControlerSurActionCachee = true;
                }
            }
            if (StringUtils.isEmpty((CharSequence)information.getActionUtilisateur())) {
                information.setActionUtilisateur("VALIDER");
            }
            Vector<String> valeursTriees = new Vector<String>();
            HashSet<String> contentNewRessources = new HashSet<String>();
            HashSet contentOldRessources = new HashSet();
            HashSet<String> contentNewRessourcesSaisies = new HashSet<String>();
            HashSet<String> contentRessourcesSupprimees = new HashSet<String>();
            ArrayList<String> lstToolbox = new ArrayList<String>();
            int maxIndice = -1;
            en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String valeurFormat;
                int indice;
                String cle = (String)en.nextElement();
                if (cle.indexOf("#FORMAT_") != 0 || (indice = this.getIndice(valeurFormat = req.getParameter(cle))) == -1) continue;
                maxIndice = Math.max(maxIndice, indice);
            }
            for (int i = 0; i <= maxIndice; ++i) {
                valeursTriees.add(null);
            }
            en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String cle = (String)en.nextElement();
                boolean insererValeur = true;
                if ("ACTION".equals(cle)) {
                    insererValeur = false;
                }
                if (!insererValeur) continue;
                valeursTriees.add(cle);
            }
            en = valeursTriees.elements();
            if (information.getMessageErreur().isEmpty()) {
                LOGGER.debug("Collecte des donn\u00e9es de la requ\u00eate...");
                boolean controleZoneOK = true;
                while (en.hasMoreElements()) {
                    String cle = (String)en.nextElement();
                    if (cle == null) continue;
                    String valeur = req.getParameterValues(cle)[0];
                    boolean chaineFormatCourante = false;
                    int typeFormatCourant = 0;
                    int optionModifCourante = 1;
                    if (cle.length() > 8 && "#FORMAT_".equals(cle.substring(0, 8))) {
                        String nomCheckbox;
                        String[] options;
                        chaineFormatCourante = true;
                        int i = 0;
                        for (String option : options = valeur.split(";", -2)) {
                            switch (i) {
                                case 0: {
                                    try {
                                        optionModifCourante = Integer.parseInt(option);
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                case 1: {
                                    try {
                                        typeFormatCourant = Integer.parseInt(option);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            ++i;
                        }
                        if (typeFormatCourant == 7 && req.getParameter(nomCheckbox = cle.substring(8)) == null) {
                            information.set(nomCheckbox, "0");
                        }
                    }
                    if (donneesAControlerSurActionCachee || information.getActionUtilisateur().equals("VALIDER") || information.getActionUtilisateur().equals("CONFIRMER") || information.getActionUtilisateur().equals("ENREGISTRER") || information.getActionUtilisateur().equals("MODIFIER") || information.getActionUtilisateur().equals("SUITE") || information.getActionUtilisateur().equals("ONGLET")) {
                        if (chaineFormatCourante) {
                            if (typeFormatCourant != 9) continue;
                            String nomFichier = cle.substring(8);
                            ExtendedRequest ereq = (ExtendedRequest)req;
                            UploadedFile f = ereq.getFileParameter(nomFichier + "_FILE");
                            this.procedure.getInfoBean().set(nomFichier + "_FILE", null);
                            if (f != null && f.getContentFilename().length() != 0) {
                                this.procedure.getInfoBean().set(nomFichier + "_FILE", f);
                                this.procedure.getInfoBean().set(nomFichier, f.getContentFullFilename());
                                LOGGER.debug("fichier upload\u00e9 : " + f.getTemporaryFile().getPath() + "  name :" + f.getContentFilename());
                                continue;
                            }
                            if (!controleZoneOK) continue;
                            String[] exceptionFileUpload = ereq.getParameterValues("EXCEPTION_FILE_UPLOAD");
                            if (exceptionFileUpload == null || exceptionFileUpload[0].equals("1")) {
                                if (optionModifCourante != 2) continue;
                                if (this.procedure.getModeEnchainement() == 0) {
                                    String msg = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FIC_OBLIGATOIRE");
                                    information.addMessageErreur(msg + "#" + nomFichier);
                                } else {
                                    String msg1 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FIC_OBLIGATOIRE_BIS_1");
                                    String msg2 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FIC_OBLIGATOIRE_BIS_2");
                                    information.addMessageErreur(msg1 + " [" + nomFichier + "] " + msg2);
                                }
                                controleZoneOK = false;
                                continue;
                            }
                            if (!exceptionFileUpload[0].equals("2")) continue;
                            try {
                                int taille = Integer.parseInt(ereq.getParameterValues("EXCEPTION_FILE_UPLOAD")[1]);
                                String msg1 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FIC_TAILLE");
                                information.addMessageErreur(msg1 + " [" + (taille /= 1024) + "Ko] ");
                                controleZoneOK = false;
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.procedure.getLocale(), "UPLOAD_FICHIER_SIMPLE_ERREUR_TAILLE"));
                            }
                        }
                        if (controleZoneOK) {
                            String cleFormat = "#FORMAT_".concat(cle);
                            String valeurFormat = req.getParameter(cleFormat);
                            String formatSupplementaire = "";
                            if (valeurFormat != null) {
                                String[] options;
                                int optionModification = 1;
                                int typeFormat = 0;
                                int nbCarMax = 65000;
                                int i = 0;
                                for (String option : options = valeurFormat.split(";", -2)) {
                                    switch (i) {
                                        case 0: {
                                            try {
                                                optionModification = Integer.parseInt(option);
                                            }
                                            catch (Exception exception) {}
                                            break;
                                        }
                                        case 1: {
                                            try {
                                                typeFormat = Integer.parseInt(option);
                                            }
                                            catch (Exception exception) {}
                                            break;
                                        }
                                        case 2: {
                                            break;
                                        }
                                        case 3: {
                                            try {
                                                nbCarMax = Integer.parseInt(option);
                                            }
                                            catch (Exception exception) {}
                                            break;
                                        }
                                        case 4: {
                                            formatSupplementaire = option;
                                        }
                                    }
                                    ++i;
                                }
                                if (controleZoneOK && optionModification == 2 && (typeFormat == 1 && "0000".equals(valeur) || valeur.length() == 0)) {
                                    String msg1 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_ZONE_OBLIGATOIRE_BIS_1");
                                    String msg2 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_ZONE_OBLIGATOIRE_BIS_2");
                                    information.addMessageErreur(msg1 + " " + EscapeString.escapeScriptAndEvent(ParserRequete.getLibelleZone(cle, formatSupplementaire)) + " " + msg2);
                                    controleZoneOK = false;
                                }
                                if (controleZoneOK) {
                                    try {
                                        switch (typeFormat) {
                                            case 2: {
                                                valeurCI = this.controlerDate(valeur, cle, formatSupplementaire);
                                                break;
                                            }
                                            case 3: {
                                                if (valeur.length() > 0) {
                                                    valeurCI = Integer.valueOf(valeur);
                                                    break;
                                                }
                                                valeurCI = 0;
                                                break;
                                            }
                                            case 6: {
                                                if (valeur.length() > 0) {
                                                    valeurCI = Long.valueOf(valeur);
                                                    break;
                                                }
                                                valeurCI = 0L;
                                                break;
                                            }
                                            case 4: {
                                                if (valeur.length() > 0) {
                                                    valeurCI = Double.valueOf(valeur);
                                                    break;
                                                }
                                                valeurCI = 0.0;
                                                break;
                                            }
                                            case 7: {
                                                valeurCI = valeur;
                                                break;
                                            }
                                            case 0: {
                                                valeurCI = EscapeString.escapeScriptAndEvent(valeur);
                                                break;
                                            }
                                            case 5: 
                                            case 10: 
                                            case 12: {
                                                if (valeur.trim().length() > 0) {
                                                    valeurCI = ParserRequete.controlerTexte(valeur, cle, typeFormat, formatSupplementaire, nbCarMax);
                                                    String chaineCodeHTML = FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "CODE_HTML");
                                                    if ("1".equals(chaineCodeHTML)) {
                                                        this.parseRessources((String)valeurCI, contentNewRessourcesSaisies);
                                                        lstToolbox.add(cle);
                                                    }
                                                    break;
                                                }
                                                valeurCI = "";
                                                break;
                                            }
                                            default: {
                                                valeurCI = valeur;
                                            }
                                        }
                                    }
                                    catch (ErreurFormatage ef) {
                                        information.addMessageErreur(ef.getMessage());
                                        controleZoneOK = false;
                                    }
                                    catch (Exception e) {
                                        String msg1 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FMT_INCORRECT_BIS_1");
                                        String msg2 = MessageHelper.getCoreMessage(this.procedure.getLocale(), "JTF_ERR_FMT_INCORRECT_BIS_2");
                                        information.addMessageErreur(msg1 + " " + EscapeString.escapeScriptAndEvent(ParserRequete.getLibelleZone(cle, formatSupplementaire)) + " " + msg2);
                                        controleZoneOK = false;
                                    }
                                }
                            } else {
                                valeurCI = valeur;
                            }
                        }
                        if (cle.endsWith("_FILE")) continue;
                        if (controleZoneOK) {
                            information.set(cle, valeurCI);
                            continue;
                        }
                        information.setDonneeSaisie(cle, valeur);
                        continue;
                    }
                    information.setDonneeSaisie(cle, valeur);
                }
            }
            if (this.procedure.getMemorisationCI() && (oCI = information.get("ID_CI_RESTAURATION")) != null) {
                Object o;
                TreeMap listeCI = new TreeMap();
                Object liste = this.procedure.getProcessusManager().getSessionUtilisateur().getInfos().get("LISTE_COMPOSANTS_INFORMATIONS");
                if (liste != null) {
                    listeCI = (TreeMap)liste;
                }
                if ((o = listeCI.get(oCI)) != null) {
                    InfoBean oldCI = (InfoBean)o;
                    for (Data data : oldCI.getDatas().values()) {
                        String nomDonnee = data.getName();
                        if (lstToolbox.contains(nomDonnee)) {
                            this.parseRessources((String)data.getValue(), contentRessourcesSupprimees);
                        }
                        if (information.get(nomDonnee) != null) continue;
                        information.setData(nomDonnee, data);
                        if (!(data.getValue() instanceof String)) continue;
                        this.parseRessources((String)data.getValue(), contentNewRessources);
                    }
                } else {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("AUTHENTIFICATION.ERREUR.SESSION_REINITIALISEE"));
                }
            }
            if (information.get("contentOldRessources") != null) {
                contentOldRessources = (HashSet)information.get("contentOldRessources");
            }
            contentNewRessources.addAll(contentNewRessourcesSaisies);
            information.set("contentNewRessources", contentNewRessources);
            contentOldRessources.addAll(contentRessourcesSupprimees);
            contentOldRessources.removeAll(contentNewRessources);
            information.set("contentOldRessources", contentOldRessources);
        }
        catch (Exception e) {
            LOGGER.error("erreur lors de la r\u00e9cup\u00e9ration des donn\u00e9es de la requ\u00eate", (Throwable)e);
            information.addMessageErreur(e.getMessage());
        }
    }

    public static String controlerTexte(String valeur, String cle, int typeFormat, String formatSupplementaire, int nbCarMax) throws Exception, ErreurFormatage {
        int indice;
        int indice2;
        String chaineCodeHTML = FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "CODE_HTML");
        boolean toolbox = "1".equals(chaineCodeHTML);
        if (toolbox) {
            for (String host : Site.getListeCompleteHostsEtAlias()) {
                valeur = ParserRequete.enleverHttp(valeur, host);
            }
            valeur = StringUtils.replace((String)valeur, (String)"/servlet/com.univ.utils.LectureImageToolbox?TAG=", (String)"");
            valeur = ParserRequete.formaterLiensRequetes(valeur);
        } else if (typeFormat == 5) {
            valeur = EscapeString.escapeScriptAndEvent(valeur);
        }
        Locale localeCourante = ContexteUtil.getContexteUniv().getLocale();
        if (nbCarMax > 0 && valeur.length() > nbCarMax) {
            String msg = MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_NB_CAR_MAX_1") + " '" + ParserRequete.getLibelleZone(cle, formatSupplementaire) + "' " + MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_NB_CAR_MAX_2") + " " + nbCarMax + MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_NB_CAR_MAX_3") + " " + valeur.length() + ".";
            throw new ErreurFormatage(msg);
        }
        if (FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "EMAIL") != null) {
            boolean erreurMail = false;
            indice2 = valeur.indexOf("@");
            if (indice2 < 1 || indice2 > valeur.length() - 2) {
                erreurMail = true;
            }
            if (erreurMail) {
                String msg = MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_EMAIL");
                throw new ErreurFormatage(msg);
            }
            if (valeur.indexOf("@", indice2 + 1) != -1) {
                String msg = MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_2_EMAILS");
                throw new ErreurFormatage(msg);
            }
        }
        if (FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "URL") != null && (indice = valeur.indexOf("http://")) != 0) {
            String msg = MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_URL");
            throw new ErreurFormatage(msg);
        }
        boolean suppressionEspacesFinLigne = true;
        if (FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "NO_TRIM") != null) {
            suppressionEspacesFinLigne = false;
        }
        if (FormateurJSP.renvoyerValeurFormatage(formatSupplementaire, "CODE_GESTION") != null && (indice2 = valeur.indexOf("/")) != -1) {
            String msg = MessageHelper.getCoreMessage(localeCourante, "JTF_ERR_FMT_CODE");
            throw new ErreurFormatage(msg);
        }
        if (suppressionEspacesFinLigne) {
            valeur = valeur.trim();
        }
        if (toolbox) {
            valeur = StringUtils.replaceChars((String)valeur, (String)"\r", (String)"");
            if ("<br />".equalsIgnoreCase(valeur = StringUtils.replaceChars((String)valeur, (String)"\n", (String)"")) || "&nbsp;".equalsIgnoreCase(valeur) || "&#160;".equalsIgnoreCase(valeur)) {
                valeur = "";
            }
        }
        return valeur;
    }

    private static String getLibelleZone(String cle, String format) {
        String libelleZone = FormateurJSP.renvoyerValeurFormatageMinus(format, "LIB");
        if (libelleZone == null || libelleZone.length() == 0) {
            libelleZone = cle;
        }
        return libelleZone;
    }

    private static String enleverHttp(String tout, String basePath) {
        tout = StringUtils.replace((String)tout, (String)(basePath + "/servlet/com.univ.utils.LectureImageToolbox?TAG="), (String)"");
        StringBuilder res = new StringBuilder(tout);
        int idDeb = 0;
        int idFin = 0;
        while ((idDeb = tout.indexOf("=\"" + basePath, idFin)) != -1) {
            idFin = (idDeb += 2) + basePath.length();
            int idFinUrl = tout.indexOf("\"", idFin);
            if (tout.charAt(idFin) != '/' && tout.charAt(idFin) != '[' || tout.indexOf("#KLINK", idFin) != -1 && tout.indexOf("#KLINK", idFin) < idFinUrl) continue;
            if (tout.indexOf("/servlet/", idFin) == idFin && tout.indexOf("/servlet/com.jsbsoft.jtf.core.SG", idFin) != idFin) {
                idFin += 9;
            }
            if (tout.charAt(idFin) == '/' && tout.charAt(idFin + 1) == '[') {
                ++idFin;
            }
            tout = tout.substring(0, idDeb) + tout.substring(idFin);
            res.delete(idDeb, idFin);
            idFin = tout.indexOf("\"", idDeb);
        }
        return res.toString();
    }

    private static String formaterLiensRequetes(String tout) throws Exception {
        String res = "";
        if (tout != null && tout.length() > 0) {
            int idxDeb = 0;
            int idxDebID = tout.indexOf("&amp;");
            while (idxDebID != -1) {
                String part;
                String tmp = tout.substring(0, idxDebID);
                int idxDebLien = tmp.lastIndexOf("href=\"");
                int idxFinLien = tout.indexOf("\"", idxDebID);
                res = idxDebID > idxDebLien && idxDebLien != -1 && idxDebID < idxFinLien ? ((part = tout.substring(idxDebLien, idxDebID)).contains("[") ? res + tout.substring(idxDeb, idxDebID + 1) : res + tout.substring(idxDeb, idxDebID + 5)) : res + tout.substring(idxDeb, idxDebID + 5);
                idxDeb = idxDebID + 5;
                idxDebID = tout.indexOf("&amp;", idxDeb);
            }
            res = res + tout.substring(idxDeb, tout.length());
        } else {
            res = tout;
        }
        return res;
    }

    private void parseRessources(String value, Set<String> lstRessources) {
        try {
            if (value.contains("[id-image]")) {
                this.parseRessourceTag("id-image", value, "IMG", lstRessources);
            }
            if (value.contains("[id-fichier]")) {
                this.parseRessourceTag("id-fichier", value, "LIEN", lstRessources);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseRessourceTag(String tag, String tout, String type, Set<String> lstRessources) throws Exception {
        if (tout != null && tout.length() > 0) {
            String tmpFin = tout;
            int idxDebID = tout.indexOf("[" + tag + "]");
            while (idxDebID != -1) {
                int idxFinID;
                String id = (tmpFin = tmpFin.substring(idxDebID + tag.length() + 2, tmpFin.length())).substring(0, idxFinID = tmpFin.indexOf("[/" + tag + "]"));
                if (id.startsWith("F")) {
                    id = id.substring(1);
                }
                if (id.startsWith(";")) {
                    id = id.substring(1);
                }
                lstRessources.add(id + "#" + type);
                idxDebID = tmpFin.indexOf("[" + tag + "]");
            }
        }
    }
}

