/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.AbstractProcessusBean;
import com.jsbsoft.jtf.core.ControleurNavigation;
import com.jsbsoft.jtf.core.DefaultExitModule;
import com.jsbsoft.jtf.core.DescriptifPageRetour;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.ModuleExit;
import com.jsbsoft.jtf.core.ParserRequete;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.core.ProcessusManager;
import com.jsbsoft.jtf.session.SousSession;
import com.kportal.core.config.PropertyHelper;
import com.univ.utils.ContexteUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureBean {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureBean.class);
    private final InfoBean infoBean = new InfoBean();
    private ControleurNavigation cna;
    private ParserRequete parser;
    private SousSession sessionPartenaire = null;
    private ProcessusManager gp;
    public static final String CSTE_NOM_PAGE_DEFAUT = "adminsite/accueil";
    private String nom;
    private String extension;
    private ModuleExit moduleExit;
    private boolean estUneSousPU = false;
    private ProcedureBean PUMere = null;
    private ProcedureBean sousPU = null;
    public static final int MODE_SEQUENTIEL = 0;
    public static final int MODE_EVENEMENTIEL = 1;
    private int modeEnchainement = 0;
    private boolean restaurable = Boolean.FALSE;
    private boolean memorisationCI = Boolean.FALSE;

    public ProcedureBean(SousSession ss, String _nom, String extension) {
        this.setSessionPartenaire(ss);
        this.setNom(_nom);
        this.setExtension(StringUtils.defaultString((String)extension));
    }

    private boolean abandon() {
        String action = this.getInfoBean().getActionUtilisateur();
        return "ABANDON".equals(action);
    }

    private DescriptifPageRetour traiterAbandonProcedure() {
        String pageFin;
        this.gp.traiterAbandonProcedure();
        this.dereferencerPU();
        InfoBean infoBean = this.getInfoBean();
        String nomConteneur = ProcessusHelper.getEcranConteneur(infoBean.getNomExtension(), infoBean.getNomProcessus(), infoBean.getEcranLogique());
        if (StringUtils.isNotBlank((CharSequence)nomConteneur)) {
            infoBean.setEcranConteneur(nomConteneur);
        }
        if ((pageFin = PropertyHelper.getProperty(this.extension, "processus." + this.nom + ".page_fin")) == null && (pageFin = PropertyHelper.getProperty("", "processus.page_fin")) == null) {
            pageFin = CSTE_NOM_PAGE_DEFAUT;
        }
        return DescriptifPageRetour.descriptifPourJSP(pageFin);
    }

    public final void arreterProcedure() {
        this.dereferencerPU();
    }

    public ProcedureBean creerSousPU(String nom, String extension) throws Exception {
        this.sousPU = new ProcedureBean(this.getSession(), nom, extension);
        this.sousPU.initialiser(this);
        return this.sousPU;
    }

    private void dereferencerPU() {
        if (!this.estUneSousPU) {
            this.getSession().retirerProcedureBean(this.idBean());
        }
    }

    protected final DescriptifPageRetour descriptifFluxRetour() {
        DescriptifPageRetour desc;
        if (this.abandon()) {
            LOG.debug("Abandon par l'utilisateur");
            desc = this.traiterAbandonProcedure();
        } else {
            desc = this.descriptifFluxProcessus();
        }
        return desc;
    }

    public final DescriptifPageRetour descriptifFluxRetour(HttpServletRequest req) {
        DescriptifPageRetour d = null;
        if (this.sousPU == null) {
            this.getParserRequete().recueillirDonneesSaisies(req);
            if (this.moduleExit != null) {
                d = this.moduleExit.apresCollecte(this);
            }
            if (this.sousPU != null) {
                d = this.sousPU.descriptifFluxRetour();
            } else if (d == null) {
                d = this.descriptifFluxRetour();
            }
        } else {
            d = this.sousPU.descriptifFluxRetour(req);
            if (d == null) {
                if (this.moduleExit != null) {
                    d = this.moduleExit.apresSousPU(this, this.sousPU.getInfoBean());
                }
                this.sousPU = null;
                if (d == null) {
                    d = DescriptifPageRetour.descriptifPourJSP(this.getInfoBean().getEcranPhysique());
                }
            }
        }
        return d;
    }

    public void empilerProcessus(String nomProcessus, String nomExtension) {
        this.gp.creerProcessus(nomProcessus, nomExtension, this.getModuleExit(), 0);
    }

    public final InfoBean getInfoBean() {
        InfoBean ret = this.gp.getInfoBean();
        if (ret == null) {
            ret = this.infoBean;
        }
        return ret;
    }

    protected final InfoBean getInfoProcedureBean() {
        return this.infoBean;
    }

    protected final ControleurNavigation getControleurNavigation() {
        return this.cna;
    }

    protected int getModeEnchainement() {
        return this.modeEnchainement;
    }

    public ModuleExit getModuleExit() {
        return this.moduleExit;
    }

    public String getNom() {
        return this.nom;
    }

    public ParserRequete getParserRequete() {
        return this.parser;
    }

    protected final SousSession getSession() {
        return this.sessionPartenaire;
    }

    public ProcedureBean getSousPUActive() {
        if (this.sousPU != null) {
            return this.sousPU.getSousPUActive();
        }
        return this;
    }

    public final String idBean() {
        String idBean = !this.estUneSousPU ? Integer.toHexString(this.hashCode()) : this.PUMere.idBean();
        return idBean;
    }

    protected void initialiser() throws Exception {
        this.initialiser(null);
    }

    protected void initialiser(ProcedureBean _PUMere) throws Exception {
        if (_PUMere != null) {
            this.PUMere = _PUMere;
            this.estUneSousPU = true;
        }
        this.referencerPU();
        this.setControleurNavigation(new ControleurNavigation(this));
        this.setParserRequete(new ParserRequete(this));
        this.infoBean.setBEANPU(this.idBean());
        this.restaurable = "1".equals(PropertyHelper.getProperty(this.extension, "processus." + this.nom + ".restaurable"));
        this.memorisationCI = "1".equals(PropertyHelper.getProperty(this.extension, "processus." + this.nom + ".memorisation"));
        this.setModeEnchainement(0);
        String mode = PropertyHelper.getProperty(this.extension, "processus." + this.nom + ".modeEnchainement");
        if ("EVENEMENTIEL".equals(mode)) {
            this.setModeEnchainement(1);
        }
        this.infoBean.setModeEnchainement(this.getModeEnchainement());
        this.infoBean.setNomProcessus(this.getNom());
        this.infoBean.setNomExtension(this.getExtension());
        this.gp = new ProcessusManager(this);
        this.moduleExit = new DefaultExitModule();
        this.empilerProcessus(this.nom, this.extension);
    }

    private void referencerPU() {
        if (!this.estUneSousPU) {
            this.getSession().ajouterProcedureBean(this);
        }
    }

    private void setControleurNavigation(ControleurNavigation _cna) {
        this.cna = _cna;
    }

    private void setModeEnchainement(int newModeEnchainement) {
        this.modeEnchainement = newModeEnchainement;
    }

    private void setNom(String newNom) {
        this.nom = newNom;
    }

    private void setParserRequete(ParserRequete newValue) {
        this.parser = newValue;
    }

    private void setSessionPartenaire(SousSession ss) {
        this.sessionPartenaire = ss;
    }

    private DescriptifPageRetour descriptifFluxProcessus() {
        boolean finProcessus = false;
        if (StringUtils.isEmpty((CharSequence)this.getInfoBean().getMessageErreur())) {
            finProcessus = this.gp.traiterAction();
        }
        DescriptifPageRetour desc = this.getControleurNavigation().getProchainFlux();
        if (!finProcessus) {
            if (desc == null) {
                desc = this.descriptifFluxProcessus();
            } else if (desc.getTypeDeFlux() == DescriptifPageRetour.TypeFlux.URL) {
                LOG.debug(">>> fin proc\u00e9dure par redirection");
                this.dereferencerPU();
            }
        } else if (this.gp.existeUnProcessus()) {
            if (desc == null) {
                desc = this.descriptifFluxRetour();
            }
        } else {
            LOG.debug(">>> fin proc\u00e9dure");
            this.dereferencerPU();
        }
        return desc;
    }

    public Locale getLocale() {
        return ContexteUtil.getContexteUniv().getLocale();
    }

    protected final AbstractProcessusBean getProcessus() {
        return this.gp.getProcessus();
    }

    protected final ProcessusManager getProcessusManager() {
        return this.gp;
    }

    public boolean isRestaurable() {
        return this.restaurable;
    }

    public void setRestaurable(boolean newRestaurable) {
        this.restaurable = newRestaurable;
    }

    public boolean getMemorisationCI() {
        return this.memorisationCI;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

