/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.InfosEnchainementProcessus;
import com.jsbsoft.jtf.core.TypeMessage;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.composant.ComposantHelper;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.util.URLUtils;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.url.FrontOfficeMgr;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessusHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessusHelper.class);

    public static InfosEnchainementProcessus getInfosEnchainementProcessus(InfoBean infoBean) {
        String nomProcessus = infoBean.getNomProcessus();
        String nomExtension = infoBean.getNomExtension();
        InfosEnchainementProcessus ret = new InfosEnchainementProcessus();
        String ecranLogique = infoBean.getEcranLogique();
        String ecranRedirection = infoBean.getEcranRedirection();
        String ecranPhysique = infoBean.getEcranPhysique();
        boolean isFront = ProcessusHelper.isProcessusFrontOffice(nomProcessus, nomExtension);
        if (StringUtils.isNotBlank((CharSequence)infoBean.getMessageErreur())) {
            ret = ProcessusHelper.getInfosEnchainementErreur(infoBean);
        } else if (ecranLogique != null) {
            String nomJSP = ProcessusHelper.getNomJSP(nomProcessus, nomExtension, ecranLogique, isFront);
            if ("[ecran_redirection]".equals(nomJSP)) {
                if (StringUtils.isEmpty((CharSequence)ecranRedirection)) {
                    ecranRedirection = ProcessusHelper.calculerEcranRedirection(infoBean);
                }
                if (StringUtils.isNotEmpty((CharSequence)ecranRedirection)) {
                    ret.type = InfosEnchainementProcessus.TYPE_URL_REDIRECTION;
                    ecranRedirection = ProcessusHelper.setMessagesDansURL(ecranRedirection, infoBean);
                    if (StringUtils.isNotEmpty((CharSequence)nomExtension)) {
                        ecranRedirection = URLUtils.addParameter(ecranRedirection, "EXT", nomExtension);
                    }
                    ret.retour = ecranRedirection;
                }
            } else if ("[ecran_physique]".equals(nomJSP) && StringUtils.isNotEmpty((CharSequence)ecranPhysique)) {
                ret.type = InfosEnchainementProcessus.TYPE_JSP;
                ret.retour = ecranPhysique;
            } else {
                ret.type = InfosEnchainementProcessus.TYPE_JSP;
                ret.retour = nomJSP;
            }
        } else if (!isFront && StringUtils.isNotEmpty((CharSequence)(ecranRedirection = ProcessusHelper.calculerEcranRedirection(infoBean)))) {
            ret.type = InfosEnchainementProcessus.TYPE_URL_REDIRECTION;
            ret.retour = ecranRedirection;
        }
        if (ret.type == InfosEnchainementProcessus.TYPE_AUCUNE && StringUtils.isBlank((CharSequence)ret.retour)) {
            ret.type = InfosEnchainementProcessus.TYPE_JSP;
            ret.retour = PropertyHelper.getProperty("", "processus.ERREUR_PROCESSUS.ecran_physique.PRINCIPAL");
        }
        if (StringUtils.isBlank((CharSequence)ret.conteneur)) {
            ret.conteneur = ProcessusHelper.getEcranConteneur(nomExtension, nomProcessus, ecranLogique);
        }
        return ret;
    }

    private static String getNomJSP(String nomProcessus, String nomExtension, String ecranLogique, boolean isFront) {
        String nomJSP = PropertyHelper.getProperty(nomExtension, "processus." + nomProcessus + ".ecran_physique." + ecranLogique);
        if (nomJSP == null) {
            nomJSP = isFront ? PropertyHelper.getProperty("", "processus.ecran_physique_front." + ecranLogique) : PropertyHelper.getProperty("", "processus.ecran_physique." + ecranLogique);
        }
        return nomJSP;
    }

    private static String calculerEcranRedirection(InfoBean infoBean) {
        String nomProcessus = infoBean.getNomProcessus();
        String ecranRedirection = "";
        IComposant composantCourant = ProcessusHelper.getComposantParNomProcessus(nomProcessus);
        if (composantCourant != null) {
            ecranRedirection = ProcessusHelper.setMessagesDansURL(composantCourant.getUrlAccueilBo(), infoBean);
        }
        return ecranRedirection;
    }

    private static String setMessagesDansURL(String url, InfoBean infoBean) {
        url = URLUtils.addParameter(url, TypeMessage.ALERTE.getCode(), infoBean.getMessageAlerte());
        url = URLUtils.addParameter(url, TypeMessage.CONFIRMATION.getCode(), infoBean.getMessageConfirmation());
        url = URLUtils.addParameter(url, TypeMessage.ERREUR.getCode(), infoBean.getMessageErreur());
        return url;
    }

    private static InfosEnchainementProcessus getInfosEnchainementErreur(InfoBean infoBean) {
        InfosEnchainementProcessus infosEnchainement = null;
        String nomJSP = "";
        FicheUniv fiche = null;
        String referer = (String)infoBean.get("PAGE_REFERER");
        if (infoBean.getModeEnchainement() == 0) {
            Boolean isFront = ProcessusHelper.isProcessusFrontOffice(infoBean.getNomProcessus(), infoBean.getNomExtension());
            nomJSP = ProcessusHelper.getNomJSP(infoBean.getNomProcessus(), infoBean.getNomExtension(), infoBean.getEcranLogique(), isFront);
        } else {
            nomJSP = PropertyHelper.getProperty(infoBean.getNomExtension(), "processus." + infoBean.getNomProcessus() + ".ecran_erreur." + infoBean.getEcranLogique());
            if (StringUtils.isEmpty((CharSequence)nomJSP)) {
                nomJSP = PropertyHelper.getProperty(infoBean.getNomExtension(), "processus." + infoBean.getNomProcessus() + ".page_erreur");
            }
        }
        if ("[erreur_front]".equals(nomJSP)) {
            if (referer != null) {
                fiche = ProcessusHelper.getFicheDepuisUrl(referer);
            } else {
                nomJSP = "";
            }
        }
        if (fiche != null) {
            infosEnchainement = new InfosEnchainementProcessus(InfosEnchainementProcessus.TYPE_URL_REDIRECTION, referer);
        } else if (StringUtils.isNotBlank((CharSequence)nomJSP)) {
            infosEnchainement = new InfosEnchainementProcessus(InfosEnchainementProcessus.TYPE_JSP, nomJSP);
        }
        if (infosEnchainement == null) {
            infosEnchainement = ProcessusHelper.getDefautPageErreur(ProcessusHelper.isProcessusFrontOffice(infoBean.getNomProcessus(), infoBean.getNomExtension()));
        }
        return infosEnchainement;
    }

    private static InfosEnchainementProcessus getDefautPageErreur(boolean isFront) {
        String pageErreur = "";
        String ecranConteneur = "";
        if (isFront) {
            pageErreur = PropertyHelper.getProperty("", "processus.page_erreur_front");
            ecranConteneur = PropertyHelper.getProperty("", "processus.ecran_conteneur_front");
        } else {
            pageErreur = PropertyHelper.getProperty("", "processus.page_erreur");
            ecranConteneur = PropertyHelper.getProperty("", "processus.ecran_conteneur");
        }
        return new InfosEnchainementProcessus(InfosEnchainementProcessus.TYPE_JSP, pageErreur, ecranConteneur);
    }

    public static boolean isProcessusFrontOffice(String nomProcessus, String nomExtension) {
        return Boolean.valueOf(PropertyHelper.getProperty(nomExtension, "processus." + nomProcessus + ".is_front"));
    }

    private static FicheUniv getFicheDepuisUrl(String url) {
        FicheUniv fiche = null;
        try {
            fiche = StringUtils.endsWith((CharSequence)url, (CharSequence)"/") ? FrontOfficeMgr.lireFicheAccueilRubrique(url) : FrontOfficeMgr.lireFiche(ContexteUtil.getContexteUniv(), url, new HashMap<String, String[]>());
        }
        catch (Exception e) {
            LOGGER.debug("unable to find the FicheUniv from the given URL", (Throwable)e);
        }
        return fiche;
    }

    public static void positionneComposantDansInfoBean(InfoBean infoBean, String nomProcessus) {
        Collection<IComposant> composantsDefinis = ComposantHelper.getComposants();
        for (IComposant composantCourant : composantsDefinis) {
            if (!composantCourant.getParametreProcessus().equals(nomProcessus)) continue;
            infoBean.setIdComposant(composantCourant.getId());
            return;
        }
    }

    public static IComposant getComposantParNomProcessus(String nomProcessus) {
        Collection<IComposant> composantsDefinis = ComposantHelper.getComposants();
        for (IComposant composantCourant : composantsDefinis) {
            if (!composantCourant.getParametreProcessus().equals(nomProcessus)) continue;
            return composantCourant;
        }
        return null;
    }

    public static String getEcranConteneur(String nomExtension, String nomProcessus, String ecranLogique) {
        String nomConteneur = PropertyHelper.getProperty(nomExtension, "processus." + nomProcessus + ".ecran_conteneur." + ecranLogique);
        if (nomConteneur == null && (nomConteneur = PropertyHelper.getProperty(nomExtension, "processus." + nomProcessus + ".ecran_conteneur")) == null && (nomConteneur = PropertyHelper.getProperty(nomExtension, "processus.ecran_conteneur." + ecranLogique)) == null) {
            boolean isFront = Boolean.valueOf(PropertyHelper.getProperty(nomExtension, "processus." + nomProcessus + ".is_front"));
            nomConteneur = isFront ? PropertyHelper.getProperty("", "processus.ecran_conteneur_front") : PropertyHelper.getProperty("", "processus.ecran_conteneur");
        }
        return nomConteneur;
    }

    public static Class<? extends ProcessusBean> getClasseProcessus(String processus, String extension) {
        Class<ProcessusBean> classe = null;
        String nomClasse = PropertyHelper.getProperty(extension, "processus." + processus + ".classe");
        if (nomClasse == null) {
            return classe;
        }
        try {
            classe = Class.forName(nomClasse).asSubclass(ProcessusBean.class);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Le processus " + processus + "[" + nomClasse + "] n'a pas \u00e9t\u00e9 trouv\u00e9");
        }
        return classe;
    }

    public static String getUrlProcessAction(InfoBean infoBean, String extension, String processus, String action, String[][] param) {
        String ext;
        StringBuilder url = new StringBuilder("/servlet/com.jsbsoft.jtf.core.SG");
        url.append("?");
        String string = ext = StringUtils.isNotEmpty((CharSequence)extension) ? extension : infoBean.getNomExtension();
        if (StringUtils.isNotEmpty((CharSequence)ext)) {
            url.append("EXT=").append(ext).append("&amp;");
        }
        url.append("PROC=").append(StringUtils.isNotEmpty((CharSequence)processus) ? processus : infoBean.getNomProcessus());
        url.append("&amp;ACTION=").append(action);
        if (param != null) {
            for (String[] strings : param) {
                if (strings.length <= 1) continue;
                url.append("&amp;").append(strings[0]).append("=").append(EscapeString.escapeURL(strings[1]));
            }
        }
        return url.toString();
    }
}

