/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.AbstractProcessusBean;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.InfosProcessus;
import com.jsbsoft.jtf.core.ModuleExitProcessus;
import com.jsbsoft.jtf.core.ProcedureBean;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.database.RequeteMgr;
import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.lang.reflect.Constructor;
import java.util.Stack;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessusManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessusManager.class);
    public static final int TYPE_APPELANT_PU = 0;
    public static final int TYPE_APPELANT_PROCESSUS = 1;
    private final Stack<InfosProcessus> pileProcessus;
    private ProcedureBean procedure = null;

    public ProcessusManager(ProcedureBean _procedure) {
        this.procedure = _procedure;
        this.pileProcessus = new Stack();
    }

    public void traiterAbandonActivite() {
        try {
            this.getProcessus().traiterAbandon();
        }
        catch (Exception e) {
            LOG.error("erreur sur le traitement de l'abandon", (Throwable)e);
        }
        this.depilerActiviteCourante();
    }

    protected void traiterAbandonProcedure() {
        while (this.existeUnProcessus()) {
            try {
                this.getProcessus().traiterAbandon();
                this.depilerActiviteCourante();
            }
            catch (Exception e) {
                LOG.error("erreur sur le traitement de l'abandon", (Throwable)e);
            }
        }
    }

    protected void arreterProcedure() {
        while (this.existeUnProcessus()) {
            try {
                this.depilerActiviteCourante();
            }
            catch (Exception e) {
                LOG.error("erreur lors de l'arret du processus", (Throwable)e);
            }
        }
    }

    public final void creerProcessus(String nomProcessus, String nomExtension, ModuleExitProcessus module, int typeAppelant) {
        try {
            Class<? extends ProcessusBean> classeProcessus = ProcessusHelper.getClasseProcessus(nomProcessus, nomExtension);
            if (classeProcessus == null) {
                nomProcessus = "ERREUR_PROCESSUS";
                classeProcessus = ProcessusHelper.getClasseProcessus(nomProcessus, nomExtension);
            }
            Class[] classesParam = new Class[]{InfoBean.class};
            Constructor<? extends ProcessusBean> constructeur = classeProcessus.getConstructor(classesParam);
            InfoBean infoBeanFils = new InfoBean(this.getProcedureBean().getInfoProcedureBean());
            infoBeanFils.setNomProcessus(nomProcessus);
            infoBeanFils.setSessionHttp(this.getProcedureBean().getSession().getSessionUtilisateur().getHttpSession());
            Object[] params = new Object[]{infoBeanFils};
            ProcessusBean beanCA = constructeur.newInstance(params);
            beanCA.setGp(this);
            this.empilerActivite(beanCA, module, typeAppelant);
        }
        catch (Exception e) {
            LOG.error("Erreur \u00e0 la cr\u00e9ation du processus", (Throwable)e);
        }
    }

    private void depilerActiviteCourante() {
        this.pileProcessus.pop();
    }

    private void empilerActivite(AbstractProcessusBean activite, ModuleExitProcessus module, int typeAppelant) {
        InfoBean infoBean = activite.getInfoBean();
        InfosProcessus processus = new InfosProcessus(activite, infoBean, module, typeAppelant);
        this.pileProcessus.push(processus);
    }

    public final ProcedureBean getProcedureBean() {
        return this.procedure;
    }

    public final InfoBean getInfoBean() {
        InfoBean infoBean = null;
        if (this.existeUnProcessus()) {
            infoBean = this.pileProcessus.peek().getInfoBean();
        }
        return infoBean;
    }

    public final ModuleExitProcessus getModuleExitProcessus() {
        ModuleExitProcessus processus = null;
        if (this.existeUnProcessus()) {
            return this.pileProcessus.peek().getModuleExitProcessus();
        }
        return processus;
    }

    public final HttpSession getSession() {
        return this.getProcedureBean().getSession().getSessionUtilisateur().getHttpSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean traiterAction() throws ErreurAsyncException {
        this.getSessionUtilisateur().setNomDernierProcessusAppele(this.getInfoBean().getNomProcessus());
        boolean finProcessus = false;
        boolean bouclerSurAppelProcessus = false;
        do {
            try {
                AbstractProcessusBean ancienCA;
                bouclerSurAppelProcessus = false;
                AbstractProcessusBean abstractProcessusBean = ancienCA = this.getProcessus();
                synchronized (abstractProcessusBean) {
                    try {
                        ancienCA.initConnection();
                        ancienCA.setIdRequete(RequeteMgr.creerRequete());
                        RequeteMgr.ajouterEvenement(ancienCA.getIdRequete(), "processus (debut) > " + ancienCA.getInfoBean());
                        finProcessus = this.getProcessus().traiterAction();
                        RequeteMgr.ajouterEvenement(ancienCA.getIdRequete(), "processus (fin) > " + ancienCA.getInfoBean());
                        RequeteMgr.terminerRequete(ancienCA.getIdRequete());
                    }
                    finally {
                        ancienCA.releaseConnection();
                    }
                }
                AbstractProcessusBean nouveauCA = this.getProcessus();
                if (ancienCA != nouveauCA) {
                    bouclerSurAppelProcessus = true;
                }
                InfoBean cloneCI = this.getInfoBean();
                ModuleExitProcessus moduleExit = this.getModuleExitProcessus();
                if (!finProcessus) continue;
                int typeAppelant = this.pileProcessus.peek().getTypeAppelant();
                if (typeAppelant == 1) {
                    bouclerSurAppelProcessus = true;
                }
                this.depilerActiviteCourante();
                moduleExit.apresProcessus(this, cloneCI);
                cloneCI.setMessagesDansInfoBeanPere();
            }
            catch (ErreurAsyncException e) {
                throw e;
            }
            catch (Exception e) {
                ContexteUniv ctx = ContexteUtil.getContexteUniv();
                String errorMessage = "erreur lors du traitement de l'action du processus";
                if (ctx != null && ctx.getRequeteHTTP() != null) {
                    StringBuffer requestUrl = ctx.getRequeteHTTP().getRequestURL();
                    String queryString = ctx.getRequeteHTTP().getQueryString();
                    if (StringUtils.isNotBlank((CharSequence)queryString)) {
                        requestUrl.append("?").append(queryString);
                    }
                    errorMessage = errorMessage + " sur la requ\u00eate " + requestUrl.toString();
                }
                LOG.error(errorMessage, (Throwable)e);
                bouclerSurAppelProcessus = false;
                this.getInfoBean().addMessageErreur(e.toString());
            }
        } while (bouclerSurAppelProcessus);
        return finProcessus;
    }

    public final boolean estUnProcessusFils() {
        boolean fils = false;
        int size = this.pileProcessus.size();
        if (size > 1) {
            fils = true;
        }
        return fils;
    }

    protected final boolean existeUnProcessus() {
        return !this.pileProcessus.isEmpty();
    }

    public final AbstractProcessusBean getProcessus() {
        AbstractProcessusBean processus = null;
        if (this.existeUnProcessus()) {
            processus = this.pileProcessus.peek().getComposantActivite();
        }
        return processus;
    }

    public final SessionUtilisateur getSessionUtilisateur() {
        return this.getProcedureBean().getSession().getSessionUtilisateur();
    }
}

