/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.ldap.ISynchroLdapUtilisateur;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ISynchroniseurUtilisateurMetier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchroniseurUtilisateur {
    public static final int SYNCHRO_USER_ADD = 0;
    public static final int SYNCHRO_USER_UPDATE = 1;
    public static final int SYNCHRO_USER_DELETE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(SynchroniseurUtilisateur.class);
    private static SynchroniseurUtilisateur _instance;
    private Map<String, Object> mapSynchroUtilisateurMetier;
    private ISynchroLdapUtilisateur synchroLdap;

    public static synchronized SynchroniseurUtilisateur getInstance() {
        if (_instance == null) {
            _instance = new SynchroniseurUtilisateur();
        }
        return _instance;
    }

    public Map<String, Object> getMapSynchroUtilisateurMetier() {
        return this.mapSynchroUtilisateurMetier;
    }

    public ISynchroLdapUtilisateur getSynchroLdap() {
        return this.synchroLdap;
    }

    public void synchroUtilisateur(int typeSynchro, Utilisateur utilisateur, OMContext ctx, boolean majOnlySourceExterne) throws Exception {
        if (!majOnlySourceExterne) {
            this.synchroUserObjetsMetier(typeSynchro, utilisateur, ctx);
        }
        this.synchroUserSourceExterne(typeSynchro, utilisateur, ctx);
    }

    public void synchroUtilisateur(int typeSynchro, Utilisateur utilisateur, OMContext ctx) throws Exception {
        this.synchroUtilisateur(typeSynchro, utilisateur, ctx, false);
    }

    protected void synchroUserSourceExterne(int typeSynchro, Utilisateur utilisateur, OMContext ctx) throws Exception {
        if (this.synchroLdap != null) {
            this.synchroLdap.synchroniseUtilisateur(typeSynchro, utilisateur, ctx);
        }
    }

    protected boolean synchroUserObjetsMetier(int typeSynchro, Utilisateur utilisateur, OMContext ctx) throws Exception {
        if (this.mapSynchroUtilisateurMetier != null && typeSynchro == 1) {
            boolean bSynchronisation = false;
            for (ISynchroniseurUtilisateurMetier iSynchroniseurUtilisateurMetier : this.mapSynchroUtilisateurMetier.values()) {
                bSynchronisation = iSynchroniseurUtilisateurMetier.majUtilisateurMetier(utilisateur, ctx) || bSynchronisation;
            }
            return bSynchronisation;
        }
        return false;
    }

    protected void chargeObjetsSessionUserMetier() {
        if (this.mapSynchroUtilisateurMetier == null) {
            this.mapSynchroUtilisateurMetier = new HashMap<String, Object>();
            Enumeration<Object> enumProperties = PropertyHelper.getAllProperties().elements();
            int debutNomApplicatif = "utilisateur_metier".length() + 1;
            while (enumProperties.hasMoreElements()) {
                String clef = (String)enumProperties.nextElement();
                if (!clef.startsWith("utilisateur_metier")) continue;
                String nomClasse = PropertyHelper.getCoreProperty(clef);
                String nomApplicatif = clef.substring(debutNomApplicatif);
                nomApplicatif = nomApplicatif.substring(0, nomApplicatif.lastIndexOf(46));
                try {
                    this.mapSynchroUtilisateurMetier.put(nomApplicatif, Class.forName(nomClasse).newInstance());
                }
                catch (Exception e) {
                    LOG.error("erreur lors de l'ajout des objets de traitement", (Throwable)e);
                }
            }
        }
    }

    private void chargeSynchroniseurLdap() {
        String nomClasse = PropertyHelper.getCoreProperty("synchroniseur_ldap.classe");
        if (nomClasse != null) {
            try {
                this.synchroLdap = (ISynchroLdapUtilisateur)Class.forName(nomClasse).newInstance();
            }
            catch (Exception e) {
                LOG.error("** Echec chargement " + nomClasse);
                this.synchroLdap = null;
            }
        } else {
            this.synchroLdap = null;
        }
    }

    private SynchroniseurUtilisateur() {
        this.chargeObjetsSessionUserMetier();
        this.chargeSynchroniseurLdap();
    }
}

