/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.core;

import com.jsbsoft.jtf.core.Data;
import com.jsbsoft.jtf.core.DescriptifPageRetour;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.MyRequestWrapper;
import com.jsbsoft.jtf.core.ProcedureBean;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.core.SG;
import com.jsbsoft.jtf.core.TypeMessage;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.session.SousSession;
import com.jsbsoft.jtf.upload.ExtendedRequest;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.ExtensionHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraitementRequeteHTTP {
    private static final Logger LOG = LoggerFactory.getLogger(TraitementRequeteHTTP.class);
    private static final String CSTE_NOM_PARAMETRE_PROCEDURE = "BEANPU";
    private static final String CSTE_NOM_PARAMETRE_NAMEPU = "PROC";
    private static final String CSTE_NOM_PARAMETRE_EXTENSIONPU = "EXT";
    private HttpServlet servlet = null;

    public void renvoyerFlux(DescriptifPageRetour desc, HttpServletRequest req, HttpServletResponse res, ProcedureBean bean) throws ServletException, IOException {
        switch (desc.getTypeDeFlux()) {
            case URL: {
                this.renvoyerURL(req, res, desc.getUrlString(), bean);
                break;
            }
            case JSP: {
                this.renvoyerJSP(req, res, desc.getNom(), bean);
                break;
            }
            case HTML: {
                this.renvoyerHTML(req, res, desc.getNom());
                break;
            }
            case XML: {
                this.renvoyerXML(req, res, desc.getNom(), bean);
                break;
            }
            case OBJET_SERIALISE: {
                this.renvoyerObjetSerialisable(res, desc.getObjetSerialisable());
            }
        }
    }

    private void renvoyerHTML(HttpServletRequest req, HttpServletResponse res, String nom) throws ServletException, IOException {
        LOG.debug("Envoi de la page HTML " + nom);
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        RequestDispatcher rd = context.getRequestDispatcher("/" + nom + ".jsp");
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    private void renvoyerJSP(HttpServletRequest req, HttpServletResponse res, String nomJSP, ProcedureBean b) throws ServletException, IOException {
        if ("[login_front_redirect]".equals(nomJSP)) {
            try {
                UnivWebFmt.redirigerVersLogin(b.getInfoBean(), req, res);
            }
            catch (Exception e) {
                LOG.error("erreur lors de la redirection vers le login", (Throwable)e);
            }
            return;
        }
        if (b != null) {
            if (nomJSP != null) {
                TreeMap<String, InfoBean> listeCI;
                b = b.getSousPUActive();
                String ecranLogique = StringUtils.defaultString((String)b.getInfoBean().getEcranLogique());
                LOG.debug("*** SAUVEGARDE INFOBEAN POUR RESTAURATION : " + ecranLogique);
                Object liste = b.getProcessusManager().getSessionUtilisateur().getInfos().get("LISTE_COMPOSANTS_INFORMATIONS");
                if (liste != null) {
                    listeCI = (TreeMap<String, InfoBean>)liste;
                } else {
                    listeCI = new TreeMap<String, InfoBean>();
                    b.getProcessusManager().getSessionUtilisateur().getInfos().put("LISTE_COMPOSANTS_INFORMATIONS", listeCI);
                }
                if (b.getInfoBean().getMessageErreur().length() == 0) {
                    String idCI = "" + System.currentTimeMillis();
                    if (BooleanUtils.toBoolean((String)b.getInfoBean().getString("SINGLE_CI_RESTAURATION"))) {
                        idCI = b.getInfoBean().getString("ID_CI_RESTAURATION");
                    }
                    listeCI.put(idCI, b.getInfoBean());
                    b.getInfoBean().set("ID_CI_RESTAURATION", idCI);
                    b.getInfoBean().set("NOM_JSP_RESTAURATION", nomJSP);
                    if (listeCI.size() > 50) {
                        Iterator iter = listeCI.values().iterator();
                        for (int i = 0; iter.hasNext() && i < 10; ++i) {
                            iter.next();
                            iter.remove();
                        }
                    }
                }
                if (b.getInfoBean().getMessageErreur().length() > 0) {
                    Object oCI = b.getInfoBean().get("ID_CI_RESTAURATION");
                    if (oCI != null) {
                        Object o = listeCI.get(oCI);
                        if (o != null) {
                            InfoBean oldCI = (InfoBean)o;
                            if (!b.getMemorisationCI()) {
                                for (Data data : oldCI.getDatas().values()) {
                                    String nomDonnee = data.getName();
                                    if (b.getInfoBean().get(nomDonnee) != null) continue;
                                    b.getInfoBean().setData(nomDonnee, data);
                                }
                            }
                            nomJSP = oldCI.getString("NOM_JSP_RESTAURATION");
                        } else {
                            b.getInfoBean().setTitreEcran(MessageHelper.getCoreMessage("BO_ERREUR"));
                        }
                    } else {
                        b.getInfoBean().setTitreEcran(MessageHelper.getCoreMessage("BO_ERREUR"));
                    }
                }
                InfosSite infosSite = Site.renvoyerItemSiteParHost(req.getServerName());
                Boolean isFront = ProcessusHelper.isProcessusFrontOffice(b.getInfoBean().getNomProcessus(), b.getExtension());
                String path = ExtensionHelper.getTemplateExtension(b.getExtension(), nomJSP, isFront);
                if (StringUtils.isBlank((CharSequence)path)) {
                    res.setStatus(404);
                    String forward = infosSite.getJspFo() + "/error/404.jsp?URL_DEMANDEE=" + URLEncoder.encode(req.getRequestURI(), "UTF-8");
                    if (StringUtils.isNotEmpty((CharSequence)req.getHeader("referer"))) {
                        forward = forward + "&REFERER=" + URLEncoder.encode(req.getHeader("referer"), "UTF-8");
                    }
                    b.getInfoBean().setEcranConteneur(forward);
                } else {
                    b.getInfoBean().setEcranPhysique(path);
                }
                b.getInfoBean().setIDJSP(String.valueOf(System.currentTimeMillis()));
                LOG.debug("Stockage du Composant d'information");
                req.setAttribute("infoBean", (Object)b.getInfoBean());
                LOG.debug("Le CUI avant l'envoi de la JSP " + nomJSP + " :\r\n" + b.getInfoBean().toString());
                String ecranconteneur = b.getInfoBean().getEcranConteneur();
                nomJSP = this.calculerJSPAAfficher(nomJSP, infosSite, ecranconteneur);
                ServletContext context = this.servlet.getServletConfig().getServletContext();
                RequestDispatcher rd = context.getRequestDispatcher(nomJSP);
                if (b.getInfoBean().getMessageErreur().length() > 0) {
                    res.setHeader("ERREUR", b.getInfoBean().getMessageErreur());
                }
                rd.forward((ServletRequest)req, (ServletResponse)res);
                b.getInfoBean().removeMessage(TypeMessage.ERREUR.getCode());
            } else {
                res.setContentType("text/html");
                PrintWriter out = res.getWriter();
                out.println("<HTML><HEAD><TITLE>Attention</TITLE></HEAD>");
                out.println("<BODY>");
                out.println("This page has expired");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else {
            LOG.debug("Pas de ProcedureBean");
        }
    }

    private String calculerJSPAAfficher(String nomJSP, InfosSite infosSite, String ecranconteneur) {
        if (StringUtils.isNotBlank((CharSequence)ecranconteneur) && !"[ecran_logique]".equals(ecranconteneur)) {
            nomJSP = ecranconteneur;
        }
        if (infosSite != null) {
            String dossierJspFo = infosSite.getJspFo();
            if (nomJSP.startsWith("jsp") && !"/jsp".equals(dossierJspFo)) {
                nomJSP = StringUtils.replace((String)nomJSP, (String)"jsp/", (String)(dossierJspFo.substring(1) + "/"));
            }
        }
        if (!nomJSP.endsWith(".jsp")) {
            nomJSP = nomJSP + ".jsp";
        }
        if (!nomJSP.startsWith("/")) {
            nomJSP = "/" + nomJSP;
        }
        return nomJSP;
    }

    private void renvoyerObjetSerialisable(HttpServletResponse res, Serializable obj) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)res.getOutputStream());
        oos.writeObject(obj);
        oos.close();
    }

    private void renvoyerURL(HttpServletRequest req, HttpServletResponse res, String urlString, ProcedureBean b) throws IOException, ServletException {
        if (StringUtils.isNotEmpty((CharSequence)b.getInfoBean().getMessageErreur())) {
            HttpSession session = req.getSession(false);
            session.setAttribute("infoBean", (Object)b.getInfoBean());
        }
        res.sendRedirect(urlString);
    }

    private void renvoyerXML(HttpServletRequest req, HttpServletResponse res, String nomXml, ProcedureBean b) throws ServletException, IOException {
        if (b != null) {
            b = b.getSousPUActive();
            req.setAttribute("infoBean", (Object)b.getInfoBean());
        }
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        RequestDispatcher rd = context.getRequestDispatcher("/" + nomXml + ".xml");
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    private ProcedureBean retrouverProcedureBean(HttpSession sessionHttp, HttpServletRequest req) throws Exception {
        LOG.debug("Recherche du bean PU...");
        ProcedureBean bean = null;
        try {
            SessionUtilisateur session = (SessionUtilisateur)sessionHttp.getAttribute("session");
            String idBean = req.getParameter(CSTE_NOM_PARAMETRE_PROCEDURE);
            if (idBean != null) {
                bean = session.retrouverProcedureBeanparID(idBean);
            }
            if (bean != null) {
                LOG.debug("Le bean BEANPU existe dej\u00e0");
            } else {
                LOG.debug("Aucun bean BEANPUdans la session utilisateur, on le recr\u00e9e");
                SousSession ss = session.getSessionParDefaut();
                LOG.debug("Cr\u00e9ation du bean");
                String nomPU = req.getParameter(CSTE_NOM_PARAMETRE_NAMEPU);
                String extensionPU = req.getParameter(CSTE_NOM_PARAMETRE_EXTENSIONPU);
                if (ss != null && nomPU != null) {
                    bean = new ProcedureBean(ss, nomPU, extensionPU);
                    bean.initialiser();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Impossible d'initialiser le bean BEANPU", (Throwable)e);
            throw new Exception("Impossible de cr\u00e9er une proc\u00e9dure");
        }
        return bean;
    }

    public void traiterRequeteHTTP(SG _servlet, HttpServletRequest req, HttpServletResponse res) {
        MyRequestWrapper myrequest = new MyRequestWrapper(req);
        myrequest.setResponse(res);
        this.servlet = _servlet;
        LOG.debug("--------Requ\u00eate re\u00e7ue = " + myrequest.getServletPath() + "?" + myrequest.getQueryString() + "\r\n");
        ExtendedRequest ereq = null;
        try {
            ereq = new ExtendedRequest((HttpServletRequest)myrequest, res, new File(WebAppUtil.getUploadDefaultPath()));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        HttpSession session = this.recupererSession(myrequest);
        ProcedureBean b = null;
        try {
            b = this.retrouverProcedureBean(session, ereq);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (b != null) {
                DescriptifPageRetour desc;
                if (b.getProcessus() instanceof ProcessusBean) {
                    ((Hashtable)((ProcessusBean)b.getProcessus()).getDatas()).put("_servlet_config", _servlet.getServletConfig());
                }
                Map datasOMContext = null;
                if (b.getProcessus() instanceof ProcessusBean) {
                    datasOMContext = ((ProcessusBean)b.getProcessus()).getDatas();
                    ((Hashtable)datasOMContext).put("_sg_requete_http", myrequest);
                }
                if ((desc = b.descriptifFluxRetour(ereq)) != null) {
                    this.renvoyerFlux(desc, (HttpServletRequest)myrequest, res, b);
                    String ecranLogique = b.getInfoBean().getEcranLogique();
                    if (ecranLogique != null && ecranLogique.equals("FIN")) {
                        b.getSession().retirerProcedureBean(b.idBean());
                    }
                    if (b.getModeEnchainement() == 1) {
                        b.getSession().retirerProcedureBean(b.idBean());
                    }
                } else {
                    this.renvoyerFlux(DescriptifPageRetour.descriptifPageDefaut(b.getNom(), b.getExtension()), (HttpServletRequest)myrequest, res, b);
                }
                if (datasOMContext != null) {
                    ((Hashtable)datasOMContext).remove("_sg_requete_http");
                }
            } else {
                res.setContentType("text/html");
                PrintWriter out = res.getWriter();
                out.println("<HTML><HEAD><TITLE>Expired page</TITLE></HEAD>");
                out.println("<BODY>");
                out.println("<B>404</B> This page has expired .");
                out.println("<script type=\"text/javascript\">");
                out.println("if(top.opener) {top.opener.parent.location.reload();window.close();}");
                int i = req.getRequestURL().toString().indexOf(req.getServletPath());
                if (i != -1) {
                    out.println("else{window.location.href='" + req.getRequestURL().toString().substring(0, i) + "';}");
                }
                out.println("</script>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        }
        catch (ErreurAsyncException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public HttpSession recupererSession(MyRequestWrapper request) {
        HttpSession session = null;
        try {
            session = request.getSession(true);
            int port = URLResolver.getRequestPort((HttpServletRequest)request);
            session.setAttribute("basePath", (Object)(URLResolver.getRequestScheme((HttpServletRequest)request) + "://" + request.getServerName() + (port == 80 || port == 443 ? "" : ":" + port)));
            SessionUtilisateur testUtilisateur = (SessionUtilisateur)session.getAttribute("session");
            if (testUtilisateur == null) {
                LOG.debug("! La session utilisateur n'existe pas");
                session = request.getSession(true);
                SessionUtilisateur su = new SessionUtilisateur(session);
                session.setAttribute("session", (Object)su);
                LOG.debug("La session utilisateur a \u00e9t\u00e9 cr\u00e9\u00e9e");
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return session;
    }
}

