/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.InfosConnexion;
import com.jsbsoft.jtf.database.SOSJDBCProxy;
import com.kportal.core.config.PropertyHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPoolMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicPoolMgr.class);
    static final String QUERY_TEST = "SELECT 1";
    private static Vector<InfosConnexion> listeConnections = new Vector();
    private static int iWait = 0;

    public static boolean testerConnexion(Connection conn) {
        boolean res = false;
        try {
            if (conn.isClosed()) {
                return false;
            }
            LOGGER.debug("BasicPoolMgr test connexion ");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(QUERY_TEST);
            if (rs.next()) {
                LOGGER.debug("BasicPoolMgr test connexion OK");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("BasicPoolMgr test connexion KO");
            return false;
        }
    }

    public static void dump() {
        LOGGER.debug("BasicPoolMgr dump");
        InfosConnexion infos = new InfosConnexion();
        int nbDispo = 0;
        int nbLongues = 0;
        ArrayList<InfosConnexion> lstConnexions = BasicPoolMgr.getCurrentConnections();
        for (int iConnexion = 0; iConnexion < lstConnexions.size(); ++iConnexion) {
            infos = lstConnexions.get(iConnexion);
            if (infos.estDisponible()) {
                ++nbDispo;
            }
            if (!infos.estLongue()) continue;
            ++nbLongues;
        }
        LOGGER.debug("  > " + nbDispo + " connection(s) libre(s)");
        LOGGER.debug("  > " + nbLongues + " connection(s) longue(s)");
    }

    public static int getNombreConnexionsDisponibles() {
        int nbDispo = 0;
        ArrayList<InfosConnexion> lstConnexions = BasicPoolMgr.getCurrentConnections();
        for (InfosConnexion element : lstConnexions) {
            if (!element.estDisponible()) continue;
            ++nbDispo;
        }
        return nbDispo;
    }

    public static int getNombreConnexionsOuvertes() {
        return BasicPoolMgr.getCurrentConnections().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(boolean connectionLongue) {
        InfosConnexion infos;
        block33: {
            LOGGER.debug("Recherche connexion");
            infos = new InfosConnexion();
            int iConnexion = 0;
            boolean fTrouve = false;
            Vector<InfosConnexion> vector = listeConnections;
            synchronized (vector) {
                int i;
                int nbConnexions = listeConnections.size();
                ArrayList<Integer> listeConnexionsHS = new ArrayList<Integer>(nbConnexions);
                while (!fTrouve && iConnexion < nbConnexions) {
                    infos = listeConnections.get(iConnexion);
                    if (infos.estDisponible()) {
                        BasicPoolMgr.calculeWait();
                        if (infos.getTsLiberation() > System.currentTimeMillis() - (long)iWait && BasicPoolMgr.testerConnexion(infos.getConnection())) {
                            fTrouve = true;
                        } else {
                            listeConnexionsHS.add(new Integer(iConnexion));
                        }
                    }
                    if (!fTrouve) {
                        ++iConnexion;
                        continue;
                    }
                    LOGGER.debug("Allocation connexion libre");
                }
                for (i = listeConnexionsHS.size() - 1; i >= 0; --i) {
                    listeConnections.remove((Integer)listeConnexionsHS.get(i));
                    LOGGER.info("Suppression d'une connexion d\u00e9pass\u00e9e > " + iWait / 60000 + " m");
                }
                nbConnexions = listeConnections.size();
                listeConnexionsHS.clear();
                if (!fTrouve) {
                    iConnexion = 0;
                    while (!fTrouve && iConnexion < nbConnexions) {
                        infos = listeConnections.get(iConnexion);
                        if (!infos.estDisponible()) {
                            if (!infos.estLongue()) {
                                BasicPoolMgr.calculeWait();
                                if (infos.getTsAllocation() < System.currentTimeMillis() - (long)iWait) {
                                    if (BasicPoolMgr.testerConnexion(infos.getConnection())) {
                                        fTrouve = true;
                                    } else {
                                        listeConnexionsHS.add(new Integer(iConnexion));
                                    }
                                }
                            } else if (infos.getTsAllocation() < System.currentTimeMillis() - 28800000L) {
                                if (BasicPoolMgr.testerConnexion(infos.getConnection())) {
                                    fTrouve = true;
                                } else {
                                    listeConnexionsHS.add(new Integer(iConnexion));
                                }
                            }
                        }
                        if (!fTrouve) {
                            ++iConnexion;
                            continue;
                        }
                        LOGGER.debug("Allocation connexion non lib\u00e9r\u00e9e depuis " + (System.currentTimeMillis() - infos.getTsAllocation()) + " s");
                    }
                }
                for (i = listeConnexionsHS.size() - 1; i >= 0; --i) {
                    InfosConnexion infosC = listeConnections.get((Integer)listeConnexionsHS.get(i));
                    listeConnections.remove((Integer)listeConnexionsHS.get(i));
                    LOGGER.info("Suppression d'une connexion bloqu\u00e9e > " + (infosC.estLongue() ? "8 h" : iWait / 60000 + " m"));
                }
                if (fTrouve) {
                    infos.setLongue(connectionLongue);
                    infos.setDisponible(false);
                    infos.setTsAllocation(System.currentTimeMillis());
                }
            }
            if (!fTrouve) {
                try {
                    String truncation;
                    String password;
                    infos = new InfosConnexion();
                    String driver = PropertyHelper.getCoreProperty("datastore.default.driver");
                    if (driver != null) {
                        Class.forName(driver);
                    }
                    Properties props = new Properties();
                    String user = PropertyHelper.getCoreProperty("datastore.default.user");
                    if (user != null) {
                        props.put("user", user);
                    }
                    if ((password = PropertyHelper.getCoreProperty("datastore.default.password")) != null) {
                        props.put("password", password);
                    }
                    if ((truncation = PropertyHelper.getCoreProperty("datastore.default.truncation")) == null) {
                        truncation = "false";
                    }
                    props.put("characterEncoding", "UTF-8".toLowerCase().replace("-", ""));
                    props.put("jdbcCompliantTruncation", truncation);
                    props.put("dontTrackOpenResources", "true");
                    props.put("connectTimeout", "5000");
                    props.put("zeroDateTimeBehavior", "convertToNull");
                    String url = PropertyHelper.getCoreProperty("datastore.default.url");
                    if (url == null) break block33;
                    Connection connection = SOSJDBCProxy.createJdbcProxy(DriverManager.getConnection(url, props));
                    infos.setConnection(connection);
                    infos.setLongue(connectionLongue);
                    infos.setDisponible(false);
                    infos.setTsAllocation(System.currentTimeMillis());
                    Vector<InfosConnexion> vector2 = listeConnections;
                    synchronized (vector2) {
                        listeConnections.add(infos);
                        LOGGER.debug("BasicPoolMgr nouvelle connexion : " + listeConnections.size() + " connexions stock\u00e9es.");
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        }
        infos.setStackTrace(Thread.currentThread().getStackTrace());
        return infos.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(Connection _connection) {
        LOGGER.debug("BasicPoolMgr Remise d'une connexion dans le pool");
        SOSJDBCProxy.cleanConnection(_connection);
        Vector<InfosConnexion> vector = listeConnections;
        synchronized (vector) {
            int iConnexion = 0;
            boolean fTrouve = false;
            while (!fTrouve && iConnexion < listeConnections.size()) {
                InfosConnexion infos = listeConnections.get(iConnexion);
                if (infos.getConnection().equals(_connection)) {
                    if (infos.estDisponible()) {
                        LOGGER.warn("BasicPoolMgr : la connection est deja liberee");
                    }
                    infos.setTsLiberation(System.currentTimeMillis());
                    infos.setDisponible(true);
                    infos.setStackTrace(null);
                    fTrouve = true;
                }
                if (fTrouve) continue;
                ++iConnexion;
            }
        }
    }

    private static void calculeWait() {
        if (iWait == 0) {
            String wait_timeout = PropertyHelper.getCoreProperty("datastore.default.wait_timeout");
            if (wait_timeout == null) {
                wait_timeout = "600000";
            }
            try {
                iWait = Integer.parseInt(wait_timeout);
                if (iWait == 0) {
                    iWait = 600000;
                }
            }
            catch (Exception e) {
                iWait = 600000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<InfosConnexion> getCurrentConnections() {
        Vector<InfosConnexion> vector = listeConnections;
        synchronized (vector) {
            ArrayList<InfosConnexion> copie = new ArrayList<InfosConnexion>(listeConnections);
            return copie;
        }
    }
}

