/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.MySQLDatabaseManager;
import com.jsbsoft.jtf.database.SQLServerDatabaseManager;
import com.kportal.core.config.PropertyHelper;

public abstract class DatabaseServerManager {
    private static DatabaseServerManager instance = null;

    public static DatabaseServerManager getInstance() {
        if (instance == null) {
            String serveur = PropertyHelper.getCoreProperty("datastore.default.serveur");
            if (serveur == null || serveur.equals("mysql")) {
                instance = new MySQLDatabaseManager();
            } else if (serveur.equals("sqlserver")) {
                instance = new SQLServerDatabaseManager();
            }
        }
        return instance;
    }

    public abstract Long genererObjectId();

    public static Long getObjectId() {
        return DatabaseServerManager.getInstance().genererObjectId();
    }

    public abstract String genererRequeteClauseLimit(String var1, String var2, String var3, int var4, int var5);

    public static String getRequeteClauseLimit(String table, String baseQuery, String sqlSuffix, int debut, int increment) {
        return DatabaseServerManager.getInstance().genererRequeteClauseLimit(table, baseQuery, sqlSuffix, debut, increment);
    }

    public abstract String genererRequeteSelectCount(String var1, String var2, String var3);

    public static String getRequeteSelectCount(String table, String qualifier, String sqlSuffix) {
        return DatabaseServerManager.getInstance().genererRequeteSelectCount(table, qualifier, sqlSuffix);
    }

    public abstract String genererRequeteSelectDistinctCount(String var1, String var2, String var3);

    public static String getRequeteSelectDistinctCount(String table, String qualifier, String sqlSuffix) {
        return DatabaseServerManager.getInstance().genererRequeteSelectDistinctCount(table, qualifier, sqlSuffix);
    }
}

