/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCUtils.class);
    protected static Logger tempLogger = null;

    public static boolean existe(Connection connection, String nomTable) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet tables = dmd.getTables(connection.getCatalog(), null, nomTable, null);
        boolean existe = tables.next();
        tables.close();
        return existe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ajouterIndex(Connection connection, String table, String champ) throws Exception {
        try (Statement stmt = null;){
            String[] items = champ.split("\\*", -2);
            String nomChamp = items[0];
            String lg = "";
            if (items.length == 2) {
                lg = "(" + items[1] + ")";
            }
            String commande = "ALTER TABLE " + table + " ADD INDEX IDX_" + nomChamp + "(" + nomChamp + lg + ")";
            stmt = connection.prepareStatement(commande);
            stmt.executeUpdate();
            JDBCUtils.getLogger().info(commande);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> lireIndexs(Connection connection, String table) throws Exception {
        ArrayList<String> listIndexs = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String commande = "SHOW INDEX FROM " + table;
        try {
            stmt = connection.prepareStatement(commande);
            rs = stmt.executeQuery();
            while (rs.next()) {
                listIndexs.add(rs.getString("Column_name").toUpperCase());
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return listIndexs;
    }

    public static void mettreAJourIndexsTable(Connection connection, String table, List<String> listeTotaleIndexs) throws Exception {
        List<String> listeIndexsLus = JDBCUtils.lireIndexs(connection, table);
        for (String indexCourant : listeTotaleIndexs) {
            boolean misAjour;
            String[] items = indexCourant.split("\\*", -2);
            String nomChamp = items[0];
            if (("DIFFUSION_PUBLIC_VISE".equals(nomChamp) || "DIFFUSION_PUBLIC_VISE_RESTRICTION".equals(nomChamp) || "META_DIFFUSION_PUBLIC_VISE".equals(nomChamp) || "META_DIFFUSION_PUBLIC_VISE_RESTRICTION".equals(nomChamp)) && (misAjour = JDBCUtils.mettreAJourChamp(connection, table, nomChamp)) && listeIndexsLus.contains(nomChamp)) {
                listeIndexsLus.remove(nomChamp);
            }
            if (listeIndexsLus.contains(nomChamp)) continue;
            JDBCUtils.ajouterIndex(connection, table, indexCourant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mettreAJourChamp(Connection connexion, String table, String champ) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String commande = "DESC " + table;
        boolean misAJour = false;
        try {
            stmt = connexion.prepareStatement(commande);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String nomColonne = rs.getString("Field");
                if (!nomColonne.equalsIgnoreCase(champ) || rs.getString("Type").equalsIgnoreCase("text")) continue;
                if (!rs.getString("Key").equalsIgnoreCase("")) {
                    String nomIndex = JDBCUtils.lireNomIndex(connexion, table, champ);
                    JDBCUtils.supprimerIndex(connexion, table, nomIndex);
                }
                JDBCUtils.changerTypeChamp(connexion, table, champ);
                misAJour = true;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return misAJour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changerTypeChamp(Connection connexion, String table, String nomChamp) throws Exception {
        try (Statement stmt = null;){
            String commande = "ALTER TABLE " + table + " CHANGE " + nomChamp + " " + nomChamp + " TEXT";
            stmt = connexion.prepareStatement(commande);
            stmt.executeUpdate();
            JDBCUtils.getLogger().info(commande);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void supprimerIndex(Connection connexion, String table, String nomIndex) throws Exception {
        try (Statement stmt = null;){
            String commande = "ALTER TABLE " + table + " DROP INDEX " + nomIndex;
            stmt = connexion.prepareStatement(commande);
            stmt.executeUpdate();
            JDBCUtils.getLogger().info(commande);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lireNomIndex(Connection connexion, String table, String champ) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String commande = "SHOW INDEX FROM " + table;
        String res = "";
        try {
            stmt = connexion.prepareStatement(commande);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String nomColonne = rs.getString("Column_name");
                if (!nomColonne.equalsIgnoreCase(champ)) continue;
                res = rs.getString("Key_name");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return res;
    }

    public static Logger getLogger() {
        return tempLogger != null ? tempLogger : LOGGER;
    }

    public static void setTempLogger(Logger _tempLogger) {
        tempLogger = _tempLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getNextAutoIncrement(Connection connection, String table, int nbRow) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String commande = String.format("SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_NAME = '%s' AND TABLE_SCHEMA = '%s'", table, connection.getCatalog());
        Long res = 0L;
        try {
            stmt = connection.prepareStatement(commande);
            rs = stmt.executeQuery();
            rs.next();
            res = rs.getLong(1);
            if (nbRow > 0) {
                commande = String.format("ALTER TABLE `%s` AUTO_INCREMENT = %d", table, res + (long)nbRow);
                stmt.close();
                stmt = connection.prepareStatement(commande);
                stmt.execute();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return res + (long)nbRow - 1L;
    }
}

