/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.univ.utils.ContexteDao;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLDumpWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDumpWriter.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_COLUMN_QUOTE = "";
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DEFAULT_ENGINE = "MyISAM";
    private static final String DEFAULT_CHARSET = "utf8";
    private static final Integer[] SET_SIZE_TYPE = new Integer[]{12};
    private boolean exportData = true;
    private boolean exportStructure = true;
    private Map<String, Map<String, String>> tablesInfos;

    public void dumpDB(List<String> tables, String filePath) throws IOException {
        File dumpFile = new File(filePath);
        FileUtils.touch((File)dumpFile);
        try (ContexteDao contexteDao = new ContexteDao();
             Connection connection = contexteDao.getConnection();){
            DatabaseMetaData dbMetaData = connection.getMetaData();
            try (FileOutputStream outputStream = new FileOutputStream(dumpFile);
                 OutputStreamWriter outW = new OutputStreamWriter(outputStream);
                 BufferedWriter out = new BufferedWriter(outW);){
                ResultSet rs = dbMetaData.getTables(null, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    String tableType;
                    String tableName = rs.getString("TABLE_NAME");
                    if ((tables.isEmpty() || tables.contains(tableName)) && "TABLE".equalsIgnoreCase(tableType = rs.getString("TABLE_TYPE"))) {
                        out.write(LINE_SEPARATOR + "-- TABLE " + tableName);
                        if (this.exportStructure) {
                            out.write(LINE_SEPARATOR + "CREATE TABLE `" + tableName + "` (" + LINE_SEPARATOR);
                            ResultSet tableMetaData = dbMetaData.getColumns(null, null, tableName, "%");
                            boolean firstLine = true;
                            while (tableMetaData.next()) {
                                if (firstLine) {
                                    firstLine = false;
                                } else {
                                    out.write("," + LINE_SEPARATOR);
                                }
                                String columnName = tableMetaData.getString("COLUMN_NAME");
                                String columnType = tableMetaData.getString("TYPE_NAME");
                                short columnDataType = tableMetaData.getShort("DATA_TYPE");
                                int columnSize = tableMetaData.getInt("COLUMN_SIZE");
                                String columnSizeString = DEFAULT_COLUMN_QUOTE;
                                if (Arrays.asList(SET_SIZE_TYPE).contains(columnDataType)) {
                                    columnSizeString = " (" + columnSize + ")";
                                }
                                String nullString = "YES".equals(tableMetaData.getString("IS_NULLABLE")) ? " NULL" : " NOT NULL";
                                String autoincrement = "YES".equals(tableMetaData.getString("IS_AUTOINCREMENT")) ? " auto_increment" : DEFAULT_COLUMN_QUOTE;
                                out.write("    " + columnName + DEFAULT_COLUMN_QUOTE + " " + columnType + columnSizeString + nullString + autoincrement);
                            }
                            tableMetaData.close();
                            try {
                                ResultSet primaryKeys = dbMetaData.getPrimaryKeys(null, null, tableName);
                                String primaryKeyName = null;
                                StringBuffer primaryKeyColumns = new StringBuffer();
                                while (primaryKeys.next()) {
                                    String thisKeyName = primaryKeys.getString("PK_NAME");
                                    if (thisKeyName != null && primaryKeyName == null || thisKeyName == null && primaryKeyName != null || thisKeyName != null && !thisKeyName.equals(primaryKeyName) || primaryKeyName != null && !primaryKeyName.equals(thisKeyName)) {
                                        if (primaryKeyColumns.length() > 0) {
                                            out.write("," + LINE_SEPARATOR + "    PRIMARY KEY ");
                                            out.write("(" + primaryKeyColumns.toString() + ")");
                                        }
                                        primaryKeyColumns = new StringBuffer();
                                        primaryKeyName = thisKeyName;
                                    }
                                    if (primaryKeyColumns.length() > 0) {
                                        primaryKeyColumns.append(", ");
                                    }
                                    primaryKeyColumns.append(primaryKeys.getString("COLUMN_NAME"));
                                }
                                if (primaryKeyColumns.length() > 0) {
                                    out.write("," + LINE_SEPARATOR + "    PRIMARY KEY ");
                                    out.write("(" + primaryKeyColumns.toString() + ")");
                                }
                            }
                            catch (SQLException e) {
                                LOGGER.error("Unable to get primary keys for table " + tableName + " because " + e);
                            }
                            String engine = this.getTableProperty(tableName, "Engine");
                            String collation = this.getTableProperty(tableName, "Collation");
                            out.write(LINE_SEPARATOR + ")");
                            out.write(String.format(" ENGINE=%s", StringUtils.isNotBlank((CharSequence)engine) ? engine : DEFAULT_ENGINE));
                            if (StringUtils.isNotBlank((CharSequence)collation)) {
                                out.write(String.format(" DEFAULT CHARACTER SET %s COLLATE %s", StringUtils.substringBefore((String)collation, (String)"_"), collation));
                            } else {
                                out.write(String.format(" DEFAULT CHARSET = %s", DEFAULT_CHARSET));
                            }
                            out.write(DEFAULT_DELIMITER + LINE_SEPARATOR);
                        }
                        if (this.exportData) {
                            this.dumpTable(out, tableName);
                        }
                    }
                    ((Writer)out).flush();
                }
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error("erreur lors de la requete SQL", (Throwable)e);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to connect to database: " + e);
        }
    }

    private void dumpTable(Writer out, String tableName) throws IOException {
        try (ContexteDao contexteDao = new ContexteDao();
             Connection connection = contexteDao.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT * FROM `%s`", tableName));
             ResultSet rs = stmt.executeQuery();){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            out.write(LINE_SEPARATOR + "-- INSERT FOR " + tableName + LINE_SEPARATOR);
            while (rs.next()) {
                out.write("INSERT INTO " + tableName + " VALUES (");
                for (int i = 0; i < columnCount; ++i) {
                    Object value;
                    if (i > 0) {
                        out.write(", ");
                    }
                    if ((value = rs.getObject(i + 1)) == null) {
                        out.write("NULL");
                        continue;
                    }
                    out.write(String.format("'%s'", this.getMysqlRealScapeString(value.toString())));
                }
                out.write(");" + LINE_SEPARATOR);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to dump table " + tableName + " because: " + e);
        }
    }

    public void setExportData(boolean exportData) {
        this.exportData = exportData;
    }

    public void setExportStructure(boolean exportStructure) {
        this.exportStructure = exportStructure;
    }

    private String getMysqlRealScapeString(String str) {
        String data = null;
        if (str != null && str.length() > 0) {
            str = str.replace("\\", "\\\\");
            str = str.replace("'", "\\'");
            str = str.replace("\u0000", "\\0");
            str = str.replace("\n", "\\n");
            str = str.replace("\r", "\\r");
            str = str.replace("\"", "\\\"");
            data = str = str.replace("\\x1a", "\\Z");
        }
        return data;
    }

    private String getTableProperty(String tableName, String property) {
        Map<String, String> infos;
        if (this.tablesInfos == null) {
            this.getTablesInfos();
        }
        if ((infos = this.tablesInfos.get(tableName)) != null) {
            return infos.get(property);
        }
        return DEFAULT_COLUMN_QUOTE;
    }

    private void getTablesInfos() {
        this.tablesInfos = new HashMap<String, Map<String, String>>();
        try (ContexteDao contexteDao = new ContexteDao();
             Connection connection = contexteDao.getConnection();
             PreparedStatement stmt = connection.prepareStatement("SHOW TABLE STATUS");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String name = rs.getString("Name");
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                Map<String, String> currentMap = this.tablesInfos.get(name);
                if (currentMap == null) {
                    currentMap = new HashMap<String, String>();
                    this.tablesInfos.put(name, currentMap);
                }
                ResultSetMetaData meta = rs.getMetaData();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String key = meta.getColumnLabel(i);
                    String value = rs.getString(key);
                    currentMap.put(key, value);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Une erreur est survenue lors de la r\u00e9cup\u00e9ration des informations concernants les tables", (Throwable)e);
        }
    }
}

