/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.JDBCUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLScriptLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLScriptLoader.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DROP_TABLE_COMMAND = "DROP TABLE ?";
    private static final String TRUNCATE_TABLE_COMMAND = "DELETE FROM ?";
    private final Connection connection;
    private boolean stopOnError;
    private boolean onlyCreateTable;
    private boolean removeCRs;
    private boolean escapeProcessing = true;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;
    private final List<String> createdTables = new ArrayList<String>();
    private final List<String> existingTables = new ArrayList<String>();

    public MySQLScriptLoader(Connection connection) {
        this.connection = connection;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void setRemoveCRs(boolean removeCRs) {
        this.removeCRs = removeCRs;
    }

    public void setEscapeProcessing(boolean escapeProcessing) {
        this.escapeProcessing = escapeProcessing;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFullLineDelimiter(boolean fullLineDelimiter) {
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public List<String> getCreatedTables() {
        return this.createdTables;
    }

    public void runScript(Reader reader) throws Exception {
        try {
            this.executeLineByLine(reader);
        }
        finally {
            this.rollbackConnection();
        }
    }

    private void executeLineByLine(Reader reader) throws Exception {
        StringBuilder command = new StringBuilder();
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                command = this.handleLine(command, line);
            }
            this.commitConnection();
            this.checkForMissingLineTerminator(command);
        }
        catch (Exception e) {
            if (this.stopOnError) {
                for (String table : this.createdTables) {
                    this.executeDropTable(table);
                }
            }
            throw new Exception("Error executing: " + command + ".  Cause: " + e, e);
        }
    }

    private void commitConnection() throws Exception {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException t) {
            throw new Exception("Could not commit transaction. Cause: " + t, t);
        }
    }

    private void rollbackConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkForMissingLineTerminator(StringBuilder command) throws Exception {
        if (command != null && command.toString().trim().length() > 0) {
            throw new Exception("Line missing end-of-line terminator (" + this.delimiter + ") => " + command);
        }
    }

    private StringBuilder handleLine(StringBuilder command, String line) throws SQLException, UnsupportedEncodingException {
        String trimmedLine = line.trim();
        if (!this.lineIsComment(trimmedLine) && this.commandReadyToExecute(trimmedLine)) {
            command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
            command.append(LINE_SEPARATOR);
            this.executeStatement(command.toString());
            command.setLength(0);
        } else if (!this.lineIsComment(trimmedLine) && trimmedLine.length() > 0) {
            command.append(line);
            command.append(LINE_SEPARATOR);
        }
        return command;
    }

    private boolean lineIsComment(String trimmedLine) {
        return trimmedLine.startsWith("//") || trimmedLine.startsWith("--");
    }

    private boolean commandReadyToExecute(String trimmedLine) {
        return !this.fullLineDelimiter && trimmedLine.contains(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter);
    }

    private void executeStatement(String command) throws SQLException, UnsupportedEncodingException {
        String sql = command;
        if (this.removeCRs) {
            sql = sql.replaceAll("\r\n", "\n");
        }
        String table = null;
        if (this.isCommandCreateTable(sql)) {
            table = this.getTableFromCommand(sql);
            if (JDBCUtils.existe(this.connection, table)) {
                this.existingTables.add(table);
                return;
            }
        } else if (this.onlyCreateTable) {
            return;
        }
        boolean hasResults = false;
        Statement statement = this.connection.createStatement();
        statement.setEscapeProcessing(this.escapeProcessing);
        if (this.stopOnError) {
            hasResults = statement.execute(sql);
            if (StringUtils.isNotEmpty((CharSequence)table)) {
                this.createdTables.add(table);
            }
        } else {
            try {
                hasResults = statement.execute(sql);
                if (StringUtils.isNotEmpty((CharSequence)table)) {
                    this.createdTables.add(table);
                }
            }
            catch (SQLException e) {
                String message = "Error executing: " + command + ".  Cause: " + e;
                LOG.error(message);
            }
        }
        this.printResults(statement, hasResults);
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTableFromCommand(String command) {
        command = StringUtils.remove((String)command, (String)" ");
        command = StringUtils.remove((String)command, (String)"`");
        Pattern compile = Pattern.compile("CREATETABLE([\\S&&[^\\(]]+)[\\(]*");
        Matcher matcher = compile.matcher(command.toUpperCase());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private boolean isCommandCreateTable(String command) {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.remove((String)command, (String)" "), (CharSequence)"CREATETABLE");
    }

    public void executeDropTable(String table) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(StringUtils.replace((String)DROP_TABLE_COMMAND, (String)"?", (String)table));
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            LOG.error("erreur lors du drop table", (Throwable)e);
        }
    }

    public void executeTruncateTable(String table) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(StringUtils.replace((String)TRUNCATE_TABLE_COMMAND, (String)"?", (String)table));
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            LOG.error("erreur lors du truncate table", (Throwable)e);
        }
    }

    private void printResults(Statement statement, boolean hasResults) {
        try {
            ResultSet rs;
            if (hasResults && (rs = statement.getResultSet()) != null) {
                int i;
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                for (i = 0; i < cols; ++i) {
                    String name = md.getColumnLabel(i + 1);
                    LOG.info(name + "\t");
                }
                LOG.info("");
                while (rs.next()) {
                    for (i = 0; i < cols; ++i) {
                        String value = rs.getString(i + 1);
                        LOG.info(value + "\t");
                    }
                    LOG.info("");
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Error printing results: " + e.getMessage());
        }
    }

    public void setDoOnlyCreateTable(boolean b) {
        this.onlyCreateTable = b;
    }

    public List<String> getExistingTables() {
        return this.existingTables;
    }
}

