/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.core.AbstractProcessusBean;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurTechnique;
import com.jsbsoft.jtf.exception.JsbException;
import com.univ.multisites.InfosSite;
import com.univ.utils.ContexteUtil;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessusBean
extends AbstractProcessusBean
implements OMContext {
    private Connection connection = null;
    protected String action = null;
    private InfosSite infosSite = null;
    private boolean secure = false;
    private Hashtable<String, Object> datas = new Hashtable();
    private static final Logger LOG = LoggerFactory.getLogger(ProcessusBean.class);

    public ProcessusBean(InfoBean infoBean) {
        super(infoBean);
    }

    public Hashtable<String, Object> getDatas() {
        return this.datas;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Locale getLocale() {
        return ContexteUtil.getContexteUniv().getLocale();
    }

    @Override
    protected void initConnection() throws JsbException {
        if (this.connection == null) {
            try {
                this.connection = BasicPoolMgr.getConnection(false);
            }
            catch (Exception e) {
                throw new ErreurTechnique(0, e.getMessage());
            }
        }
    }

    @Override
    protected void releaseConnection() throws JsbException {
        if (this.connection != null) {
            try {
                BasicPoolMgr.releaseConnection(this.connection);
                this.connection = null;
            }
            catch (Exception e) {
                throw new ErreurTechnique(0, e.getMessage());
            }
        }
    }

    @Override
    public void traiterAbandon() {
        try {
            this.releaseConnection();
        }
        catch (Exception e) {
            LOG.error("erreur lors de la lib\u00e9ration de la connexion \u00e0 la base", (Throwable)e);
        }
    }

    @Override
    public void setInfosSite(InfosSite infosSite) {
        this.infosSite = infosSite;
    }

    @Override
    public InfosSite getInfosSite() {
        return this.infosSite;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }
}

