/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.jsbsoft.jtf.database.EtatRequete;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.jsbsoft.jtf.webutils.FormateurHTML;
import com.kportal.core.config.PropertyHelper;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeteMgr {
    private static String idRequete = String.valueOf(System.currentTimeMillis());
    private static TreeMap<String, EtatRequete> events = new TreeMap();
    private static final Logger LOG = LoggerFactory.getLogger(RequeteMgr.class);

    public static synchronized String creerRequete() {
        idRequete = String.valueOf(Long.parseLong(idRequete) + 1L);
        events.put(idRequete, new EtatRequete());
        Vector<String> aSupprimer = new Vector<String>();
        Vector<String> aLogger = new Vector<String>();
        long maintenant = System.currentTimeMillis();
        for (String id : events.keySet()) {
            EtatRequete requete = events.get(id);
            if (requete.isTerminee()) {
                if (maintenant - requete.getTimestampDebut() <= 30000L) continue;
                aSupprimer.add(id);
                continue;
            }
            if (maintenant - requete.getTimestampDebut() <= 60000L) continue;
            aLogger.add(id);
            aSupprimer.add(id);
        }
        if ("1".equals(PropertyHelper.getCoreProperty("dump.detection_boucle")) && !aLogger.isEmpty()) {
            String dump = "";
            Enumeration e1 = aLogger.elements();
            while (e1.hasMoreElements()) {
                String id = (String)e1.nextElement();
                dump = dump + "\n***** DUMP REQUETE ************";
                dump = dump + "\"" + RequeteMgr.dumpRequete(events.get(id));
                dump = dump + "\n***** FIN DUMP ********************";
                LOG.info(dump);
            }
            try {
                JSBMailbox mailbox = new JSBMailbox(false);
                String sujet = "[Requete non termin\u00e9e ?] > A ANALYSER";
                mailbox.sendSystemMsg("debug@kosmos.fr", "[Requete non termin\u00e9e ?] > A ANALYSER", dump);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Enumeration e2 = aSupprimer.elements();
        while (e2.hasMoreElements()) {
            String id = (String)e2.nextElement();
            events.remove(id);
        }
        return idRequete;
    }

    public static synchronized void ajouterEvenement(String id, String evenement) {
        GregorianCalendar gCal = new GregorianCalendar();
        SimpleDateFormat formateur = new SimpleDateFormat("hh:mm:ss:SSS");
        if (id != null && id.length() > 0 && events.get(id) != null) {
            events.get(id).ajouterEvenement(formateur.format(gCal.getTime()) + "\n" + evenement);
        }
    }

    public static synchronized void terminerRequete(String id) {
        if (id != null && id.length() > 0 && events.get(id) != null) {
            events.get(id).terminer();
        }
    }

    public static synchronized String dump() {
        String res = "";
        long delai = 0L;
        int nbRequetesTerminees = 0;
        for (EtatRequete requete : events.values()) {
            if (!requete.isTerminee()) continue;
            delai += requete.getTimestampFin() - requete.getTimestampDebut();
            ++nbRequetesTerminees;
        }
        if (nbRequetesTerminees > 0) {
            res = res + "<br /> Nb requetes OK (30 derni\u00e8res sec)= " + nbRequetesTerminees;
            res = res + "<br /> Dur\u00e9e moyenne = " + delai / (long)nbRequetesTerminees + " ms";
            res = res + "<br> Nombre de connexions ouvertes sur la base de donn\u00e9es =" + BasicPoolMgr.getNombreConnexionsOuvertes();
            res = res + "<br> Nombre de connexions disponibles sur la base de donn\u00e9es =" + BasicPoolMgr.getNombreConnexionsDisponibles();
        }
        Iterator<EtatRequete> iter = events.values().iterator();
        res = res + "<font color=\"red\">";
        res = res + "<br /> Nb requ\u00eates en cours (d\u00e9lai purge = 60 s.) = " + (events.size() - nbRequetesTerminees);
        while (iter.hasNext()) {
            EtatRequete requete;
            requete = iter.next();
            if (requete.isTerminee()) continue;
            res = res + "<br />-----REQUETE -------------";
            res = res + "<br />" + FormateurHTML.formaterEnHTML(RequeteMgr.dumpRequete(requete));
        }
        res = res + "</font>";
        String requetesTerminees = "";
        for (EtatRequete requete : events.values()) {
            if (!requete.isTerminee()) continue;
            requetesTerminees = "<br />-----REQUETE -------------<br />" + FormateurHTML.formaterEnHTML(RequeteMgr.dumpRequete(requete)) + requetesTerminees;
        }
        res = res + requetesTerminees;
        return res;
    }

    public static synchronized String dumpDernieresRequetesNonTerminees() {
        String res = "";
        String logRequete = "";
        long maintenant = System.currentTimeMillis();
        for (String id : events.keySet()) {
            EtatRequete requete = events.get(id);
            if (requete.isTerminee() || maintenant - requete.getTimestampDebut() >= 3000L) continue;
            logRequete = "\n-----REQUETE -------------\n" + RequeteMgr.dumpRequete(requete) + logRequete;
        }
        res = res + logRequete;
        return res;
    }

    public static synchronized void purgerRequetesNonTerminees() {
        Vector<String> aSupprimer = new Vector<String>();
        long maintenant = System.currentTimeMillis();
        for (String id : events.keySet()) {
            EtatRequete requete = events.get(id);
            if (requete.isTerminee() || maintenant - requete.getTimestampDebut() >= 3000L) continue;
            aSupprimer.add(id);
        }
        Enumeration e2 = aSupprimer.elements();
        while (e2.hasMoreElements()) {
            String id = (String)e2.nextElement();
            events.remove(id);
        }
    }

    public static synchronized String dumpRequete(EtatRequete requete) {
        String res = "";
        Enumeration<String> e = requete.getEvenements().elements();
        while (e.hasMoreElements()) {
            res = res + "\n" + e.nextElement() + "\n...............";
        }
        return res;
    }
}

