/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.SOSJDBCProxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSJDBCDriver
implements Driver {
    private static final Logger LOG = LoggerFactory.getLogger(SOSJDBCDriver.class);

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("sos:");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        url = url.substring(4);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getName() + ".connect(" + url + ")");
        }
        return (Connection)Connection.class.cast(SOSJDBCProxy.createJdbcProxy(DriverManager.getDriver(url).connect(url, info)));
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        url = url.substring(4);
        return DriverManager.getDriver(url).getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new SOSJDBCDriver());
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }
}

