/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.SOSJDBCProxyInterface;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSJDBCProxy
implements InvocationHandler,
SOSJDBCProxyInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SOSJDBCProxy.class);
    private static List<Class<?>> wrappedClasses = Arrays.asList(Connection.class, CallableStatement.class, PreparedStatement.class, Statement.class, ResultSet.class);
    private SOSJDBCProxy wrappedcx = null;
    private List<Object> resourcesProxy = null;
    private List<Object> resourcesOriginal = null;
    private Class<?> clazz = null;
    private Object wrapped = null;

    public static Connection createJdbcProxy(Connection cx) {
        return (Connection)SOSJDBCProxy.createJdbcProxy(null, Connection.class, cx);
    }

    private static Object createJdbcProxy(SOSJDBCProxy wrappedcx, Class<?> clazz, Object wrapped) {
        try {
            if (wrapped == null) {
                return null;
            }
            return Proxy.newProxyInstance(wrapped.getClass().getClassLoader(), new Class[]{clazz, SOSJDBCProxyInterface.class}, (InvocationHandler)new SOSJDBCProxy(wrappedcx, clazz, wrapped));
        }
        catch (Exception ex) {
            throw (RuntimeException)ex;
        }
    }

    public SOSJDBCProxy(SOSJDBCProxy wrappedproxy, Class<?> clazz, Object wrapped) {
        this.wrappedcx = wrappedproxy;
        if (this.wrappedcx == null) {
            if (clazz.equals(Connection.class)) {
                this.wrappedcx = this;
                this.resourcesProxy = new Vector<Object>();
                this.resourcesOriginal = new Vector<Object>();
            } else {
                throw new RuntimeException("SOSJDBC : Erreur Fatale : La connection associ\u00e9e ne doit pas \u00eatre nulle!");
            }
        }
        this.clazz = clazz;
        this.wrapped = wrapped;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (SOSJDBCProxyInterface.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (LOG.isDebugEnabled() && (declaringClass.equals(SOSJDBCProxyInterface.class) || wrappedClasses.contains(declaringClass))) {
            LOG.debug("(" + this.clazz.getName() + ")" + this.wrapped + "." + method.getName() + "(" + (args == null ? "" : ArrayUtils.toString((Object)args)) + ")");
        }
        if (method.getName().equals("close") && (args == null || args.length == 0)) {
            if (this.clazz.equals(Connection.class)) {
                SOSJDBCProxy.cleanConnection((Connection)Connection.class.cast(proxy));
            } else {
                this.removeResource(proxy);
            }
        }
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!SOSJDBCProxy.isProxy(args[0])) continue;
                args[0] = ((SOSJDBCProxyInterface)args[0]).getWrapped();
            }
        }
        if (method.getName().equals("prepareStatement") && args != null && args.length == 1 && args[0] instanceof String && ((String)args[0]).toLowerCase().trim().startsWith("insert")) {
            method = declaringClass.getMethod("prepareStatement", String.class, Integer.TYPE);
            args = new Object[]{args[0], 1};
        }
        try {
            Object result = method.invoke(this.wrapped, args);
            if (result != null && !SOSJDBCProxy.isProxy(result)) {
                Class<?> returnClass = method.getReturnType();
                for (Class<?> wrappedClass : wrappedClasses) {
                    if (!wrappedClass.isAssignableFrom(returnClass)) continue;
                    Object resultOriginal = result;
                    result = SOSJDBCProxy.createJdbcProxy(this.wrappedcx, returnClass, returnClass.cast(result));
                    this.wrappedcx.addResource(resultOriginal, result);
                    break;
                }
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    public Object getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(Object orginal, Object proxy) {
        SOSJDBCProxy sOSJDBCProxy = this.wrappedcx;
        synchronized (sOSJDBCProxy) {
            if (!this.wrappedcx.resourcesOriginal.contains(orginal) && !(orginal instanceof Connection)) {
                this.wrappedcx.resourcesOriginal.add(orginal);
                this.wrappedcx.resourcesProxy.add(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(Object obj) {
        Object wrapped = obj;
        if (wrapped instanceof SOSJDBCProxyInterface) {
            wrapped = ((SOSJDBCProxyInterface)wrapped).getWrapped();
        }
        SOSJDBCProxy sOSJDBCProxy = this.wrappedcx;
        synchronized (sOSJDBCProxy) {
            int index = this.wrappedcx.resourcesOriginal.indexOf(wrapped);
            if (index >= 0) {
                this.wrappedcx.resourcesOriginal.remove(index);
                this.wrappedcx.resourcesProxy.remove(index);
            }
        }
    }

    @Override
    public List<Object> getResourcesProxy() {
        return this.resourcesProxy;
    }

    @Override
    public List<Object> getResourcesOriginales() {
        return this.resourcesOriginal;
    }

    public static boolean isProxy(Object obj) {
        return obj instanceof SOSJDBCProxyInterface;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanConnection(Connection c) {
        if (c == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleanConnection de " + c);
        }
        if (SOSJDBCProxy.isProxy(c)) {
            SOSJDBCProxyInterface proxyC = (SOSJDBCProxyInterface)((Object)c);
            List<Object> resourcesCxProxy = null;
            List<Object> resourcesCxOriginales = null;
            SOSJDBCProxyInterface sOSJDBCProxyInterface = proxyC;
            synchronized (sOSJDBCProxyInterface) {
                resourcesCxProxy = proxyC.getResourcesProxy();
                resourcesCxOriginales = proxyC.getResourcesOriginales();
            }
            int sizeResource = resourcesCxProxy.size();
            int count = 0;
            while (resourcesCxProxy.size() > 0) {
                ++count;
                int index = resourcesCxProxy.size() - 1;
                SOSJDBCProxyInterface obj = (SOSJDBCProxyInterface)resourcesCxProxy.get(index);
                try {
                    Method methClose = obj.getClazz().getMethod("close", new Class[0]);
                    methClose.invoke((Object)obj, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    LOG.error("SOSJDBC : Ressource impossible a closer " + obj.toString(), (Throwable)ex);
                }
                finally {
                    SOSJDBCProxyInterface sOSJDBCProxyInterface2 = proxyC;
                    synchronized (sOSJDBCProxyInterface2) {
                        if (index < resourcesCxProxy.size()) {
                            LOG.error("SOSJDBC : Ressource impossible a cleaner (nb ressouces proxy/originale:" + resourcesCxProxy.size() + "/" + resourcesCxOriginales.size() + "): " + obj.toString());
                            resourcesCxProxy.remove(index);
                            resourcesCxOriginales.remove(index);
                        }
                    }
                }
                if (count <= 3 * sizeResource) continue;
                LOG.error("SOSJDBC : CleanConnection impossible");
                throw new RuntimeException("for\u00e7age sortie de boucle cleanConnection");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cleanConnection termin\u00e9 " + c);
            }
        } else {
            throw new RuntimeException("Cette connexion n'est pas un proxy, elle ne peut pas \u00eatre nettoy\u00e9e:" + c);
        }
    }
}

