/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.database;

import com.jsbsoft.jtf.database.JDBCUtils;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ClassMetaUtil;
import com.univ.utils.ContexteDao;
import java.util.ArrayList;
import java.util.Arrays;

public class UpdateIndexDBJob
extends LogReportJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        try (ContexteDao ctx = new ContexteDao();){
            JDBCUtils.setTempLogger(this.logger);
            for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                FicheUniv fiche = ReferentielObjets.instancierFiche(codeObjet);
                if (fiche == null) continue;
                ArrayList<String> listeIndexs = new ArrayList<String>();
                listeIndexs.add("CODE");
                listeIndexs.add("ETAT_OBJET");
                listeIndexs.add(ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RATTACHEMENT"));
                listeIndexs.add("CODE_REDACTEUR");
                listeIndexs.add(ClassMetaUtil.getClassMetaValue(fiche, "NOM_CODE_RUBRIQUE"));
                if (fiche instanceof DiffusionSelective) {
                    listeIndexs.add("DIFFUSION_PUBLIC_VISE*100");
                    listeIndexs.add("DIFFUSION_MODE_RESTRICTION");
                    listeIndexs.add("DIFFUSION_PUBLIC_VISE_RESTRICTION*100");
                }
                JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), ReferentielObjets.getNomTableSql(codeObjet), listeIndexs);
            }
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "UTILISATEUR", Arrays.asList("CODE", "CODE_LDAP", "CODE_RATTACHEMENT"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ENCADRE", Arrays.asList("OBJETS*100", "ACTIF"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ESPACECOLLABORATIF", Arrays.asList("CODE", "CODE_RUBRIQUE", "CODE_STRUCTURE", "THEME"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RESSOURCE", Arrays.asList("CODE_PARENT"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "GROUPEDSI", Arrays.asList("CODE", "GESTION_CACHE", "ROLES*100"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "GROUPEUTILISATEUR", Arrays.asList("CODE_GROUPE", "CODE_UTILISATEUR", "SOURCE_IMPORT"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "LIBELLE", Arrays.asList("TYPE", "CODE", "LIBELLE", "LANGUE"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "METATAG", Arrays.asList("META_CODE", "META_CODE_OBJET", "META_CODE_RATTACHEMENT", "META_CODE_RUBRIQUE", "META_CODE_REDACTEUR", "META_LANGUE", "META_ETAT_OBJET", "META_DIFFUSION_PUBLIC_VISE*100", "META_DIFFUSION_MODE_RESTRICTION", "META_DIFFUSION_PUBLIC_VISE_RESTRICTION*100", "META_RUBRIQUES_PUBLICATION*100", "META_CODE_RATTACHEMENT_AUTRES*100", "META_ID_FICHE", "META_DATE_MISE_EN_LIGNE", "META_DATE_MODIFICATION"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "MEDIA", Arrays.asList("TITRE", "TYPE_RESSOURCE", "CODE_RUBRIQUE", "CODE_RATTACHEMENT"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "PREFERENCES", Arrays.asList("CODE_UTILISATEUR", "TYPE", "NOM", "SERVICE"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "ROLE", Arrays.asList("CODE"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RUBRIQUE", Arrays.asList("CODE", "LANGUE"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "RUBRIQUEPUBLICATION", Arrays.asList("TYPE_FICHE_ORIG", "CODE_FICHE_ORIG", "LANGUE_FICHE_ORIG", "RUBRIQUE_DEST", "SOURCE_REQUETE*100"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "SERVICE", Arrays.asList("CODE"));
            JDBCUtils.mettreAJourIndexsTable(ctx.getConnection(), "UTILISATEUR", Arrays.asList("CODE", "NOM", "CODE_LDAP", "CODE_RATTACHEMENT", "ROLES*100"));
            JDBCUtils.setTempLogger(null);
        }
    }
}

