/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.datasource.dao.impl.mysql;

import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DeleteFromDataSourceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommonDAO<T>
implements CommonDAO<T> {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractCommonDAO.class);
    private static final String SELECT_DISTINCT = "select DISTINCT %s from `%s` T1 ";
    private static final String COLUMNS_PREFIX = "T1.";
    protected final Set<String> columns = new HashSet<String>();
    protected DataSource dataSource;
    protected String tableName;
    private String columnsNameForRequest = null;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getColumns() throws DataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(String.format("select * from `%s` T1", this.tableName));){
                rs = stmt.executeQuery();
                ResultSetMetaData md = rs.getMetaData();
                int columnCount = md.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    this.columns.add(md.getColumnName(i));
                }
            }
            if (rs == null) return;
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException(String.format("An error occured retrieving columns for table %s", this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing ResultSet during getColumns() for table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing ResultSet during getColumns() for table %s", this.tableName), (Throwable)e);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public List<T> select(String request) throws DataSourceException {
        this.initColumns();
        ResultSet rs = null;
        ArrayList<T> results = new ArrayList<T>();
        String query = String.format(SELECT_DISTINCT, this.columnsNameForRequest, this.tableName);
        if (request != null) {
            query = query + request;
        }
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(query);){
                rs = stmt.executeQuery();
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
            if (rs == null) return results;
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException(String.format("Selection request on table \"%s\" failed", this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing ResultSet during select() for table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return results;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing ResultSet during select() for table %s", this.tableName), (Throwable)e);
            return results;
        }
    }

    private void initColumns() throws DataSourceException {
        if (this.columns.isEmpty() || StringUtils.isBlank((String)this.columnsNameForRequest)) {
            this.getColumns();
            Collection columnsName = CollectionUtils.collect(this.columns, (Transformer)new Transformer(){

                public String transform(Object input) {
                    return AbstractCommonDAO.COLUMNS_PREFIX + input;
                }
            });
            this.columnsNameForRequest = StringUtils.join((Collection)columnsName, (String)" , ");
        }
    }

    @Override
    public void delete(Long id) throws DeleteFromDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("delete from `%1$s` WHERE ID_%1$s = ?", this.tableName));){
            stmt.setObject(1, (Object)id, -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new DeleteFromDataSourceException(String.format("Table \"%s\" doesn't contain any row width id %d", this.tableName, id));
            }
            if (rowsAffected > 1) {
                throw new DeleteFromDataSourceException(String.format("Table \"%s\" contains more than one row width id %d", this.tableName, id));
            }
        }
        catch (SQLException e) {
            throw new DeleteFromDataSourceException(String.format("An error occured during deletion of row with id %d from table \"%s\"", id, this.tableName), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T getById(Long id) throws DataSourceException {
        ResultSet rs = null;
        T object = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(String.format("select * from `%1$s` T1 WHERE T1.ID_%1$s = ?", this.tableName));){
                stmt.setObject(1, (Object)id, -5);
                rs = stmt.executeQuery();
                if (!rs.first()) {
                    throw new DataSourceException(String.format("No row with id %d from table %s could be retrieved", id, this.tableName));
                }
                object = this.fill(rs);
            }
            if (rs == null) return object;
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException(String.format("An error occured retrieving object with id %d from table %s", id, this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing ResultSet during getById() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return object;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing ResultSet during getById() on table %s", this.tableName), (Throwable)e);
            return object;
        }
    }

    protected abstract T fill(ResultSet var1) throws DataSourceException;
}

