/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.datasource.manager.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.manager.DataSourceDAOManager;
import com.kportal.extension.module.AbstractBeanManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;

public class BasicDataSourceDAOManager
extends AbstractBeanManager
implements DataSourceDAOManager {
    public static final Logger LOG = LoggerFactory.getLogger(BasicDataSourceDAOManager.class);
    protected final Map<String, CommonDAO<?>> daosList = new HashMap();

    public Map<String, CommonDAO<?>> getDaosList() {
        return this.daosList;
    }

    @Override
    public <T> CommonDAO<T> getDao(Class<T> clazz) {
        CommonDAO<?> dao = null;
        if (this.daosList.containsKey(clazz.getName())) {
            dao = this.daosList.get(clazz.getName());
        }
        return dao;
    }

    @Override
    public void refresh() {
        Collection<CommonDAO> beans = ApplicationContextManager.getAllBeansOfType(CommonDAO.class).values();
        for (CommonDAO currentDao : beans) {
            Class<?> clazz = this.getDaoGenericType(currentDao);
            if (clazz != null) {
                this.daosList.put(clazz.getName(), currentDao);
                continue;
            }
            LOG.warn(String.format("Generic type for dao \"%s\" couldn't be retrieved : this dao will be ignored", currentDao.getClass().getName()));
        }
    }

    private Class<?> getDaoGenericType(CommonDAO<?> dao) {
        try {
            Method method = dao.getClass().getMethod("getById", Long.class);
            return GenericTypeResolver.resolveReturnType((Method)method, dao.getClass());
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to determine generic type for dao \"%s\"", dao.getClass().getName()), (Throwable)e);
            return null;
        }
    }
}

