/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.email;

import com.kportal.core.config.PropertyHelper;
import java.util.Date;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSBMailbox {
    public static final String PARAM_JTF_MAIL_HOST = "mail.host";
    public static final String PARAM_JTF_MAIL_PORT = "mail.port";
    public static final String PARAM_JTF_MAIL_USER = "mail.user";
    public static final String PARAM_JTF_MAIL_PASSWORD = "mail.password";
    public static final String PARAM_JTF_MAIL_FROM = "mail.from";
    public static final String PARAM_JTF_MAIL_WEBMASTER = "mail.webmaster";
    public static final String PARAM_JTF_MAIL_TLS = "mail.enabletls";
    private static final Logger LOG = LoggerFactory.getLogger(JSBMailbox.class);
    private String host;
    private int port;
    private String user;
    private String password;
    private boolean debug = true;

    public JSBMailbox(boolean _debug) {
        String debug = PropertyHelper.getCoreProperty("mail.debug");
        if (debug == null) {
            debug = "false";
        }
        this.debug = _debug || debug.equalsIgnoreCase("true");
        this.init();
    }

    private void init() {
        LOG.debug("Initialisation session SMTP ");
        if (!this.debug) {
            LOG.debug("MAIL_INITIALISE L'envoi d\u00e9bute");
            this.host = PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_HOST);
            String portJtf = PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_PORT);
            this.port = StringUtils.isNumeric((CharSequence)portJtf) ? Integer.parseInt(portJtf) : 25;
            this.user = PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_USER);
            this.password = "";
            if (PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_PASSWORD) != null) {
                this.password = PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_PASSWORD);
            }
        }
    }

    @Deprecated
    public void sendMsg(String from, String to, String subject, String message) throws MessagingException, EmailException {
        this.sendTxtMsg(from, to, subject, message);
    }

    @Deprecated
    public void sendMsg(String from, String to, String subject, String message, String typeMime) throws MessagingException, EmailException {
        this.sendHtmlMsg(from, to, subject, message);
    }

    public void sendTxtMsg(String from, String to, String subject, String message) throws MessagingException, EmailException {
        String[] tabTo = new String[]{to, to};
        this.sendMsgWithAttachedFiles(from, tabTo, subject, message, "text/plain", null, null);
    }

    public void sendHtmlMsg(String from, String to, String subject, String message) throws MessagingException, EmailException {
        String[] tabTo = new String[]{to, to};
        this.sendMsgWithAttachedFiles(from, tabTo, subject, message, "text/html", null, null);
    }

    public void sendSystemMsg(String to, String subject, String message) throws MessagingException, EmailException {
        this.sendTxtMsg(PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_FROM), to, subject, message);
    }

    public void sendWmasterMsg(String to, String subject, String message) throws MessagingException, EmailException {
        this.sendTxtMsg(PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_WEBMASTER), to, subject, message);
    }

    @Deprecated
    public void sendMsgWithAttachedFiles(String from, String to, String subject, String message, String filepaths) throws MessagingException, EmailException {
        this.sendTxtMsgWithAttachedFiles(from, to, subject, message, new String[]{filepaths});
    }

    public void sendTxtMsgWithAttachedFiles(String from, String to, String subject, String message, String[] filepaths) throws MessagingException, EmailException {
        this.sendMsgWithAttachedFiles(from, new String[]{to, to}, subject, message, "text/plain", filepaths, null);
    }

    public void sendHtmlMsgWithAttachedFiles(String from, String to, String subject, String message, String[] filepaths) throws MessagingException, EmailException {
        this.sendMsgWithAttachedFiles(from, new String[]{to, to}, subject, message, "text/html", filepaths, null);
    }

    public void sendSystemMsgWithAttachedFiles(String to, String subject, String message, String[] filepaths) throws MessagingException, EmailException {
        this.sendTxtMsgWithAttachedFiles(PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_FROM), to, subject, message, filepaths);
    }

    public void sendMsgWithAttachedFiles(String _from, String[] _to, String _subject, String _texte, String _typeMime, String[] _filepaths, String[] _filenames, boolean _newsletter) throws Exception {
        this.sendMsgWithAttachedFiles(_from, _to, _subject, _texte, _typeMime, _filepaths, _filenames);
    }

    public void sendMsgWithAttachedFiles(String[] _from, String[] _to, String _subject, String _texte, String _typeMime, String[] _filepaths, String[] _filenames, boolean _newsletter) throws MessagingException, EmailException {
        this.sendMsgWithAttachedFiles(_from[0], _to, _subject, _texte, _typeMime, _filepaths, _filenames);
    }

    public void sendMsgWithAttachedFiles(String from, String[] to, String subject, String message, String typeMime, String[] filepaths, String[] filenames) throws MessagingException, EmailException {
        this.sendMsgWithAttachedFiles(from, to, null, null, subject, message, typeMime, filepaths, filenames);
    }

    public void sendMsgWithAttachedFiles(String from, String[] to, List<String[]> cc, List<String[]> cci, String subject, String message, String typeMime, String[] filepaths, String[] filenames) throws MessagingException, EmailException {
        LOG.debug("Envoi mail : [" + to[0] + "]");
        if (this.debug) {
            LOG.debug("from : " + from);
            LOG.debug("subject : " + subject);
            LOG.debug("text :\n" + message);
        }
        if (!this.debug) {
            String mailDest = to[0];
            String nomDest = to[1];
            boolean sendHtml = "text/html".equals(typeMime) || "0".equals(typeMime);
            HtmlEmail email = null;
            if (filepaths != null && filepaths.length > 0) {
                email = new MultiPartEmail();
                if (sendHtml) {
                    MimeMultipart mmp = new MimeMultipart();
                    MimeBodyPart bp = new MimeBodyPart();
                    bp.setContent((Object)message, "text/html;charset=" + "UTF-8".toLowerCase());
                    mmp.addBodyPart((BodyPart)bp);
                    ((MultiPartEmail)email).addPart(mmp);
                } else {
                    email.setMsg(message);
                }
                for (int i = 0; i < filepaths.length; ++i) {
                    EmailAttachment attachment = new EmailAttachment();
                    attachment.setPath(filepaths[i]);
                    attachment.setDisposition("attachment");
                    if (filenames != null && filenames.length == filepaths.length) {
                        attachment.setName(filenames[i]);
                    }
                    ((MultiPartEmail)email).attach(attachment);
                }
            } else if (sendHtml) {
                email = new HtmlEmail();
                email.setContent((Object)message, "text/html;charset=" + "UTF-8".toLowerCase());
                email.setTextMsg("Votre client ne supporte pas les messages HMTL. Pour consultez la newsletter, rendez-vous sur la page ");
            } else {
                email = new SimpleEmail();
                email.setMsg(message.length() > 0 ? message : " ");
            }
            if (cc != null) {
                for (String[] mailCc : cc) {
                    if (mailCc.length > 1) {
                        email.addCc(mailCc[0], mailCc[1]);
                        continue;
                    }
                    if (mailCc.length != 1) continue;
                    email.addCc(mailCc[0]);
                }
            }
            if (cci != null) {
                for (String[] mailCci : cci) {
                    if (mailCci.length > 1) {
                        email.addBcc(mailCci[0], mailCci[1]);
                        continue;
                    }
                    if (mailCci.length != 1) continue;
                    email.addBcc(mailCci[0]);
                }
            }
            this.sendMessage((Email)email, mailDest, nomDest, from, subject);
        }
    }

    private void sendMessage(Email email, String to, String nomto, String from, String subject) throws EmailException {
        email.setHostName(this.host);
        email.setSmtpPort(this.port);
        if (!"".equals(this.user)) {
            email.setAuthentication(this.user, this.password);
        }
        if ("".equals(to)) {
            LOG.error("adresse destinataire non renseignee, envoi mail avorte.");
            return;
        }
        email.addTo(to, nomto);
        email.setFrom(from != null ? from : PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_FROM));
        email.setSubject(subject);
        email.setSentDate(new Date());
        email.setCharset("UTF-8");
        if ("true".equals(PropertyHelper.getCoreProperty(PARAM_JTF_MAIL_TLS))) {
            email.setStartTLSEnabled(true);
        }
        email.send();
    }
}

