/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.identification;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.SynchroniseurUtilisateur;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.identification.ISourceAuth;
import com.jsbsoft.jtf.identification.SourceAuthDefautKbd;
import com.jsbsoft.jtf.identification.ValidateurCAS;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.module.plugin.session.PluginSessionHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Preferences;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.portail.om.user.impl.UserPreferenceImpl;
import com.univ.utils.ContexteUniv;
import com.univ.utils.IAuthorizationExterne;
import com.univ.utils.ISynchroniseurUtilisateurMetier;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.xml.NodeUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GestionnaireIdentification {
    public static final String PARAM_JTF_SOURCE_AUTH_SOURCE = "authentification.source";
    public static final String PARAM_JTF_SOURCE_AUTH_MAPPING = "authentification.mapping_login";
    public static final String JTF_LDAP_LOGIN_CREATION_UTILSATEUR = "ldap.utilisateur.login.creation";
    public static final String JTF_LDAP_LOGIN_SYNCHRO_UTILSATEUR = "ldap.utilisateur.login.synchro";
    private static final Logger LOGGER = LoggerFactory.getLogger(GestionnaireIdentification.class);
    private static GestionnaireIdentification _instance;
    private final int TIMEOUT_CACHE_SESSION = 600000;
    private ValidateurCAS _validateurCAS;
    private boolean estCreationCompteAuto = false;
    private boolean estSynchroCompteAuto = false;
    private Map<String, ISourceAuth> mapCodeSourceSource;
    private final Map<String, Object> mapSynchroUtilisateurMetier;
    private Hashtable<String, String> mapCodeSourceLibelleSources;
    private ISourceAuth sourceAuth;
    private final ISourceAuth sourceAuthDefautKbd = new SourceAuthDefautKbd();
    private boolean bMappingLogin = false;
    private final Map<String, Map<String, Object>> cacheInfosUtilisateurProxyClient = new HashMap<String, Map<String, Object>>();
    private IAuthorizationExterne authorizationExterne;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GestionnaireIdentification getInstance() {
        if (_instance != null) return _instance;
        Class<GestionnaireIdentification> clazz = GestionnaireIdentification.class;
        synchronized (GestionnaireIdentification.class) {
            if (_instance != null) return _instance;
            _instance = new GestionnaireIdentification();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public String getCodeSourceAuth() {
        return this.sourceAuth.getCodeSource();
    }

    public boolean estSourceAuth(String libelleSourceAuth) {
        return this.sourceAuth.getCodeSource().equals(libelleSourceAuth);
    }

    public boolean getMappingLogin() {
        return this.bMappingLogin;
    }

    public ISourceAuth getSourceAuth() {
        return this.sourceAuth;
    }

    public String genererMDP() {
        String charMin = "abcdefghijklmnopqrstuvwxyz";
        String charMaj = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String charNb = "0123456789";
        String charTout = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        String mdp = "";
        for (int i = 0; i < 7; ++i) {
            mdp = mdp.concat("" + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)(Math.random() * 1000.0 % (double)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length())));
        }
        return mdp;
    }

    public Map<String, Object> getMapSynchroUtilisateurMetier() {
        return this.mapSynchroUtilisateurMetier;
    }

    public ValidateurCAS getValidateurCAS() {
        ISourceAuth o;
        if (this._validateurCAS == null && (o = this.mapCodeSourceSource.get("cas")) != null && o instanceof ValidateurCAS) {
            this._validateurCAS = (ValidateurCAS)o;
        }
        return this._validateurCAS;
    }

    public Utilisateur connecte(String codeUtilisateur, String mdp, OMContext ctx, Map<String, Object> mapInfosUser, String userAgent) throws Exception {
        Utilisateur user = null;
        if (StringUtils.isNotEmpty((CharSequence)codeUtilisateur) && StringUtils.isNotBlank((CharSequence)mdp) && this.sourceAuth.connecte(codeUtilisateur, mdp, ctx) && (user = this.estUtilisateurKportal(codeUtilisateur, mdp, ctx)) != null) {
            this.authorizationExterne = this.chargeAuthorization("authorization.externe.classe");
            if (this.authorizationExterne != null && !this.authorizationExterne.authorized(codeUtilisateur, ctx)) {
                return null;
            }
            this.chargeInfoUser(user, ctx, mapInfosUser, userAgent, true);
        }
        return user;
    }

    public Utilisateur connecteUserKbd(String codeUtilisateur, String mdp, OMContext ctx, Map<String, Object> mapInfosUser, String userAgent) throws Exception {
        Utilisateur user = null;
        if (StringUtils.isNotEmpty((CharSequence)codeUtilisateur) && StringUtils.isNotBlank((CharSequence)codeUtilisateur) && this.sourceAuthDefautKbd.connecte(codeUtilisateur, mdp, ctx) && (user = this.estUtilisateurKportal(codeUtilisateur, mdp, ctx)) != null) {
            this.chargeInfoUser(user, ctx, mapInfosUser, userAgent, true);
        }
        return user;
    }

    public String getCodeUtilisateurSessionCourante(HttpServletRequest request) {
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)request.getSession(Boolean.FALSE.booleanValue()).getAttribute("session");
        if (sessionUtilisateur == null) {
            return null;
        }
        return (String)sessionUtilisateur.getInfos().get("CODE");
    }

    public Map<String, Map> chargeInfosSessionUserMetier(OMContext ctx, Utilisateur utilisateur, Map<String, Object> mapInfosUser, boolean bIdentificationFront) throws Exception {
        if (this.mapSynchroUtilisateurMetier != null && this.mapSynchroUtilisateurMetier.size() > 0) {
            HashMap<String, Map> mapInfosSessionApplicatifsMetiers = new HashMap<String, Map>();
            for (String nomApplicatif : this.mapSynchroUtilisateurMetier.keySet()) {
                ISynchroniseurUtilisateurMetier chgt = (ISynchroniseurUtilisateurMetier)this.mapSynchroUtilisateurMetier.get(nomApplicatif);
                Map mapInfos = chgt.getInfosSessionUtilisateurMetier(utilisateur, mapInfosUser, ctx, bIdentificationFront);
                if (mapInfos == null) continue;
                mapInfosSessionApplicatifsMetiers.put(nomApplicatif, mapInfos);
            }
            return mapInfosSessionApplicatifsMetiers;
        }
        return null;
    }

    public boolean chargeInfoUser(String codeUtilisateur, OMContext ctx, HttpSession session, String userAgent) throws Exception {
        Utilisateur utilisateur = this.estUtilisateurKportal(codeUtilisateur, "", ctx);
        if (utilisateur != null) {
            SessionUtilisateur sessionUtilisateur = new SessionUtilisateur(session);
            this.chargeInfoUser(utilisateur, ctx, sessionUtilisateur.getInfos(), userAgent, true);
            session.setAttribute("session", (Object)sessionUtilisateur);
            return true;
        }
        return false;
    }

    protected void suppressionCacheUtilisateurProxyClient(Map<String, Object> cacheUser) {
        try {
            LOGGER.debug("purge cache ws/user " + cacheUser.get("CODE"));
            String ksession = (String)cacheUser.get("KSESSION");
            File fichierSortie = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + ksession + ".xml");
            if (fichierSortie.exists()) {
                fichierSortie.delete();
            }
            this.cacheInfosUtilisateurProxyClient.remove(cacheUser.get("CODE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized Map<String, Object> lireCacheUtilisateurProxyClient(String codeUser) {
        Map<String, Object> cacheUser = this.cacheInfosUtilisateurProxyClient.get(codeUser);
        if (cacheUser != null) {
            long ts;
            long maintenant = System.currentTimeMillis();
            if (maintenant - (ts = ((Long)cacheUser.get("TIMESTAMP")).longValue()) > 600000L) {
                this.suppressionCacheUtilisateurProxyClient(cacheUser);
                cacheUser = null;
            } else {
                cacheUser.put("TIMESTAMP", System.currentTimeMillis());
            }
        }
        return cacheUser;
    }

    public synchronized Map<String, Object> ajouterCacheUtilisateurProxyClient(ContexteUniv ctx, String codeUser, Map<String, Object> hashInfosUser) throws Exception {
        LOGGER.debug("ajout cache ws/user " + codeUser);
        this.cacheInfosUtilisateurProxyClient.put(codeUser, hashInfosUser);
        long maintenant = System.currentTimeMillis();
        for (Map<String, Object> chacheTmp : new ArrayList<Map<String, Object>>(this.cacheInfosUtilisateurProxyClient.values())) {
            long ts = (Long)chacheTmp.get("TIMESTAMP");
            if (maintenant - ts <= 600000L) continue;
            this.suppressionCacheUtilisateurProxyClient(chacheTmp);
        }
        return hashInfosUser;
    }

    public ContexteUniv initialiserContexteProxyClient(HttpServletRequest req) throws Exception {
        ContexteUniv ctx = new ContexteUniv(req.getRequestURI());
        this.chargerContexteProxyClient(ctx, req.getParameter("USER"));
        return ctx;
    }

    public void chargerContexteProxyClient(ContexteUniv ctx, String codeUser) throws Exception {
        if (codeUser != null && codeUser.length() > 0) {
            Map<String, Object> cacheUser = this.lireCacheUtilisateurProxyClient(codeUser);
            if (cacheUser == null && (cacheUser = this.creerCacheUtilisateurProxyClient(ctx, codeUser)) != null) {
                this.ajouterCacheUtilisateurProxyClient(ctx, codeUser, cacheUser);
            }
            if (cacheUser != null) {
                ctx.setCode((String)cacheUser.get("CODE"));
                ctx.setCodeStructure((String)cacheUser.get("CODE_STRUCTURE"));
                ctx.setCodeGestion((String)cacheUser.get("CODE_GESTION"));
                ctx.setNom((String)cacheUser.get("NOM"));
                ctx.setPrenom((String)cacheUser.get("PRENOM"));
                ctx.setCentresInteret((Vector)cacheUser.get("CENTRES_INTERET"));
                ctx.setAdresseMail((String)cacheUser.get("ADRESSE_MAIL"));
                TreeSet<String> groupes = new TreeSet<String>((Vector)cacheUser.get("GROUPES_DSI"));
                ctx.setGroupesDsi(groupes);
                TreeSet<String> profils = new TreeSet<String>((Vector)cacheUser.get("PROFILS_DSI"));
                ctx.setListeProfilsDsi(profils);
                ctx.calculerGroupesDsiAvecAscendants();
                ctx.initialiserListeServices();
                ctx.setAutorisation((AutorisationBean)cacheUser.get("AUTORISATIONS"));
                ctx.setKsession((String)cacheUser.get("KSESSION"));
            }
        }
    }

    public Map<String, Object> creerCacheUtilisateurProxyClient(ContexteUniv ctx, String codeUser) throws Exception {
        HashMap<String, Object> hashInfosUser = null;
        Utilisateur utilisateur = Utilisateur.getUtilisateur(codeUser);
        if (utilisateur != null) {
            hashInfosUser = new HashMap<String, Object>();
            hashInfosUser.put("TIMESTAMP", System.currentTimeMillis());
            Vector<String> groupesUtilisateurs = Groupeutilisateur.getVecteurGroupes(utilisateur.getCode());
            AutorisationBean autorisation = new AutorisationBean(utilisateur, groupesUtilisateurs, ctx);
            hashInfosUser.put("CODE", utilisateur.getCode());
            hashInfosUser.put("NOM", utilisateur.getNom());
            hashInfosUser.put("PRENOM", utilisateur.getPrenom());
            hashInfosUser.put("AUTORISATIONS", autorisation);
            hashInfosUser.put("CODE", utilisateur.getCode());
            hashInfosUser.put("CODE_STRUCTURE", utilisateur.getCodeRattachement());
            hashInfosUser.put("CODE_GESTION", utilisateur.getCodeLdap());
            hashInfosUser.put("ADRESSE_MAIL", utilisateur.getAdresseMail());
            hashInfosUser.put("GROUPES_DSI", groupesUtilisateurs);
            Vector<String> vListeProfils = Profildsi.renvoyerProfilsGroupes(groupesUtilisateurs);
            hashInfosUser.put("PROFILS_DSI", vListeProfils);
            hashInfosUser.put("CENTRES_INTERET", utilisateur.getVecteurCentresInteret());
            String ksession = GestionnaireIdentification.getInstance().creationFichierSession(utilisateur, groupesUtilisateurs, new Vector<String>(), "");
            hashInfosUser.put("KSESSION", ksession);
        }
        return hashInfosUser;
    }

    public void chargeInfoUser(Utilisateur utilisateur, OMContext ctx, Map<String, Object> mapInfoUser, String userAgent, boolean bIdentificationFront) throws Exception {
        mapInfoUser.put("DATE_DERNIERE_SESSION", utilisateur.getDateDerniereSession());
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        if (!sdf.format(utilisateur.getDateDerniereSession()).equals(sdf.format(new Date(System.currentTimeMillis())))) {
            utilisateur.setDateDerniereSession(new Date(System.currentTimeMillis()));
            utilisateur.update();
        }
        Vector<String> groupesUtilisateurs = Groupeutilisateur.getVecteurGroupes(utilisateur.getCode());
        Enumeration<String> e = groupesUtilisateurs.elements();
        if (LOGGER.isDebugEnabled()) {
            while (e.hasMoreElements()) {
                LOGGER.debug("Groupe : " + e.nextElement());
            }
        }
        AutorisationBean autorisation = new AutorisationBean(utilisateur, groupesUtilisateurs, ctx);
        mapInfoUser.put("AUTORISATIONS", autorisation);
        mapInfoUser.put("CODE", utilisateur.getCode());
        mapInfoUser.put("NOM", utilisateur.getNom());
        mapInfoUser.put("PRENOM", utilisateur.getPrenom());
        mapInfoUser.put("ADRESSE_MAIL", utilisateur.getAdresseMail());
        mapInfoUser.put("CODE_STRUCTURE", utilisateur.getCodeRattachement());
        mapInfoUser.put("CODE_GESTION", utilisateur.getCodeLdap());
        String profilDefaut = utilisateur.getProfilDefaut();
        Vector<String> vListeProfils = Profildsi.renvoyerProfilsGroupes(groupesUtilisateurs);
        if (!(profilDefaut.length() != 0 && vListeProfils.contains(profilDefaut) || vListeProfils.size() <= 0)) {
            profilDefaut = vListeProfils.get(0);
        }
        InfosProfilDsi info = Profildsi.renvoyerItemProfilDsi(profilDefaut);
        String codeRubrique = info.getCodeRubriqueAccueil();
        InfosRubriques infos = Rubrique.renvoyerItemRubrique(codeRubrique);
        mapInfoUser.put("RUBRIQUE_ACCUEIL", infos);
        mapInfoUser.put("PROFIL_DSI", profilDefaut);
        mapInfoUser.put("PROFILS_DSI", vListeProfils);
        mapInfoUser.put("GROUPES_DSI", groupesUtilisateurs);
        mapInfoUser.put("CENTRES_INTERET", utilisateur.getVecteurCentresInteret());
        Preferences pref = new Preferences();
        pref.setCtx(ctx);
        pref.selectPreferencesUser(utilisateur.getCode());
        HashMap<String, List<InfosPreferences>> tablePrefUser = new HashMap<String, List<InfosPreferences>>();
        while (pref.nextItem()) {
            if (!tablePrefUser.containsKey(pref.getService())) {
                tablePrefUser.put(pref.getService(), new ArrayList());
            }
            InfosPreferences infosPreferences = new InfosPreferences(pref);
            ((List)tablePrefUser.get(pref.getService())).add(infosPreferences);
        }
        UserPreferenceImpl userPref = new UserPreferenceImpl(tablePrefUser, utilisateur.getCode());
        mapInfoUser.put("USER_PREFS", userPref);
        Map<String, Map> infosSessionUserMetier = this.chargeInfosSessionUserMetier(ctx, utilisateur, mapInfoUser, bIdentificationFront);
        if (infosSessionUserMetier != null) {
            mapInfoUser.put("INFO_SESSION_APPLICATIFS_METIER", infosSessionUserMetier);
        }
        HttpSession session = null;
        if (ctx instanceof ProcessusBean) {
            session = ((ProcessusBean)ctx).getGp().getSessionUtilisateur().getHttpSession();
        } else if (ctx instanceof ContexteUniv) {
            session = ((ContexteUniv)ctx).getRequeteHTTP().getSession(Boolean.FALSE.booleanValue());
        }
        String kSession = this.creationFichierSession(utilisateur, groupesUtilisateurs, vListeProfils, (String)session.getAttribute("KSESSION"));
        if (kSession == null) {
            LOGGER.error("Fichier de session impossible \u00e0 cr\u00e9er pour l'utilisateur: " + utilisateur.getCode() + ".");
        } else {
            mapInfoUser.put("KSESSION", kSession);
        }
        String msgSession = "Session charg\u00e9e pour l'utilisateur " + utilisateur.getCode();
        if (this.bMappingLogin) {
            msgSession = msgSession + " / " + utilisateur.getCodeLdap();
        }
        msgSession = msgSession + " site " + ctx.getInfosSite().getAlias();
        LOGGER.info(msgSession);
        PluginSessionHelper.setDonneesSession(session);
    }

    public Utilisateur estUtilisateurKportal(String codeUtilisateur, String password, OMContext ctx) throws Exception {
        Utilisateur utilisateur = new Utilisateur();
        utilisateur.init();
        utilisateur.setCtx(ctx);
        int nb_users = 0;
        if (StringUtils.isEmpty((CharSequence)codeUtilisateur)) {
            return null;
        }
        nb_users = this.bMappingLogin ? utilisateur.select(GestionnaireIdentification.whereCodeLDAPEgal(codeUtilisateur).formaterSQL()) : utilisateur.select(GestionnaireIdentification.whereCodeEgal(codeUtilisateur).formaterSQL());
        if (nb_users == 1) {
            utilisateur.nextItem();
        } else if (nb_users > 1) {
            String msg = !this.bMappingLogin ? "le code" : "le code ldap";
            LOGGER.error(msg + " de l'utilisateur : " + codeUtilisateur + ", n'est pas unique (" + nb_users + " r\u00e9sultats) dans le r\u00e9f\u00e9rentiel.");
            throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(), "AUTHENTIFICATION.ERREUR.CONNEXION_REFUSEE"));
        }
        if (!(this.sourceAuth instanceof SourceAuthDefautKbd)) {
            if (this.estCreationCompteAuto && nb_users == 0 || this.estSynchroCompteAuto && nb_users == 1) {
                this.authorizationExterne = this.chargeAuthorization("authorization.externe.classe");
                if (this.authorizationExterne != null && this.authorizationExterne.synchronise(codeUtilisateur) && (nb_users = this.bMappingLogin ? utilisateur.select(GestionnaireIdentification.whereCodeLDAPEgal(codeUtilisateur).formaterSQL()) : utilisateur.select(GestionnaireIdentification.whereCodeEgal(codeUtilisateur).formaterSQL())) == 1) {
                    utilisateur.nextItem();
                    return utilisateur;
                }
            }
            if (this.bMappingLogin && nb_users == 0) {
                if (this.sourceAuthDefautKbd.connecte(codeUtilisateur, password, ctx)) {
                    nb_users = utilisateur.select(GestionnaireIdentification.whereCodeEgal(codeUtilisateur).formaterSQL());
                }
                if (nb_users == 1) {
                    utilisateur.nextItem();
                }
            }
            if (nb_users == 0) {
                utilisateur = null;
            }
        } else if (nb_users == 0) {
            utilisateur = null;
        }
        return utilisateur;
    }

    public void deconnecte(String idSession, Map<String, Object> mapInfoUser, OMContext ctx) {
        if (idSession != null) {
            String code = this.bMappingLogin ? (String)mapInfoUser.get("CODE_GESTION") : (String)mapInfoUser.get("CODE");
            this.sourceAuth.deconnecte(code, ctx);
            this.suppressionFichierSession(idSession);
            this.supprimeInfosSession(mapInfoUser);
        }
    }

    protected void supprimeInfosSession(Map<String, Object> mapInfoUser) {
        mapInfoUser.remove("CODE");
        mapInfoUser.remove("CODE_GESTION");
        mapInfoUser.remove("NOM");
        mapInfoUser.remove("PRENOM");
        mapInfoUser.remove("AUTORISATIONS");
        mapInfoUser.remove("CODE_PAGE_ACCUEIL");
        mapInfoUser.remove("LANGUE_PAGE_ACCUEIL");
        mapInfoUser.remove("PROFIL_DSI");
        mapInfoUser.remove("PROFILS_DSI");
        mapInfoUser.remove("GROUPES_DSI");
        mapInfoUser.remove("KSESSION");
        mapInfoUser.remove("ESPACE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String creationFichierSession(Utilisateur utilisateur, Vector<String> groupesUtilisateur, Vector<String> profilsUtilisateur, String kSession) throws IOException {
        File fichierSession;
        if (StringUtils.isNotEmpty((CharSequence)kSession) && (fichierSession = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + kSession + ".xml")).exists()) {
            return kSession;
        }
        try (OutputStreamWriter fileWriter = null;){
            String idSession = UUID.randomUUID().toString();
            String codeUtilisateurSession = utilisateur.getCode();
            String civiliteUtilisateurSession = utilisateur.getCivilite();
            String nomUtilisateurSession = utilisateur.getNom();
            String prenomUtilisateurSession = utilisateur.getPrenom();
            String emailUtilisateurSession = utilisateur.getAdresseMail();
            String structureUtilisateurSession = utilisateur.getCodeRattachement();
            String codeLdapUtilisateurSession = utilisateur.getCodeLdap();
            String groupesUtilisateurSession = "";
            for (String string : groupesUtilisateur) {
                if (groupesUtilisateurSession.length() > 0) {
                    groupesUtilisateurSession = groupesUtilisateurSession + ";";
                }
                groupesUtilisateurSession = groupesUtilisateurSession + string;
            }
            String profilsUtilisateurSession = "";
            for (String codeProfilUtilisateur : profilsUtilisateur) {
                if (profilsUtilisateurSession.length() > 0) {
                    profilsUtilisateurSession = profilsUtilisateurSession + ";";
                }
                profilsUtilisateurSession = profilsUtilisateurSession + codeProfilUtilisateur;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element nodeFiche = document.createElement("SESSION");
            NodeUtil.addNode((Node)nodeFiche, "ID", idSession);
            NodeUtil.addNode((Node)nodeFiche, "CODE", codeUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "CODE_LDAP", codeLdapUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "CIVILITE", civiliteUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "NOM", nomUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "PRENOM", prenomUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "EMAIL", emailUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "STRUCTURE", structureUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "PROFIL", profilsUtilisateurSession);
            NodeUtil.addNode((Node)nodeFiche, "GROUPES", groupesUtilisateurSession);
            document.appendChild(nodeFiche);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            File fichierSortie = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + idSession + ".xml");
            fichierSortie.createNewFile();
            fileWriter = new FileWriter(fichierSortie);
            StreamResult result = new StreamResult(fileWriter);
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.transform(source, result);
            String string = idSession;
            return string;
        }
    }

    protected boolean suppressionFichierSession(String idSession) {
        boolean res = true;
        if (idSession != null) {
            InfoBean.supprimerDatas(idSession);
            File fichierSortie = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + idSession + ".xml");
            if (fichierSortie.exists()) {
                res = fichierSortie.delete();
            }
        }
        return res;
    }

    public Hashtable<String, String> getLibellesSourcesDisponibles() {
        if (this.mapCodeSourceSource == null) {
            this.mapCodeSourceSource = new HashMap<String, ISourceAuth>();
            this.mapCodeSourceSource.put(this.sourceAuth.getCodeSource(), this.sourceAuth);
            this.mapCodeSourceLibelleSources = new Hashtable();
            this.mapCodeSourceLibelleSources.put(this.sourceAuth.getCodeSource(), this.sourceAuth.getLibelleSource());
            Enumeration<Object> enumProperties = PropertyHelper.getAllProperties().elements();
            while (enumProperties.hasMoreElements()) {
                ISourceAuth sourceAuthChargee;
                String clef = (String)enumProperties.nextElement();
                if (!clef.startsWith("authentification") || !clef.endsWith(".classe") || (sourceAuthChargee = this.chargeSourceAuth(clef)) == null) continue;
                this.mapCodeSourceLibelleSources.put(sourceAuthChargee.getCodeSource(), sourceAuthChargee.getLibelleSource());
                this.mapCodeSourceSource.put(sourceAuthChargee.getCodeSource(), sourceAuthChargee);
            }
        }
        return this.mapCodeSourceLibelleSources;
    }

    private ISourceAuth chargeSourceAuth(String prop) {
        ISourceAuth sourceAuthChargee = null;
        try {
            if (prop != null) {
                Object o;
                String nomClasse = PropertyHelper.getAllProperties().getProperty(prop);
                if (this.sourceAuth != null && prop.equals("authentification." + this.sourceAuth.getCodeSource() + ".classe")) {
                    return null;
                }
                if (nomClasse != null && (o = Class.forName(nomClasse).newInstance()) instanceof ISourceAuth) {
                    sourceAuthChargee = (ISourceAuth)o;
                    LOGGER.debug("Source d'authentification " + sourceAuthChargee.getCodeSource() + " charg\u00e9e : \n" + sourceAuthChargee.parametrageCharge());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Echec chargement source auth. : " + prop, (Throwable)e);
        }
        return sourceAuthChargee;
    }

    protected GestionnaireIdentification() {
        this.sourceAuth = this.chargeSourceAuth("authentification." + PropertyHelper.getCoreProperty(PARAM_JTF_SOURCE_AUTH_SOURCE) + ".classe");
        if (this.sourceAuth == null) {
            this.sourceAuth = new SourceAuthDefautKbd();
            LOGGER.debug("Source d'authentification par d\u00e9faut charg\u00e9e : ");
        }
        this.getLibellesSourcesDisponibles();
        this.bMappingLogin = "1".equals(PropertyHelper.getCoreProperty(PARAM_JTF_SOURCE_AUTH_MAPPING));
        this.mapSynchroUtilisateurMetier = SynchroniseurUtilisateur.getInstance().getMapSynchroUtilisateurMetier();
        this.estCreationCompteAuto = "1".equals(PropertyHelper.getAllProperties().getProperty(JTF_LDAP_LOGIN_CREATION_UTILSATEUR));
        this.estSynchroCompteAuto = "1".equals(PropertyHelper.getAllProperties().getProperty(JTF_LDAP_LOGIN_SYNCHRO_UTILSATEUR));
    }

    private IAuthorizationExterne chargeAuthorization(String prop) {
        IAuthorizationExterne sourceAuthorizationChargee = null;
        try {
            Object o;
            String nomClasse;
            if (prop != null && (nomClasse = PropertyHelper.getAllProperties().getProperty(prop)) != null && (o = Class.forName(nomClasse).newInstance()) instanceof IAuthorizationExterne) {
                sourceAuthorizationChargee = (IAuthorizationExterne)o;
                LOGGER.debug("Source de redirection charg\u00e9e ");
            }
        }
        catch (Exception e) {
            LOGGER.error("Echec chargement autorisations", (Throwable)e);
        }
        return sourceAuthorizationChargee;
    }

    public static boolean isAuthorizedAddr(String remoteAddr) {
        boolean res = false;
        String param = PropertyHelper.getCoreProperty("identification.ips");
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param, ";");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(remoteAddr)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    private static ClauseWhere whereCodeEgal(String code) {
        return new ClauseWhere(ConditionHelper.egalVarchar("CODE", code));
    }

    private static ClauseWhere whereCodeLDAPEgal(String codeLdap) {
        return new ClauseWhere(ConditionHelper.egalVarchar("CODE_LDAP", codeLdap));
    }
}

