/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.identification;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.identification.ISourceAuth;
import com.kportal.core.config.PropertyHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceAuthClearTrust
implements ISourceAuth {
    public static final String SOURCE_LIBELLE_CT = "ClearTrust";
    public static final String SOURCE_LIBELLE_AFFICHABLE = "RSA ClearTrust";
    public static final String URL_LOGIN_FRONT = "/adminsite/dsi/login.jsp";
    public static final String PARAM_LOGIN_HTTP_HEADER = "ct-remote-user";
    public static final String PARAM_JTF_CTRUST_URL_DECONNEXION = "ctrust.url_deconnexion";
    private static final Logger LOG = LoggerFactory.getLogger(SourceAuthClearTrust.class);
    private String urlDeconnexionCT;

    SourceAuthClearTrust() {
        this.initialiseParametrageCtrust();
    }

    public String getUrlCtrustLogin(OMContext ctx) {
        return URL_LOGIN_FRONT;
    }

    public String getUrlCtrustLogout(OMContext ctx, String urlCallback) {
        String urlDeconnexion = "";
        if (!this.urlDeconnexionCT.equals("")) {
            try {
                String prefix = "";
                if (!(this.urlDeconnexionCT.endsWith("?") || this.urlDeconnexionCT.endsWith("&") || this.urlDeconnexionCT.endsWith("="))) {
                    if (!this.urlDeconnexionCT.endsWith("=") && this.urlDeconnexionCT.contains("?")) {
                        prefix = "&";
                    } else if (!this.urlDeconnexionCT.endsWith("=")) {
                        prefix = "?";
                    }
                }
                urlDeconnexion = this.urlDeconnexionCT + prefix + URLEncoder.encode(urlCallback, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("erreur sur l'encodage de caractere", (Throwable)e);
            }
        } else {
            return urlCallback;
        }
        return urlDeconnexion;
    }

    @Override
    public boolean connecte(String codeUtilisateur, String mdp, OMContext ctx) throws Exception {
        return false;
    }

    @Override
    public void deconnecte(String codeUtilisateur, OMContext ctx) {
    }

    @Override
    public String getCodeSource() {
        return SOURCE_LIBELLE_CT;
    }

    @Override
    public String getLibelleSource() {
        return SOURCE_LIBELLE_AFFICHABLE;
    }

    @Override
    public String parametrageCharge() {
        return " | URL deconnexion : " + this.urlDeconnexionCT;
    }

    private void initialiseParametrageCtrust() {
        this.urlDeconnexionCT = PropertyHelper.getCoreProperty(PARAM_JTF_CTRUST_URL_DECONNEXION);
        if (this.urlDeconnexionCT == null) {
            this.urlDeconnexionCT = "";
        }
    }
}

