/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.identification;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.ISourceAuth;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.URLResolver;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.ServiceTicketValidator;
import edu.yale.its.tp.cas.proxy.ProxyTicketReceptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateurCAS
implements ISourceAuth {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateurCAS.class);
    private static final String HTTPS = "https://";
    public static final String SOURCE_LIBELLE_CAS = "cas";
    public static final String SOURCE_LIBELLE_AFFICHABLE = "Central Authentication Server (CAS)";
    public static final String PARAM_JTF_CAS = "cas.mode";
    public static final String LIBELLE_JTF_CAS_MODE_BASIC = "basic";
    public static final String LIBELLE_JTF_CAS_MODE_PROXY = "proxy";
    public static final String PARAM_JTF_CAS_HOTE = "cas.hote";
    public static final String PARAM_JTF_CAS_URI_LOGIN = "cas.uriLogin";
    public static final String PARAM_JTF_CAS_URI_LOGOUT = "cas.uriLogout";
    public static final String PARAM_JTF_CAS_URI_SERVICE = "cas.uriCasServiceValidate";
    public static final String PARAM_JTF_CAS_URI_PROXY_VALIDATE = "cas.uriCasProxyValidate";
    public static final String PARAM_JTF_CAS_URI_PROXY_RECEPTOR = "cas.uriCasProxyServlet";
    private static final String PARAM_JTF_CAS_REDIRECTION_FRONT = "cas.redirection_front";
    private String hoteCas;
    private String modeCas;
    private String urlCasServiceValidate;
    private String urlProxyValidate;
    private String urlServiceCasLogin;
    private int portCas;
    private Map<String, String> mapLoginPGT;

    ValidateurCAS() throws Exception {
        this.initialiseParametrageCas();
    }

    public String getHoteCas() {
        return this.hoteCas;
    }

    public int getPortServeurCas() {
        return this.portCas;
    }

    public String getModeCas() {
        return this.modeCas;
    }

    public String getUrlCasServiceLogin(String urlService) throws UnsupportedEncodingException {
        return this.urlServiceCasLogin + URLEncoder.encode(urlService, "UTF-8");
    }

    public String getUrlCasLogin(OMContext ctx) {
        this.initialiserInfosSiteDansContexte(ctx);
        return this.getURLCasLogin(ctx.getInfosSite(), false);
    }

    public String getUrlCasLoginFront(OMContext ctx) {
        this.initialiserInfosSiteDansContexte(ctx);
        return this.getURLCasLogin(ctx.getInfosSite(), true);
    }

    public String getUrlCasLogout(OMContext ctx) {
        this.initialiserInfosSiteDansContexte(ctx);
        return this.getURLCasLogout(ctx.getInfosSite(), "1".equals(PropertyHelper.getCoreProperty(PARAM_JTF_CAS_REDIRECTION_FRONT)));
    }

    public String getUrlCasLogoutFront(OMContext ctx) {
        this.initialiserInfosSiteDansContexte(ctx);
        return this.getURLCasLogout(ctx.getInfosSite(), true);
    }

    @Override
    public boolean connecte(String codeUtilisateur, String mdp, OMContext ctx) throws Exception {
        return false;
    }

    @Override
    public void deconnecte(String codeUtilisateur, OMContext ctx) {
        if (codeUtilisateur != null && this.modeCas == LIBELLE_JTF_CAS_MODE_PROXY && this.mapLoginPGT.get(codeUtilisateur) != null) {
            this.mapLoginPGT.remove(codeUtilisateur);
        }
    }

    @Override
    public String getCodeSource() {
        return SOURCE_LIBELLE_CAS;
    }

    @Override
    public String getLibelleSource() {
        return SOURCE_LIBELLE_AFFICHABLE;
    }

    private void initialiseParametrageCas() throws Exception {
        this.initialisationModeCAS();
        this.initialisationMapLoginPGT();
        this.initialisationHoteEtPortCas();
        this.initialisationURLsCas();
    }

    private void initialisationURLsCas() {
        String hoteCasPort = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_HOTE);
        String uriCasService = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_SERVICE);
        this.urlCasServiceValidate = HTTPS + hoteCasPort + uriCasService;
        String uriCasProxyValidate = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_PROXY_VALIDATE);
        this.urlProxyValidate = HTTPS + hoteCasPort + uriCasProxyValidate;
        String uriCasLogin = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_LOGIN);
        this.urlServiceCasLogin = HTTPS + hoteCasPort + uriCasLogin;
    }

    private void initialisationModeCAS() {
        String modeCasJTF = PropertyHelper.getCoreProperty(PARAM_JTF_CAS);
        if (StringUtils.isEmpty((CharSequence)modeCasJTF)) {
            this.modeCas = LIBELLE_JTF_CAS_MODE_BASIC;
        } else if (modeCasJTF.equals(LIBELLE_JTF_CAS_MODE_PROXY)) {
            this.modeCas = LIBELLE_JTF_CAS_MODE_PROXY;
        } else if (modeCasJTF.equals(LIBELLE_JTF_CAS_MODE_BASIC)) {
            this.modeCas = LIBELLE_JTF_CAS_MODE_BASIC;
        }
    }

    private void initialisationMapLoginPGT() {
        if (this.modeCas.equalsIgnoreCase(LIBELLE_JTF_CAS_MODE_PROXY)) {
            this.mapLoginPGT = new Hashtable<String, String>();
        }
    }

    private void initialisationHoteEtPortCas() {
        String hoteCasPort = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_HOTE);
        int indexDeuxpoints = hoteCasPort.indexOf(58);
        if (indexDeuxpoints != -1) {
            this.hoteCas = hoteCasPort.substring(0, indexDeuxpoints);
            this.portCas = hoteCasPort.indexOf("/", indexDeuxpoints) != -1 ? Integer.parseInt(hoteCasPort.substring(indexDeuxpoints + 1, hoteCasPort.indexOf("/", indexDeuxpoints))) : Integer.parseInt(hoteCasPort.substring(indexDeuxpoints + 1));
        } else {
            this.hoteCas = hoteCasPort;
            this.portCas = 443;
        }
    }

    @Override
    public String parametrageCharge() {
        return "| Mode CAS : " + this.modeCas + "\n";
    }

    public Utilisateur validation(OMContext ctx, InfoBean infoBean) throws Exception {
        boolean bIdenticationBack = true;
        if (infoBean.getNomProcessus().equals("IDENTIFICATION_FRONT")) {
            bIdenticationBack = false;
        }
        if (this.modeCas == LIBELLE_JTF_CAS_MODE_PROXY) {
            return this.validationModeProxy(ctx, infoBean.getString("ticket"), bIdenticationBack, null);
        }
        return this.validationModeBasic(ctx, infoBean.getString("ticket"), bIdenticationBack);
    }

    protected Utilisateur validationModeBasic(OMContext ctx, String ticket, boolean bIdenticationBack) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ticket)) {
            return null;
        }
        ServiceTicketValidator sv = new ServiceTicketValidator();
        if (ticket.indexOf("ST") != -1) {
            sv.setCasValidateUrl(this.urlCasServiceValidate);
        } else {
            sv.setCasValidateUrl(this.urlProxyValidate);
        }
        this.initialiserInfosSiteDansContexte(ctx);
        sv.setService(this.getURLCasAuthentification(ctx.getInfosSite(), !bIdenticationBack));
        sv.setServiceTicket(ticket);
        sv.validate();
        Utilisateur utilisateur = this.chargeUtilisateur(ctx, sv, bIdenticationBack);
        return utilisateur;
    }

    public Utilisateur validationServiceModeProxy(OMContext ctx, String ticket, String urlService) throws Exception {
        return this.validationModeProxy(ctx, ticket, false, urlService);
    }

    protected Utilisateur validationModeProxy(OMContext ctx, String ticket, boolean bIdenticationBack, String urlService) throws Exception {
        if (ticket == null || ticket.equals("")) {
            return null;
        }
        ProxyTicketValidator pv = new ProxyTicketValidator();
        if (ticket.indexOf("ST") != -1) {
            pv.setCasValidateUrl(this.urlCasServiceValidate);
        } else {
            pv.setCasValidateUrl(this.urlProxyValidate);
        }
        pv.setProxyCallbackUrl(this.getURLCasProxyCallback(Site.getSitePrincipal()));
        if (urlService != null) {
            pv.setService(urlService);
        } else {
            pv.setService(this.getURLCasAuthentification(Site.getSitePrincipal(), !bIdenticationBack));
        }
        pv.setServiceTicket(ticket);
        pv.validate();
        Utilisateur utilisateur = this.chargeUtilisateur(ctx, (ServiceTicketValidator)pv, bIdenticationBack);
        if (utilisateur != null) {
            String pgt = pv.getPgtIou();
            if (pgt != null) {
                String code = GestionnaireIdentification.getInstance().getMappingLogin() ? utilisateur.getCodeLdap() : utilisateur.getCode();
                if (this.mapLoginPGT.get(code) != null) {
                    this.mapLoginPGT.remove(code);
                }
                this.mapLoginPGT.put(code, pgt);
                LOG.debug("*** PGT acquis pour l'utilisateur " + code + ".");
            } else {
                LOG.debug("*** Impossible d'acqu\u00e9rir un PGT pour l'utilisateur.");
            }
        }
        return utilisateur;
    }

    public String getProxyTicket(String codeUtilisateur, String codeLdap, String urlTarget) throws IOException {
        if (this.modeCas == LIBELLE_JTF_CAS_MODE_PROXY) {
            String pgt = GestionnaireIdentification.getInstance().getMappingLogin() ? this.mapLoginPGT.get(codeLdap) : this.mapLoginPGT.get(codeUtilisateur);
            return ProxyTicketReceptor.getProxyTicket((String)pgt, (String)urlTarget);
        }
        return null;
    }

    private Utilisateur chargeUtilisateur(OMContext ctx, ServiceTicketValidator stv, boolean bIdenticationBack) throws Exception {
        String codeUtilisateur = null;
        Utilisateur utilisateur = null;
        if (stv.isAuthenticationSuccesful()) {
            codeUtilisateur = stv.getUser();
            utilisateur = GestionnaireIdentification.getInstance().estUtilisateurKportal(codeUtilisateur, "", ctx);
            if (utilisateur == null) {
                String messageException = MessageHelper.getCoreMessage(ctx.getLocale(), "ST_CAS_ERREUR_MSG1") + " " + codeUtilisateur + " " + MessageHelper.getCoreMessage(ctx.getLocale(), "ST_CAS_ERREUR_MSG2") + "<br />" + MessageHelper.getCoreMessage(ctx.getLocale(), "ST_CAS_ERREUR_MSG3");
                this.initialiserInfosSiteDansContexte(ctx);
                String urlCasLogout = this.getURLCasLogout(ctx.getInfosSite(), !bIdenticationBack);
                if (!bIdenticationBack) {
                    messageException = messageException + "<br /><a href=\"" + urlCasLogout + "\">Veuillez vous d\u00e9connecter de CAS.</a>";
                }
                throw new ErreurApplicative(messageException);
            }
        } else {
            String szCodeErreur = stv.getErrorCode();
            String szMessageErreur = stv.getErrorMessage();
            throw new ErreurApplicative(String.format(MessageHelper.getCoreMessage(ctx.getLocale(), "AUTHENTIFICATION.ERREUR.AUTH_CAS"), szCodeErreur, szMessageErreur));
        }
        return utilisateur;
    }

    private void initialiserInfosSiteDansContexte(OMContext ctx) {
        if (ctx.getInfosSite() == null) {
            ctx.setInfosSite(Site.getSitePrincipal());
        }
    }

    private String getURLCasAuthentification(InfosSite infosSite, boolean front) {
        if (front) {
            return URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT", infosSite, 1);
        }
        return URLResolver.getAbsoluteBoUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION", infosSite);
    }

    private String getURLCasLogin(InfosSite infosSite, boolean front) {
        String uriCasLogin = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_LOGIN);
        String hoteCasPort = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_HOTE);
        String urlCasAuth = this.getURLCasAuthentification(infosSite, front);
        try {
            return HTTPS + hoteCasPort + uriCasLogin + URLEncoder.encode(urlCasAuth, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Erreur durant l'encodage de l'URL CAS de login" + (front ? " front" : ""), (Throwable)e);
            return "";
        }
    }

    private String getURLCasLogout(InfosSite infosSite, boolean front) {
        String uriCasLogoutCallback = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_LOGOUT);
        if (StringUtils.isEmpty((CharSequence)uriCasLogoutCallback)) {
            return "";
        }
        String hoteCasPort = PropertyHelper.getCoreProperty(PARAM_JTF_CAS_HOTE);
        try {
            String url = URLEncoder.encode(URLResolver.getAbsoluteBoUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=DECONNECTER", infosSite), "UTF-8");
            if (front) {
                url = URLEncoder.encode(URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=DECONNECTER", infosSite, 5), "UTF-8");
            }
            return HTTPS + hoteCasPort + uriCasLogoutCallback + url;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Erreur durant l'encodage de l'URL CAS de logout" + (front ? " front" : ""), (Throwable)e);
            return "";
        }
    }

    private String getURLCasProxyCallback(InfosSite infosSite) {
        if (this.modeCas.equals(LIBELLE_JTF_CAS_MODE_PROXY)) {
            return URLResolver.getAbsoluteUrl(PropertyHelper.getCoreProperty(PARAM_JTF_CAS_URI_PROXY_RECEPTOR), true, infosSite);
        }
        return "";
    }
}

