/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.monitoring;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import javax.servlet.http.HttpServletRequest;

public abstract class AbsModuleMonitoring {
    public static final int CODE_ERREUR_RESULTAT_EXECUTION_OK = 0;
    public static final int CODE_ERREUR_RESULTAT_EXECUTION_ERREUR = -1;
    public static final int CODE_ERREUR_RESULTAT_EXECUTION_WARNING = 1;
    public static final String PARAM_MODULE_MONITORING = "monitoring.module";
    public static final String PARAM_MODULE_MONITORING_TPS_WARNING = "tps_warning";
    public static final String PARAM_MODULE_MONITORING_TPS_CRITIQUE = "tps_critique";
    private final String code;
    private final String intitule;

    public AbsModuleMonitoring(String code, String intitule) {
        this.code = code;
        this.intitule = intitule;
    }

    public String getIntitule() {
        return this.intitule;
    }

    public abstract ResExec executer(String var1, OMContext var2, HttpServletRequest var3);

    protected String getParametre(String param) {
        return PropertyHelper.getCoreProperty("monitoring.module." + this.code + "." + param);
    }

    protected long getTpsWarning() {
        String param = this.getParametre(PARAM_MODULE_MONITORING_TPS_WARNING);
        if (param != null) {
            return Long.parseLong(param);
        }
        return -1L;
    }

    protected long getTpsCritique() {
        String param = this.getParametre(PARAM_MODULE_MONITORING_TPS_CRITIQUE);
        if (param != null) {
            return Long.parseLong(param);
        }
        return -1L;
    }

    protected int getCodeErreurTpsExec(long tps) {
        long tpsWarning = this.getTpsWarning();
        long tpsCritique = this.getTpsCritique();
        if (tpsWarning == -1L || tpsCritique == -1L) {
            return 0;
        }
        if (tps < tpsWarning) {
            return 0;
        }
        if (tps >= tpsWarning && tps < tpsCritique) {
            return 1;
        }
        return -1;
    }

    public class ResExec {
        public static final String STATUT_OK = "_OK_";
        public static final String STATUT_ERREUR = "_ERREUR_";
        public static final String STATUT_WARNING = "_WARNING_";
        private String statut;
        private final String intituleScenario;
        private final String intituleModuleMonitoring;
        private final String message;
        private final int codeErreur;
        private final long temps;

        public ResExec(String intituleScenario, String intituleModuleMonitoring, int codeErreur, String msg) {
            this(intituleScenario, intituleModuleMonitoring, codeErreur, msg, -1L);
        }

        public ResExec(String intituleScenario, String intituleModuleMonitoring, int codeErreur, String msg, long tpsExec) {
            this.intituleScenario = intituleScenario;
            this.intituleModuleMonitoring = intituleModuleMonitoring;
            this.codeErreur = codeErreur;
            this.message = msg;
            this.temps = tpsExec;
            if (codeErreur == 0) {
                this.statut = STATUT_OK;
            } else if (codeErreur <= -1) {
                this.statut = STATUT_ERREUR;
            } else if (codeErreur >= 1) {
                this.statut = STATUT_WARNING;
            }
        }

        public String getStatut() {
            return this.statut;
        }

        public int getCodeErreur() {
            return this.codeErreur;
        }

        public String getIntituleModuleMonitoring() {
            return this.intituleModuleMonitoring;
        }

        public String getIntituleScenario() {
            return this.intituleScenario;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTemps() {
            return this.temps;
        }
    }
}

