/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.monitoring;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;
import com.jsbsoft.jtf.monitoring.AbsScenario;
import com.jsbsoft.jtf.monitoring.ExceptionMonitoring;
import com.kportal.core.config.PropertyHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GestionnaireScenarios {
    public static final String PARAM_REQUETE_NOM_SCENARIO = "scenario";
    public static final String PARAM_JTF_SCENARIOS_CLASSES = "monitoring.scenarios_classes";
    public static final String PARAM_JTF_RESTRICTION_IPS = "monitoring.ips_restriction";
    public static final String PARAM_JTF_RAFRAICHISSEMENT_VUE = "monitoring.rafraichissement_vue";
    public static final String IP_AUTORISEE_DEFAUT = "127.0.0.1";
    public static final long RAFRAICHISSEMENT_VUE_DEFAUT = 300L;
    private static GestionnaireScenarios _instance;
    private static final Logger LOG;
    private final Map<String, AbsScenario> mapScenarios = new HashMap<String, AbsScenario>();
    private final Set<String> setIpsRestriction = new HashSet<String>();

    public static synchronized GestionnaireScenarios getInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (_instance == null) {
            _instance = new GestionnaireScenarios();
        }
        return _instance;
    }

    public String getTpsRafraichissement() {
        String tps = PropertyHelper.getCoreProperty(PARAM_JTF_RAFRAICHISSEMENT_VUE);
        if (tps != null) {
            return tps;
        }
        return "300";
    }

    public synchronized Object enregistreScenario(AbsScenario scenario) {
        return this.mapScenarios.put(scenario.getCode(), scenario);
    }

    public synchronized Object supprimeScenario(AbsScenario scenario) {
        return this.mapScenarios.remove(scenario.getCode());
    }

    public synchronized Set<AbsModuleMonitoring.ResExec[]> executerScenarios(OMContext ctx, HttpServletRequest req) throws ExceptionMonitoring {
        String remoteAddr = req.getRemoteAddr();
        if (!this.setIpsRestriction.contains(remoteAddr)) {
            LOG.error("IP invalide : " + remoteAddr);
            throw new ExceptionMonitoring("IP invalide");
        }
        LinkedHashSet<AbsModuleMonitoring.ResExec[]> listeResultats = new LinkedHashSet<AbsModuleMonitoring.ResExec[]>();
        String paramNomScenario = req.getParameter(PARAM_REQUETE_NOM_SCENARIO);
        if (paramNomScenario != null) {
            AbsScenario scenario = this.mapScenarios.get(paramNomScenario);
            if (scenario == null) {
                throw new ExceptionMonitoring("Sc\u00e9nario " + paramNomScenario + " inexistant");
            }
            listeResultats.add(scenario.executer(ctx, req));
            return listeResultats;
        }
        for (String string : this.mapScenarios.keySet()) {
            AbsScenario scenario = this.mapScenarios.get(string);
            listeResultats.add(scenario.executer(ctx, req));
        }
        return listeResultats;
    }

    private GestionnaireScenarios() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String param = PropertyHelper.getCoreProperty(PARAM_JTF_SCENARIOS_CLASSES);
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param, ";");
            while (st.hasMoreTokens()) {
                AbsScenario scenario = (AbsScenario)Class.forName(st.nextToken()).newInstance();
                this.mapScenarios.put(scenario.getCode(), scenario);
            }
        }
        this.setIpsRestriction.add(IP_AUTORISEE_DEFAUT);
        param = PropertyHelper.getCoreProperty(PARAM_JTF_RESTRICTION_IPS);
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param, ";");
            while (st.hasMoreTokens()) {
                this.setIpsRestriction.add(st.nextToken());
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(GestionnaireScenarios.class);
    }
}

