/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.monitoring.impl;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleChargementSessionUtilisateur
extends AbsModuleMonitoring {
    public static final String MODULE_CODE = "chargt_user";
    public static final String MODULE_INTITULE = "Chargement session utilisateur";
    public static final String MODULE_PARAM_UTILISATEUR = "login";
    private static final Logger LOG = LoggerFactory.getLogger(ModuleChargementSessionUtilisateur.class);

    public ModuleChargementSessionUtilisateur() {
        super(MODULE_CODE, MODULE_INTITULE);
    }

    @Override
    public AbsModuleMonitoring.ResExec executer(String intituleScenario, OMContext ctx, HttpServletRequest req) {
        AbsModuleMonitoring.ResExec res;
        block5: {
            String codeUtilisateur = this.getParametre(MODULE_PARAM_UTILISATEUR);
            if (codeUtilisateur != null) {
                long tps = System.currentTimeMillis();
                try {
                    boolean resultat = GestionnaireIdentification.getInstance().chargeInfoUser(codeUtilisateur, ctx, req.getSession(Boolean.FALSE.booleanValue()), req.getHeader("user-agent"));
                    tps = System.currentTimeMillis() - tps;
                    if (resultat) {
                        res = new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, this.getCodeErreurTpsExec(tps), "Chargement OK de l'utilisateur " + codeUtilisateur, tps);
                        break block5;
                    }
                    res = new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, -1, "Utilisateur " + codeUtilisateur + " inconnu", tps);
                }
                catch (Exception e) {
                    res = new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, -1, "Echec chargement de l'utilisateur " + codeUtilisateur);
                    LOG.error("Echec chargement de l'utilisateur " + codeUtilisateur, (Throwable)e);
                }
            } else {
                res = new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, -1, "Echec : aucun code utilisateur");
            }
        }
        return res;
    }
}

