/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.monitoring.impl;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.ValidateurCAS;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleConnexionCAS
extends AbsModuleMonitoring {
    public static final String MODULE_CODE = "connexion_cas";
    public static final String MODULE_INTITULE = "Connexion serveur CAS";
    public static final String MODULE_PARAM_URI_LOGIN_CAS = "uri_login_cas";
    public static final String MODULE_PARAM_LOGIN_CAS = "login_cas";
    public static final String MODULE_PARAM_PASSWORD_CAS = "password_cas";
    public static final String MODULE_PARAM_REGEXP_CONNEXION_REUSSIE = "regexp_connexion_reussie";
    private static final Logger LOG = LoggerFactory.getLogger(ModuleConnexionCAS.class);
    private static final String REG_EXP_LT = "LT-\\d{1,}-[a-zA-Z0-9]{20}";
    private Pattern regexpPatternLT;
    private Pattern regexpConnexionReussie;
    private final String hoteCas;
    private final int portCas;

    public ModuleConnexionCAS() {
        super(MODULE_CODE, MODULE_INTITULE);
        ValidateurCAS validateurCAS = GestionnaireIdentification.getInstance().getValidateurCAS();
        this.hoteCas = validateurCAS.getHoteCas();
        this.portCas = validateurCAS.getPortServeurCas();
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            this.regexpPatternLT = compiler.compile(REG_EXP_LT);
            this.regexpConnexionReussie = compiler.compile(this.getParametre(MODULE_PARAM_REGEXP_CONNEXION_REUSSIE));
        }
        catch (MalformedPatternException e) {
            LOG.error("erreur de pattern", (Throwable)e);
        }
    }

    private String flux2String(InputStream is) throws IOException {
        int nbBytes;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buffer = new byte[4096];
        String res = "";
        while ((nbBytes = bis.read(buffer)) > 0) {
            res = res + new String(buffer, 0, nbBytes);
        }
        bis.close();
        return res;
    }

    @Override
    public AbsModuleMonitoring.ResExec executer(String intiutleScenario, OMContext ctx, HttpServletRequest req) {
        long tps = System.currentTimeMillis();
        HttpClient client = new HttpClient();
        client.getHostConfiguration().setHost(this.hoteCas, this.portCas, "https");
        GetMethod authget = new GetMethod(this.getParametre(MODULE_PARAM_URI_LOGIN_CAS));
        AbsModuleMonitoring.ResExec res = null;
        try {
            client.executeMethod((HttpMethod)authget);
            String lt = null;
            PatternMatcherInput pmiPage = new PatternMatcherInput(this.flux2String(authget.getResponseBodyAsStream()));
            Perl5Matcher matcher = new Perl5Matcher();
            if (!matcher.contains(pmiPage, this.regexpPatternLT)) {
                authget.releaseConnection();
                return new AbsModuleMonitoring.ResExec(this, intiutleScenario, MODULE_INTITULE, -1, "Impossible de trouver le param\u00e8tre LT dans le corps lors de la connexion au serveur CAS " + this.hoteCas + " (serveur indisponible ?).");
            }
            lt = matcher.getMatch().toString();
            authget.releaseConnection();
            PostMethod authpost = new PostMethod(this.getParametre(MODULE_PARAM_URI_LOGIN_CAS));
            authpost.setRequestBody(new NameValuePair[]{new NameValuePair("username", this.getParametre(MODULE_PARAM_LOGIN_CAS)), new NameValuePair("password", this.getParametre(MODULE_PARAM_PASSWORD_CAS)), new NameValuePair("lt", lt)});
            client.executeMethod((HttpMethod)authpost);
            pmiPage = new PatternMatcherInput(this.flux2String(authpost.getResponseBodyAsStream()));
            tps = System.currentTimeMillis() - tps;
            res = matcher.contains(pmiPage, this.regexpConnexionReussie) ? new AbsModuleMonitoring.ResExec(this, intiutleScenario, MODULE_INTITULE, this.getCodeErreurTpsExec(tps), "Authentification sur le serveur CAS " + this.hoteCas + " valid\u00e9e<br/>pour l'utilisateur " + this.getParametre(MODULE_PARAM_LOGIN_CAS), tps) : new AbsModuleMonitoring.ResExec(this, intiutleScenario, MODULE_INTITULE, -1, "Echec connexion au serveur CAS " + this.hoteCas, tps);
            authpost.releaseConnection();
        }
        catch (IOException e) {
            LOG.error("Echec connexion au serveur CAS " + this.hoteCas, (Throwable)e);
            res = new AbsModuleMonitoring.ResExec(this, intiutleScenario, MODULE_INTITULE, -1, "Echec connexion au serveur CAS " + this.hoteCas);
        }
        return res;
    }
}

