/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.monitoring.impl;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleOccupationMemoire
extends AbsModuleMonitoring {
    public static final String MODULE_PARAM_POURENTAGE_WARNING = "pourcentage_occupation_warning";
    public static final String MODULE_PARAM_POURENTAGE_CRITIQUE = "pourcentage_occupation_critique";
    public static final String MODULE_CODE = "occupation_memoire";
    public static final String MODULE_INTITULE = "Occupation m\u00e9moire";
    private static final Logger LOG = LoggerFactory.getLogger(ModuleOccupationMemoire.class);
    private static boolean threadLance = false;
    private static final int DELAI_THREAD_INFO_MEMOIRE = 5000;

    public ModuleOccupationMemoire() {
        super(MODULE_CODE, MODULE_INTITULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void lanceThreadMemoire() {
        if (!LOG.isDebugEnabled() || threadLance) return;
        Class<ModuleOccupationMemoire> clazz = ModuleOccupationMemoire.class;
        synchronized (ModuleOccupationMemoire.class) {
            if (threadLance) return;
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        long heapMaxSize = Runtime.getRuntime().maxMemory() / 1024L;
                        long heapSize = Runtime.getRuntime().totalMemory() / 1024L;
                        long heapFreeSize = Runtime.getRuntime().freeMemory() / 1024L;
                        int pourcentageOccupation = (int)((heapSize - heapFreeSize) * 100L / heapSize);
                        LOG.debug("Taille du tas : " + heapSize + " ko | Taille maximale du tas : " + heapMaxSize + " ko | Occupation m\u00e9moire : " + pourcentageOccupation + "% (" + (heapSize - heapFreeSize) + " ko)");
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            LOG.error("Erreur lors de la mise en veille du thread", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }.start();
            threadLance = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public AbsModuleMonitoring.ResExec executer(String intituleScenario, OMContext ctx, HttpServletRequest req) {
        long heapSize = Runtime.getRuntime().totalMemory() / 1024L;
        long heapMaxSize = Runtime.getRuntime().maxMemory() / 1024L;
        long heapFreeSize = Runtime.getRuntime().freeMemory() / 1024L;
        int pourcentageOccupation = (int)((heapSize - heapFreeSize) * 100L / heapSize);
        String infosMem = "Taille du tas : " + heapSize + " ko | Taille maximale du tas : " + heapMaxSize + " ko <br/>Occupation m\u00e9moire : " + pourcentageOccupation + "% (" + (heapSize - heapFreeSize) + " ko)";
        int pourcentageOccupationWarning = Integer.parseInt(this.getParametre(MODULE_PARAM_POURENTAGE_WARNING));
        int pourcentageOccupationCritique = Integer.parseInt(this.getParametre(MODULE_PARAM_POURENTAGE_CRITIQUE));
        if (pourcentageOccupation >= pourcentageOccupationWarning && pourcentageOccupation < pourcentageOccupationCritique) {
            LOG.warn(infosMem);
            return new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, 1, infosMem);
        }
        if (pourcentageOccupation >= pourcentageOccupationWarning) {
            LOG.error(infosMem);
            return new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, -1, infosMem);
        }
        return new AbsModuleMonitoring.ResExec(this, intituleScenario, MODULE_INTITULE, 0, infosMem);
    }
}

