/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.stats;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurTechnique;
import com.jsbsoft.jtf.stats.IStats;
import com.jsbsoft.jtf.stats.InfosStats;
import com.kportal.core.config.PropertyHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStats
implements IStats {
    public static final String PROP_STATS = "stats";
    public static final String PROP_STATS_ACTIVATION = "stats.activation";
    public static final String PROP_STATS_FORMAT = "format";
    public static final String ID_LOGGER = "stats";
    private static final Logger LOG = LoggerFactory.getLogger(LogStats.class);
    private static final Logger LOG_STATS = LoggerFactory.getLogger((String)"stats");
    private static LogStats _instance;
    private static Pattern _regexpPattern;
    private boolean activationStats = "1".equals(PropertyHelper.getCoreProperty("stats.activation"));
    private InfosStats infosStats;

    public static boolean isLogStats() {
        LogStats.init();
        return LogStats._instance.activationStats;
    }

    public static void log(OMContext ctx, String idLog, Map<String, String> mapInfos) throws ErreurTechnique {
        LogStats.init();
        if (!LogStats._instance.activationStats) {
            return;
        }
        String formatLog = PropertyHelper.getCoreProperty("stats." + idLog + "." + PROP_STATS_FORMAT);
        if (formatLog == null) {
            throw new ErreurTechnique(-1, "Identifiant de log de statistiques invalide.");
        }
        String message = formatLog;
        PatternMatcherInput pmiLigne = new PatternMatcherInput(formatLog);
        Perl5Matcher matcher = new Perl5Matcher();
        while (matcher.contains(pmiLigne, _regexpPattern)) {
            String switch_ = matcher.getMatch().toString();
            String switchValeur = mapInfos.get(switch_);
            if (switchValeur == null) {
                switchValeur = LogStats._instance.infosStats.getInfos(ctx, switch_);
            }
            if (switchValeur == null) {
                switchValeur = "";
            }
            message = message.replaceFirst(switch_, switchValeur);
        }
        LOG_STATS.info(message);
    }

    public static void log(String idLog, Map<String, String> mapInfos) throws ErreurTechnique {
        LogStats.log(null, idLog, mapInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (_instance != null) return;
        Class<LogStats> clazz = LogStats.class;
        synchronized (LogStats.class) {
            if (_instance != null) return;
            _instance = new LogStats();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private LogStats() {
        if (!this.activationStats) {
            return;
        }
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            _regexpPattern = compiler.compile("%[a-z]+");
        }
        catch (MalformedPatternException e) {
            LOG.error("Pattern invalide : " + _regexpPattern, (Throwable)e);
        }
        this.infosStats = new InfosStats();
    }

    public static void main(String[] args) throws ErreurTechnique {
        HashMap<String, String> mapInfosStats = new HashMap<String, String>();
        mapInfosStats.put("%codeservice", "CODE_SERVICE");
        LogStats.log(null, "service", mapInfosStats);
        mapInfosStats.put("%coderub", "CODE_RUB");
        mapInfosStats.put("%modeconsult", "MODE");
        LogStats.log(null, "contrib", mapInfosStats);
    }
}

