/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.textsearch.Indexer;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstIndex {
    private static final Logger LOG = LoggerFactory.getLogger(FirstIndex.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String listeobjetsexclus = "";
        String listeobjetsinclus = "";
        if (args.length > 0 && args[0].startsWith("-exclure")) {
            listeobjetsexclus = args[1];
        } else if (args.length > 0 && args[0].startsWith("-inclure")) {
            listeobjetsinclus = args[1];
        }
        long debut = System.currentTimeMillis();
        ArrayList vObjetsExclus = new ArrayList();
        if (!listeobjetsexclus.equals("")) {
            String[] sListeExclus = listeobjetsexclus.split(",");
            Collections.addAll(vObjetsExclus, sListeExclus);
        }
        ArrayList vObjetsInclus = new ArrayList();
        if (!"".equals(listeobjetsinclus)) {
            String[] sListeInclus = listeobjetsinclus.split(",");
            Collections.addAll(vObjetsInclus, sListeInclus);
        }
        String criteredate = "";
        if (args.length > 2) {
            criteredate = args[1];
        }
        if (args.length > 0 && args[0].equals("-date")) {
            criteredate = args[0];
        }
        boolean start = true;
        ContextePage ctx = new ContextePage("");
        ctx.setConnectionLongue(true);
        try {
            if (!criteredate.equals("")) {
                Date today = new Date(new GregorianCalendar().getTimeInMillis());
                criteredate = " AND (DATE_FORMAT(DATE_CREATION, '%Y-%m-%d')='" + today + "' OR DATE_FORMAT(DATE_MODIFICATION, '%Y-%m-%d')='" + today + "')";
                LOG.info("*** D\u00e9but de l'indexation des fiches cr\u00e9\u00e9es ou modifi\u00e9es aujourd'hui ***");
                LOG.info(criteredate);
            } else {
                LOG.info("*** D\u00e9but de l'indexation des fiches ***");
            }
            Collection<String> listeObjets = ReferentielObjets.getListeNomsObjet();
            Indexer indexer = Indexer.getInstance();
            try {
                if (indexer.getWriter() != null) {
                    throw new Exception("writer en cours d'ex\u00e9cution");
                }
                indexer.initWriter();
                for (String nom : listeObjets) {
                    if (vObjetsExclus.contains(nom) || vObjetsInclus.size() > 0 && !vObjetsInclus.contains(nom)) {
                        LOG.info("Les fiches '" + nom + "' ne seront pas index\u00e9es");
                        continue;
                    }
                    LOG.info("*** objet : " + nom + " ***");
                    FicheUniv fiche = ReferentielObjets.instancierFiche(nom);
                    fiche.setCtx(ctx);
                    if (indexer.deleteFicheByType(nom)) {
                        if (start) {
                            start = false;
                        }
                        if (fiche.select("WHERE ETAT_OBJET IN ('0003','0004')" + criteredate) <= 0) continue;
                        while (fiche.nextItem()) {
                            LOG.info("fiche : " + fiche.getLibelleAffichable());
                            try {
                                indexer.indexFiche(ctx, fiche, false);
                            }
                            catch (Exception e) {
                                LOG.error("Exception lors de l'indexation de la fiche : " + fiche.getLibelleAffichable(), (Throwable)e);
                            }
                        }
                        continue;
                    }
                    LOG.error("Impossible d'indexer les fiches " + nom);
                }
            }
            catch (Exception e) {
                LOG.error("Exception Batch FirstIndex : " + e.getMessage());
            }
            finally {
                indexer.optimisation();
                indexer.closeWriter();
            }
            int i = new Integer(Long.toString((System.currentTimeMillis() - debut) / 1000L));
            String heure = "00";
            String min = "00";
            String sec = "00";
            if (i > 3600) {
                int t = i / 3600;
                heure = t < 10 ? "0" + Integer.toString(t) : Integer.toString(t);
                if ((i -= t * 60) > 60) {
                    t = i / 60;
                    min = t < 10 ? "0" + Integer.toString(t) : Integer.toString(t);
                    sec = (t = i - t * 60) < 10 ? "0" + Integer.toString(t) : Integer.toString(t);
                }
            } else if (i > 60) {
                int t = i / 60;
                min = t < 10 ? "0" + Integer.toString(t) : Integer.toString(t);
                sec = (t = i - t * 60) < 10 ? "0" + Integer.toString(t) : Integer.toString(t);
            } else {
                sec = i < 10 ? "0" + Integer.toString(i) : Integer.toString(i);
            }
            LOG.info("*** Fin de l'indexation ( dur\u00e9e : " + heure + ":" + min + ":" + sec + " ) ***");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ctx.release();
        }
    }
}

