/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.lang.CharEncoding;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ISOLatin1AccentFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class FrenchAnalyzer
extends Analyzer {
    public static final String[] FRENCH_STOP_WORDS = new String[]{"a", "afin", "ai", "ainsi", "apr\u00e8s", "attendu", "au", "aujourd", "auquel", "aussi", "autre", "autres", "aux", "auxquelles", "auxquels", "avait", "avant", "avec", "avoir", "c", "car", "ce", "ceci", "cela", "celle", "celles", "celui", "cependant", "certain", "certaine", "certaines", "certains", "ces", "cet", "cette", "ceux", "chez", "ci", "combien", "comme", "comment", "concernant", "contre", "d", "dans", "de", "debout", "dedans", "dehors", "del\u00e0", "depuis", "derri\u00e8re", "des", "d\u00e9sormais", "desquelles", "desquels", "dessous", "dessus", "devant", "devers", "devra", "divers", "diverse", "diverses", "doit", "donc", "dont", "du", "duquel", "durant", "d\u00e8s", "elle", "elles", "en", "entre", "environ", "est", "et", "etc", "etre", "eu", "eux", "except\u00e9", "hormis", "hors", "h\u00e9las", "hui", "il", "ils", "j", "je", "jusqu", "jusque", "l", "la", "laquelle", "le", "lequel", "les", "lesquelles", "lesquels", "leur", "leurs", "lorsque", "lui", "l\u00e0", "ma", "mais", "malgr\u00e9", "me", "merci", "mes", "mien", "mienne", "miennes", "miens", "moi", "moins", "mon", "moyennant", "m\u00eame", "m\u00eames", "n", "ne", "ni", "non", "nos", "notre", "nous", "n\u00e9anmoins", "n\u00f4tre", "n\u00f4tres", "on", "ont", "ou", "outre", "o\u00f9", "par", "parmi", "partant", "pas", "pass\u00e9", "pendant", "plein", "plus", "plusieurs", "pour", "pourquoi", "proche", "pr\u00e8s", "puisque", "qu", "quand", "que", "quel", "quelle", "quelles", "quels", "qui", "quoi", "quoique", "revoici", "revoil\u00e0", "s", "sa", "sans", "sauf", "se", "selon", "seront", "ses", "si", "sien", "sienne", "siennes", "siens", "sinon", "soi", "soit", "son", "sont", "sous", "suivant", "sur", "ta", "te", "tes", "tien", "tienne", "tiennes", "tiens", "toi", "ton", "tous", "tout", "toute", "toutes", "tu", "un", "une", "va", "vers", "voici", "voil\u00e0", "vos", "votre", "vous", "vu", "v\u00f4tre", "v\u00f4tres", "y", "\u00e0", "\u00e7a", "\u00e8s", "\u00e9t\u00e9", "\u00eatre", "\u00f4"};
    private Set<Object> stoptable = new HashSet<Object>();
    private boolean activeStopTable = false;
    private Version matchVersion = Version.LUCENE_36;

    public FrenchAnalyzer(boolean bstoptable) {
        this.stoptable = StopFilter.makeStopSet((String[])FRENCH_STOP_WORDS);
        this.activeStopTable = bstoptable;
    }

    public FrenchAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
    }

    public FrenchAnalyzer(File stopwords) throws IOException {
        this.stoptable = new HashSet<Object>((Collection<Object>)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader((File)stopwords, (Charset)CharEncoding.DEFAULT_CHARSET), (Version)this.matchVersion));
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        StandardTokenizer result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter((TokenStream)result);
        if (this.activeStopTable) {
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stoptable);
        }
        result = new ISOLatin1AccentFilter((TokenStream)result);
        result = new ElisionFilter((TokenStream)result, this.stoptable);
        result = new LowerCaseFilter((TokenStream)result);
        return result;
    }

    public Set<Object> getStoptable() {
        return this.stoptable;
    }

    public void setStoptable(Set<Object> stoptable) {
        this.stoptable = stoptable;
    }

    public void setMatchVersion(Version matchVersion) {
        this.matchVersion = matchVersion;
    }
}

