/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.textsearch.util.SearchPropertiesHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Index {
    private String content = null;
    private String contentFile = null;
    private List<String> codeRubrique = null;
    private String codeSite = null;
    private List<String> codeRattachement = null;
    private String codeFiche = null;
    private String codeRedacteur = null;
    private String idFiche = null;
    private String etatFiche = null;
    private String langue = null;
    private String objet = null;
    private String publicVise = null;
    private String publicViseRestriction = null;
    private String modeRestriction = null;
    private String identifiantUnique = null;
    private String lastModified = null;
    private String codeEspace = null;
    private String url = null;
    private String title = null;
    private String keywords = null;
    private String description = null;
    private String miseEnLigne = null;
    public static final String CONTENT = "contenu";
    public static final String CONTENT_FILE = "contenu_fichiers";
    public static final String CODE_RUBRIQUE = "code_rubrique";
    public static final String CODE_RATTACHEMENT = "code_rattachement";
    public static final String CODE_FICHE = "code";
    public static final String CODE_SITE = "code_site";
    public static final String CODE_REDACTEUR = "code_redacteur";
    public static final String ID_FICHE = "id_fiche";
    public static final String ETAT_FICHE = "etat_objet";
    public static final String LANGUE = "langue";
    public static final String OBJET = "nom_objet";
    public static final String PUBLIC_VISE = "public_vise";
    public static final String PUBLIC_VISE_RESTRICTION = "public_vise_restriction";
    public static final String MODE_RESTRICTION = "mode_restriction";
    public static final String IDENTIFIANT_UNIQUE = "id_unique";
    public static final String LAST_MODIFIED = "date_modification";
    public static final String MISE_EN_LIGNE = "meta_date_mise_en_ligne";
    public static final String CODE_ESPACE = "code_espace";
    public static final String URL = "url";
    public static final String TITLE = "title";
    public static final String KEYWORDS = "keywords";
    public static final String DESCRIPTION = "description";
    private static final Logger LOG = LoggerFactory.getLogger(Index.class);

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCodeEspace() {
        return this.codeEspace;
    }

    public void setCodeEspace(String codeEspace) {
        this.codeEspace = codeEspace;
    }

    public String getCodeFiche() {
        return this.codeFiche;
    }

    public void setCodeFiche(String codeFiche) {
        this.codeFiche = codeFiche;
    }

    public List<String> getCodeRattachement() {
        return this.codeRattachement;
    }

    public void setCodeRattachement(List<String> codeRattachement) {
        this.codeRattachement = codeRattachement;
    }

    public List<String> getCodeRubrique() {
        return this.codeRubrique;
    }

    public void setCodeRubrique(List<String> codeRubrique) {
        this.codeRubrique = codeRubrique;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getEtatFiche() {
        return this.etatFiche;
    }

    public void setEtatFiche(String etatFiche) {
        this.etatFiche = etatFiche;
    }

    public String getIdentifiantUnique() {
        return this.identifiantUnique;
    }

    public void setIdentifiantUnique(String identifiantUnique) {
        this.identifiantUnique = identifiantUnique;
    }

    public String getIdFiche() {
        return this.idFiche;
    }

    public void setIdFiche(String idFiche) {
        this.idFiche = idFiche;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getLangue() {
        return this.langue;
    }

    public void setLangue(String langueFiche) {
        this.langue = langueFiche;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getModeRestriction() {
        return this.modeRestriction;
    }

    public void setModeRestriction(String modeRestriction) {
        this.modeRestriction = modeRestriction;
    }

    public String getObjet() {
        return this.objet;
    }

    public void setObjet(String objet) {
        this.objet = objet;
    }

    public String getPublicVise() {
        return this.publicVise;
    }

    public void setPublicVise(String publicVise) {
        this.publicVise = publicVise;
    }

    public String getPublicViseRestriction() {
        return this.publicViseRestriction;
    }

    public void setPublicViseRestriction(String publicViseRestriction) {
        this.publicViseRestriction = publicViseRestriction;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Document creerDocument() throws Exception {
        Field fieldKeys;
        Document document = new Document();
        document.add((Fieldable)new Field(IDENTIFIANT_UNIQUE, this.getIdentifiantUnique(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (this.getObjet() != null) {
            document.add((Fieldable)new Field(OBJET, this.getObjet(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getIdFiche() != null) {
            document.add((Fieldable)new Field(ID_FICHE, this.getIdFiche(), Field.Store.YES, Field.Index.NO));
        }
        if (this.getCodeFiche() != null) {
            document.add((Fieldable)new Field(CODE_FICHE, this.getCodeFiche(), Field.Store.YES, Field.Index.NO));
        }
        if (this.getCodeRedacteur() != null) {
            document.add((Fieldable)new Field(CODE_REDACTEUR, this.getCodeRedacteur(), Field.Store.YES, Field.Index.NO));
        }
        if (this.getLangue() != null) {
            document.add((Fieldable)new Field(LANGUE, this.getLangue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getEtatFiche() != null) {
            document.add((Fieldable)new Field(ETAT_FICHE, this.getEtatFiche(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getCodeRattachement() != null) {
            for (String code : this.getCodeRattachement()) {
                document.add((Fieldable)new Field(CODE_RATTACHEMENT, code, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        if (this.getLastModified() != null) {
            document.add((Fieldable)new Field(LAST_MODIFIED, this.getLastModified(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getMiseEnLigne() != null) {
            Field fieldKeys2 = new Field(MISE_EN_LIGNE, this.getMiseEnLigne(), Field.Store.YES, Field.Index.ANALYZED);
            fieldKeys2.setBoost(2.0f);
            document.add((Fieldable)fieldKeys2);
        }
        if (StringUtils.isEmpty((CharSequence)this.getModeRestriction())) {
            this.modeRestriction = "0";
        }
        document.add((Fieldable)new Field(MODE_RESTRICTION, this.getModeRestriction(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (this.getPublicVise() != null) {
            document.add((Fieldable)new Field(PUBLIC_VISE, this.getPublicVise(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getPublicViseRestriction() != null) {
            document.add((Fieldable)new Field(PUBLIC_VISE_RESTRICTION, this.getPublicViseRestriction(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getCodeRubrique() != null) {
            for (String code : this.getCodeRubrique()) {
                document.add((Fieldable)new Field(CODE_RUBRIQUE, code, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        if (this.getCodeSite() != null) {
            document.add((Fieldable)new Field(CODE_SITE, this.getCodeSite(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (this.getContent() != null) {
            document.add((Fieldable)new Field(CONTENT, this.getContent(), Field.Store.NO, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(CONTENT, CompressionTools.compress((byte[])this.getContent().getBytes())));
        }
        if (this.getContentFile() != null) {
            document.add((Fieldable)new Field(CONTENT_FILE, this.getContentFile(), Field.Store.NO, Field.Index.ANALYZED));
            document.add((Fieldable)new Field(CONTENT_FILE, CompressionTools.compress((byte[])this.getContentFile().getBytes())));
        }
        int boost = 1;
        if (this.getTitle() != null) {
            try {
                boost = SearchPropertiesHelper.getBoostTitre();
                Field fieldTitre = new Field(TITLE, this.getTitle(), Field.Store.YES, Field.Index.ANALYZED);
                fieldTitre.setBoost((float)boost * 1.0f);
                document.add((Fieldable)fieldTitre);
            }
            catch (Exception e) {
                LOG.error("erreur lors de l'instanciation du field", (Throwable)e);
            }
        }
        if (this.getDescription() != null) {
            try {
                boost = SearchPropertiesHelper.getBoostMetaDescription();
                fieldKeys = new Field(DESCRIPTION, this.getDescription(), Field.Store.YES, Field.Index.ANALYZED);
                fieldKeys.setBoost((float)boost * 1.0f);
                document.add((Fieldable)fieldKeys);
            }
            catch (Exception e) {
                LOG.error("erreur lors de l'instanciation du field", (Throwable)e);
            }
        }
        if (this.getKeywords() != null) {
            try {
                boost = SearchPropertiesHelper.getBoostMetaKeywords();
                fieldKeys = new Field(KEYWORDS, this.getKeywords(), Field.Store.YES, Field.Index.ANALYZED);
                fieldKeys.setBoost((float)boost * 1.0f);
                document.add((Fieldable)fieldKeys);
            }
            catch (Exception e) {
                LOG.error("erreur lors de l'instanciation du field", (Throwable)e);
            }
        }
        if (this.getUrl() != null) {
            document.add((Fieldable)new Field(URL, this.getUrl(), Field.Store.YES, Field.Index.NO));
        }
        if (this.getObjet() != null) {
            document.setBoost((float)SearchPropertiesHelper.getBoostParObjet("", this.getObjet().toLowerCase()) * 1.0f);
        }
        return document;
    }

    public String getMiseEnLigne() {
        return this.miseEnLigne;
    }

    public void setMiseEnLigne(String miseEnLigne) {
        this.miseEnLigne = miseEnLigne;
    }

    public String getContentFile() {
        return this.contentFile;
    }

    public void setContentFile(String content_file) {
        this.contentFile = content_file;
    }

    public void setCodeSite(String codeSite) {
        this.codeSite = codeSite;
    }

    public String getCodeSite() {
        return this.codeSite;
    }

    public String getCodeRedacteur() {
        return this.codeRedacteur;
    }

    public void setCodeRedacteur(String codeRedacteur) {
        this.codeRedacteur = codeRedacteur;
    }
}

