/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.textsearch.FrenchAnalyzer;
import com.jsbsoft.jtf.textsearch.Index;
import com.jsbsoft.jtf.textsearch.LockLuceneFilter;
import com.jsbsoft.jtf.textsearch.RechercheFmt;
import com.jsbsoft.jtf.textsearch.Searcher;
import com.jsbsoft.jtf.textsearch.util.IndexationHelper;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.FicheUnivMgr;
import com.univ.xhtml.HTMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class Indexer {
    public static final String DOSSIER_GLOBAL = "interne";
    public static Analyzer analyzer = new FrenchAnalyzer(false);
    private static File repertoireIndexation = null;
    private IndexWriter writer;
    private static Indexer _instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(Indexer.class);
    private static final String DEFAULT_ETATS_NON_INDEXABLES = (Object)((Object)EtatFiche.APERCU) + ";" + (Object)((Object)EtatFiche.SAUVEGARDE_AUTO) + ";" + (Object)((Object)EtatFiche.A_SUPPRIMER);
    private Set<String> etatsNonIndexables = null;

    public static File getRepertoireIndexation() {
        if (repertoireIndexation == null) {
            try {
                String indexDir = IndexationHelper.getWorkDirectory() + File.separator + DOSSIER_GLOBAL;
                repertoireIndexation = new File(indexDir);
                if (!repertoireIndexation.exists()) {
                    repertoireIndexation.mkdir();
                }
            }
            catch (Exception e) {
                LOGGER.error("erreur lors de la cr\u00e9ation du dossier", (Throwable)e);
            }
        }
        return repertoireIndexation;
    }

    protected Indexer() throws Exception {
        Indexer.getRepertoireIndexation();
        String property = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("index.fiche.etatsnonindexables"), (String)DEFAULT_ETATS_NON_INDEXABLES);
        this.etatsNonIndexables = new HashSet<String>(Arrays.asList(property.split(";+")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Indexer getInstance() throws Exception {
        if (_instance != null) return _instance;
        Class<Indexer> clazz = Indexer.class;
        synchronized (Indexer.class) {
            if (_instance != null) return _instance;
            _instance = new Indexer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delock(JspWriter out) throws Exception {
        long timeOut = IndexWriterConfig.WRITE_LOCK_TIMEOUT;
        IndexWriterConfig.WRITE_LOCK_TIMEOUT = 60000L;
        try {
            out.println("Ouverture de l'index...<br/>");
            out.flush();
            this.initWriter();
        }
        catch (Exception e) {
            out.println("Timeout atteint !<br/>");
            out.flush();
            out.print("Suppression du lock...");
            out.flush();
            File ledossier = new File(System.getProperty("org.apache.lucene.lockdir", System.getProperty("java.io.tmpdir")));
            if (ledossier.exists() && ledossier.isDirectory() && ledossier.canWrite()) {
                String[] listenoms;
                for (String nomLock : listenoms = ledossier.list(new LockLuceneFilter())) {
                    File fichier = new File(ledossier.getAbsolutePath() + File.separator + nomLock);
                    if (!fichier.exists() || fichier.delete()) continue;
                    out.println("impossible de supprimer le lock " + nomLock);
                }
            }
            out.println("OK<br/>");
            out.flush();
            out.println("R\u00e9ouverture de l'index<br/>");
            out.flush();
            this.initWriter();
        }
        finally {
            out.println("Optimisation de l'index<br/>");
            out.flush();
            this.optimisation();
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (CorruptIndexException e) {
                    out.println("L'index est corrompu, vider le r\u00e9pertoire /textsearch et r\u00e9-indexer les contenus<br/>");
                }
            }
            IndexWriterConfig.WRITE_LOCK_TIMEOUT = timeOut;
            out.println("Fin<br/>");
            out.flush();
        }
    }

    private void newWriter() throws Exception {
        Directory directory = Searcher.getInstance().getDirectory(repertoireIndexation);
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_36, analyzer);
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(directory, conf);
    }

    public void forceInitWriter() throws Exception {
        File fLock = new File(repertoireIndexation.getAbsolutePath() + File.separator + "write.lock");
        if (fLock.exists() && !fLock.delete()) {
            throw new ErreurApplicative("impossible de supprimer le lock sur l'indexer");
        }
        this.initWriter();
    }

    public void closeWriter() throws Exception {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public synchronized void indexFiche(OMContext _ctx, FicheUniv _fiche, boolean deleteBefore) throws Exception {
        Metatag meta;
        if (_fiche == null || !FicheAnnotationHelper.isIndexable(_fiche)) {
            if (_fiche != null) {
                LOGGER.debug("_fiche {} id:[{}] non index\u00e9e (fiche non indexable)", (Object)_fiche.getClass().getSimpleName(), (Object)_fiche.getIdFiche());
            }
            return;
        }
        if (this.etatsNonIndexables != null && this.etatsNonIndexables.contains(_fiche.getEtatObjet())) {
            LOGGER.debug("_fiche {} id:[{}] non index\u00e9e (\u00e9tat non indexable)", (Object)_fiche.getClass().getSimpleName(), (Object)_fiche.getIdFiche());
            return;
        }
        String codeRubrique = _fiche.getCodeRubrique();
        ArrayList<String> lstRubriqueRestriction = this.creerLstRubriqueRestriction();
        if (lstRubriqueRestriction.contains(codeRubrique)) {
            return;
        }
        if (_fiche instanceof StructureModele && (meta = FicheUnivMgr.lireMeta(_fiche)).getMetaInTree().equals("0") && !"1".equals(PropertyHelper.getCoreProperty("structure.inTree"))) {
            return;
        }
        Index index = this.creerIndex(_ctx, _fiche);
        Document document = index.creerDocument();
        if (deleteBefore) {
            Term term = new Term("id_unique", _fiche.getClass().getName() + _fiche.getIdFiche());
            this.writer.updateDocument(term, document);
        } else {
            this.writer.addDocument(document);
        }
    }

    public void optimisation() {
        try {
            if (this.writer != null) {
                this.writer.forceMerge(1);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception lors de l'optimisation de l'index", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFiche(FicheUniv _fiche) throws Exception {
        if (_fiche == null || !FicheAnnotationHelper.isIndexable(_fiche)) {
            if (_fiche != null) {
                LOGGER.debug("fiche {} id:[{}] non desindex\u00e9e (fiche non indexable)", (Object)_fiche.getClass().getSimpleName(), (Object)_fiche.getIdFiche());
            }
            return true;
        }
        boolean res = false;
        boolean init = false;
        try {
            Term term = new Term("id_unique", _fiche.getClass().getName() + _fiche.getIdFiche());
            if (this.writer == null) {
                this.initWriter();
                init = true;
            }
            this.writer.deleteDocuments(term);
            res = true;
        }
        catch (Exception e) {
            LOGGER.error("Impossible de supprimer l'index de la fiche id=" + _fiche.getIdFiche() + " (" + _fiche.getClass().getSimpleName() + ")", (Throwable)e);
        }
        finally {
            if (init && this.writer != null) {
                this.closeWriter();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFicheByType(String type) throws Exception {
        boolean res = false;
        boolean init = false;
        try {
            Term term = new Term("nom_objet", ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(type)));
            if (this.writer == null) {
                this.initWriter();
                init = true;
            }
            this.writer.deleteDocuments(term);
            res = true;
        }
        catch (Exception e) {
            LOGGER.error("Impossible de supprimer l'index des fiches " + type, (Throwable)e);
            res = false;
        }
        finally {
            if (init && this.writer != null) {
                this.closeWriter();
            }
        }
        return res;
    }

    private String supprimeCrochets(String _chaine) {
        String chaine = _chaine;
        int idx = chaine.indexOf("[");
        while (idx != -1) {
            chaine = chaine.substring(0, idx) + chaine.substring(idx + 1);
            idx = chaine.indexOf("[");
        }
        idx = chaine.indexOf("]");
        while (idx != -1) {
            chaine = chaine.substring(0, idx) + chaine.substring(idx + 1);
            idx = chaine.indexOf("]");
        }
        return chaine;
    }

    private ArrayList<String> creerLstRubriqueRestriction() throws Exception {
        ArrayList<String> lstRubriqueRestriction = new ArrayList<String>();
        String chaineCodeRubrique = PropertyHelper.getCoreProperty("lucene.restriction_rubrique");
        if (chaineCodeRubrique != null && chaineCodeRubrique.trim().length() > 0) {
            String[] lstCodeRubrique;
            for (String codeRubrique : lstCodeRubrique = chaineCodeRubrique.trim().split(";", -2)) {
                InfosRubriques info = Rubrique.renvoyerItemRubrique(codeRubrique);
                if (info == null || info.getCode().length() <= 0) continue;
                lstRubriqueRestriction.add(info.getCode());
                for (InfosRubriques infosRubriques : info.getListeSousRubriquesTousNiveaux()) {
                    String cr = infosRubriques.getCode();
                    if (lstRubriqueRestriction.contains(cr)) continue;
                    lstRubriqueRestriction.add(cr);
                }
            }
        }
        return lstRubriqueRestriction;
    }

    private Index creerIndex(OMContext _ctx, FicheUniv _fiche) throws Exception {
        Metatag meta;
        Date dateMiseEnLigne;
        String nomObjet = ReferentielObjets.getNomObjet(ReferentielObjets.getCodeObjet(_fiche));
        String idunique = _fiche.getClass().getName() + _fiche.getIdFiche();
        Index index = new Index();
        index.setIdentifiantUnique(idunique);
        index.setObjet(nomObjet);
        index.setIdFiche(_fiche.getIdFiche().toString());
        index.setCodeFiche(_fiche.getCode());
        index.setCodeRedacteur(_fiche.getCodeRedacteur());
        index.setLangue(_fiche.getLangue());
        index.setEtatFiche(_fiche.getEtatObjet());
        index.setTitle(_fiche.getLibelleAffichable());
        String metaKeywords = "";
        if (_fiche.getMetaKeywords().length() > 0) {
            metaKeywords = _fiche.getMetaKeywords() + " ";
        }
        metaKeywords = metaKeywords + _fiche.getLibelleAffichable();
        index.setKeywords(RechercheFmt.formaterTexteRecherche(metaKeywords, true));
        metaKeywords = "";
        if (_fiche.getMetaDescription().length() > 0) {
            metaKeywords = _fiche.getMetaDescription() + " ";
        }
        metaKeywords = metaKeywords + _fiche.getLibelleAffichable();
        index.setDescription(RechercheFmt.formaterTexteRecherche(metaKeywords, true));
        ArrayList<String> listeStructures = new ArrayList<String>();
        listeStructures.add(_fiche.getCodeRattachement());
        if (_fiche instanceof FicheRattachementsSecondaires) {
            String[] codesRattachementsAutres = StringUtils.split((String)((FicheRattachementsSecondaires)((Object)_fiche)).getCodeRattachementAutres(), (String)";");
            listeStructures.addAll(Arrays.asList(codesRattachementsAutres));
        }
        index.setCodeRattachement(listeStructures);
        if (Formateur.estSaisie(_fiche.getDateModification())) {
            index.setLastModified(new SimpleDateFormat("yyyyMMdd").format(_fiche.getDateModification()));
        }
        if (!Formateur.estSaisie(dateMiseEnLigne = (meta = FicheUnivMgr.lireMeta(_fiche)).getMetaDateMiseEnLigne())) {
            dateMiseEnLigne = new Date(0L);
        }
        index.setMiseEnLigne(new SimpleDateFormat("yyyyMMdd").format(dateMiseEnLigne));
        String activationDsi = PropertyHelper.getCoreProperty("dsi.activation");
        if (activationDsi == null) {
            activationDsi = "0";
        }
        if (activationDsi.equals("1") && _fiche instanceof DiffusionSelective) {
            String pViseRestriction;
            DiffusionSelective fDsi = (DiffusionSelective)((Object)_fiche);
            index.setModeRestriction(fDsi.getDiffusionModeRestriction());
            String pVise = fDsi.getDiffusionPublicVise();
            if (StringUtils.isNotEmpty((CharSequence)pVise)) {
                pVise = this.supprimeCrochets(pVise);
                index.setPublicVise(";" + pVise + ";");
            }
            if (StringUtils.isNotEmpty((CharSequence)(pViseRestriction = fDsi.getDiffusionPublicViseRestriction()))) {
                pViseRestriction = this.supprimeCrochets(pViseRestriction);
                index.setPublicViseRestriction(";" + pViseRestriction + ";");
            }
        } else {
            index.setModeRestriction("0");
        }
        FicheUniv fichePouIndexRubrique = _fiche;
        if (_fiche instanceof FicheObjet) {
            fichePouIndexRubrique = ((FicheObjet)_fiche).renvoyerFicheParente();
        }
        ArrayList<String> listeRubriques = new ArrayList<String>();
        listeRubriques.add(fichePouIndexRubrique.getCodeRubrique());
        listeRubriques.addAll(Rubriquepublication.getListeRubriquesPublication(_ctx, fichePouIndexRubrique));
        if (FicheUnivMgr.isFicheCollaborative(fichePouIndexRubrique)) {
            InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(((DiffusionSelective)((Object)fichePouIndexRubrique)).getDiffusionPublicViseRestriction());
            listeRubriques.add(infosEspace.getCodeRubrique());
        }
        index.setCodeRubrique(listeRubriques);
        InfosSite infosSite = Site.determinerSiteRubrique(_fiche.getCodeRubrique());
        if (infosSite != null) {
            index.setCodeSite(infosSite.getAlias());
        } else {
            index.setCodeSite("");
        }
        index.setUrl("");
        StringBuilder toutcontenu = new StringBuilder(_fiche.getFullTextString());
        toutcontenu.append(" ").append(_fiche.getLibelleAffichable());
        if (_fiche.getMetaKeywords().length() > 0) {
            toutcontenu.append(" ").append(_fiche.getMetaKeywords());
        }
        if (_fiche.getMetaDescription().length() > 0) {
            toutcontenu.append(" ").append(_fiche.getMetaDescription());
        }
        toutcontenu.append(" ").append(Structure.getLibelleAffichable(_fiche.getCodeRattachement(), _fiche.getLangue()));
        toutcontenu.append(" ").append(_fiche.getContenuEncadre());
        HTMLParser parser = new HTMLParser();
        parser.setInputHtml(RechercheFmt.formaterEnHTML(_ctx, toutcontenu.toString()));
        index.setContent(RechercheFmt.formaterTexteRecherche(parser.extractString(false), false, false));
        StringBuffer contenuFichiers = new StringBuffer();
        int poidsTotal = 0;
        Vector<Ressource> lstFichier = Ressource.getListeTotale(_fiche);
        for (Ressource fichiergw : lstFichier) {
            if (fichiergw.getMedia() == null) continue;
            if ((poidsTotal += fichiergw.getMedia().getPoids().intValue()) > 100000) break;
            String path = fichiergw.getPathAbsolu();
            File fichierJoint = new File(path);
            if (!fichierJoint.exists()) continue;
            try {
                StringBuffer contenuFichiersTemp = this.indexFile(fichierJoint, fichiergw.getMedia().getFormat());
                if (contenuFichiersTemp != null) {
                    contenuFichiers = contenuFichiers.length() < contenuFichiersTemp.length() ? contenuFichiersTemp.append(contenuFichiers) : contenuFichiers.append(contenuFichiersTemp);
                }
                contenuFichiers.append(" ").append(fichiergw.getFullTextString());
            }
            catch (Exception e) {
                LOGGER.error("Exception lors de l'indexation du fichier " + fichierJoint.getName(), (Throwable)e);
            }
        }
        index.setContentFile(RechercheFmt.formaterTexteRecherche(contenuFichiers.toString(), false, false));
        return index;
    }

    private StringBuffer indexFile(File _f, String format) throws Exception {
        if (_f == null) {
            return null;
        }
        if (format == null) {
            format = "";
        }
        if (format.contains("image/")) {
            return null;
        }
        String filename = _f.getName().toLowerCase();
        FileInputStream fis = new FileInputStream(_f);
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        metadata.add("resourceName", filename);
        StringWriter writer = new StringWriter();
        parser.parse((InputStream)fis, (ContentHandler)new BodyContentHandler((Writer)writer), metadata, new ParseContext());
        fis.close();
        return writer.getBuffer();
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public void deleteAll() throws Exception {
        block3: {
            try {
                this.initWriter();
                this.getWriter().deleteAll();
                this.closeWriter();
            }
            catch (IOException ioe) {
                File[] indexFiles;
                LOGGER.warn("Suppression manuelle des indexes Lucene : ", (Throwable)ioe);
                File indexDir = Indexer.getRepertoireIndexation();
                if (indexDir == null || !indexDir.exists() || !indexDir.isDirectory() || !indexDir.canWrite()) break block3;
                for (File indexFile : indexFiles = (File[])ArrayUtils.nullToEmpty((Object[])indexDir.listFiles())) {
                    if (!indexFile.isFile() || !indexFile.canWrite()) continue;
                    indexFile.delete();
                }
            }
        }
    }

    protected void initWriter() throws Exception {
        try {
            this.newWriter();
        }
        catch (LockObtainFailedException e) {
            this.forceInitWriter();
        }
    }
}

