/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.textsearch.CacheIndexerManager;
import com.jsbsoft.jtf.textsearch.Indexer;
import com.jsbsoft.jtf.textsearch.Searcher;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.cluster.ClusterHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import net.sf.ehcache.Cache;
import org.quartz.JobExecutionContext;

public class IndexerJob
extends LogReportJob {
    public static final String FIRST_INDEX = "firstIndex";
    private static final int FICHE_SUPPRIMEE = 1;
    private static final int FICHE_INDEXEE = 2;
    private Long delay = new Long(300000L);
    private boolean firstIndex = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexerFiche(Indexer indexer, Metatag meta) {
        int result = 0;
        try {
            ContexteUniv ctxFiche = ContexteUtil.setContexteSansRequete();
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
            ficheUniv.setCtx(ctxFiche);
            ficheUniv.init();
            ficheUniv.setIdFiche(meta.getMetaIdFiche());
            ficheUniv.retrieve();
            this.logger.info("Traitement de la fiche : " + meta.getMetaLibelleFiche() + ", objet=" + meta.getMetaLibelleObjet() + ", id=" + meta.getMetaIdFiche());
            if (EtatFiche.A_SUPPRIMER.getEtat().equals(ficheUniv.getEtatObjet())) {
                indexer.deleteFiche(ficheUniv);
                result = 1;
                this.logger.debug("Fiche supprim\u00e9e");
            } else {
                indexer.indexFiche(ctxFiche, ficheUniv, true);
                result = 2;
                this.logger.debug("Fiche index\u00e9e");
            }
        }
        catch (Exception e) {
            this.logger.error("Exception lors du traitement de la fiche : objet=" + meta.getMetaLibelleObjet() + ", id=" + meta.getMetaIdFiche(), (Throwable)e);
        }
        finally {
            ContexteUtil.releaseContexteUniv();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block23: {
            ContextePage ctx = new ContextePage("");
            int count = 0;
            int countSuppr = 0;
            try {
                if (this.firstIndex) {
                    ctx.setConnectionLongue(true);
                }
                CacheIndexerManager cacheIndexerManager = CacheIndexerManager.getInstance();
                Cache fichesSupprimees = cacheIndexerManager.getCache();
                ArrayList cacheKeys = new ArrayList(fichesSupprimees.getKeys());
                ClauseWhere where = new ClauseWhere();
                if (!this.firstIndex) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(new Date(System.currentTimeMillis()));
                    gc.setTimeInMillis(gc.getTimeInMillis() - this.delay);
                    SimpleDateFormat formatDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    where.setPremiereCondition(ConditionHelper.genericCondition("DATE_FORMAT(META_DATE_OPERATION, '%Y-%m-%d %H:%i:%s')", TypeOperande.NON_ECHAPABLE, "'" + formatDateTime.format(gc.getTime()) + "'", TypeOperande.NON_ECHAPABLE, Operateur.GREATER_EQUALS));
                } else {
                    where.setPremiereCondition(ConditionHelper.genericCondition(1, TypeOperande.INTEGER, 1, TypeOperande.INTEGER, Operateur.EQUALS));
                }
                Vector<String> objetsExclus = Chaine.getVecteurPointsVirgules(PropertyHelper.getCoreProperty("lucene.restriction_objet"));
                if (objetsExclus.size() > 0) {
                    where.and(ConditionHelper.notIn("META_CODE_OBJET", objetsExclus));
                }
                Metatag meta = new Metatag();
                meta.setCtx(ctx);
                meta.init();
                boolean initWriter = false;
                int nbMeta = meta.select(where.formaterSQL());
                if (nbMeta <= 0 && cacheKeys.size() <= 0) break block23;
                this.logger.info(nbMeta + " fiche(s) \u00e0 traiter");
                Indexer indexer = Indexer.getInstance();
                try {
                    if (indexer.getWriter() == null) {
                        if (this.firstIndex) {
                            indexer.deleteAll();
                        }
                        indexer.initWriter();
                        initWriter = true;
                        for (Object key : cacheKeys) {
                            MetatagBean mb = (MetatagBean)cacheIndexerManager.get(key);
                            if (mb == null) continue;
                            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(mb.getMetaCodeObjet()));
                            ficheUniv.setIdFiche(mb.getMetaIdFiche());
                            indexer.deleteFiche(ficheUniv);
                            cacheIndexerManager.evict(key);
                        }
                        while (meta.nextItem()) {
                            int result = this.indexerFiche(indexer, meta);
                            if (result == 1) {
                                ++countSuppr;
                                continue;
                            }
                            if (result != 2) continue;
                            ++count;
                        }
                    } else {
                        this.logger.error("Writer en cours d'ex\u00e9cution...");
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception lors de l'indexation des fiches : " + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (initWriter) {
                        indexer.closeWriter();
                        ClusterHelper.refresh(Searcher.getInstance(), null);
                    }
                }
                if (this.firstIndex) {
                    this.firstIndex = false;
                    this.logger.info("Nombre de fiche(s) index\u00e9e(s) : " + count);
                } else {
                    this.logger.info("Nombre de fiche(s) index\u00e9e(s) : " + count);
                    this.logger.info("Nombre de fiche(s) supprim\u00e9e(s) de l'index : " + countSuppr);
                }
            }
            catch (Exception e) {
                this.logger.error("Exception dans le job d'indexation", (Throwable)e);
            }
            finally {
                ctx.release();
            }
        }
    }

    @Override
    public void perform() {
        this.run();
    }

    @Override
    public void init(JobExecutionContext jobCtx) {
        this.firstIndex = jobCtx.getMergedJobDataMap().getBooleanValue(FIRST_INDEX);
        if (!this.firstIndex) {
            Date date2;
            Date date1;
            if (jobCtx.getMergedJobDataMap().get((Object)"previousFireTime") != null) {
                date1 = (Date)jobCtx.getMergedJobDataMap().get((Object)"previousFireTime");
                date2 = (Date)jobCtx.getMergedJobDataMap().get((Object)"fireTime");
            } else {
                date1 = (Date)jobCtx.getMergedJobDataMap().get((Object)"fireTime");
                date2 = (Date)jobCtx.getMergedJobDataMap().get((Object)"nextFireTime");
            }
            if (date1 != null && date2 != null) {
                this.delay = date2.getTime() - date1.getTime();
            }
        }
    }

    @Override
    public String getLogFileName() {
        String res = IndexerJob.class.getSimpleName().toLowerCase();
        if (this.firstIndex) {
            res = res + "-firstindex";
        }
        return res;
    }
}

