/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.textsearch.Indexer;
import com.jsbsoft.jtf.textsearch.Searcher;
import com.kportal.core.cluster.ClusterHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerJob
extends LogReportJob {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean initWriter = false;
            LOG.info("Optimisation de l'index Lucene");
            Indexer indexer = Indexer.getInstance();
            try {
                if (indexer.getWriter() == null) {
                    indexer.initWriter();
                    initWriter = true;
                    indexer.optimisation();
                } else {
                    LOG.error("Writer en cours d'ex\u00c3\u00a9cution...");
                }
            }
            catch (Exception e) {
                LOG.error("Exception lors de l'indexation des fiches : " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (initWriter) {
                    indexer.closeWriter();
                    ClusterHelper.refresh(Searcher.getInstance(), null);
                }
            }
            LOG.info("Index Lucene optimis\u00c3\u00a9");
        }
        catch (Exception e) {
            LOG.error("Exception dans le job d'indexation", (Throwable)e);
        }
    }

    @Override
    public void perform() {
        this.run();
    }

    @Override
    public String getLogFileName() {
        return OptimizerJob.class.getSimpleName().toLowerCase();
    }
}

