/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.textsearch.FrenchAnalyzer;
import com.jsbsoft.jtf.textsearch.Recherche;
import com.kportal.core.config.PropertyHelper;
import fr.kosmos.cluster.api.Cluster;
import fr.kosmos.cluster.api.MessageHandler;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Searcher
implements MessageHandler<Serializable> {
    private static final String ID_BEAN = "searcher";
    private ArrayList<Recherche> lstRecherche = null;
    private final FrenchAnalyzer analyzer = new FrenchAnalyzer(false);
    private IndexReader indexReader = null;
    private IndexSearcher indexSearcher = null;
    private boolean isNFS = false;
    private boolean needToReOpen = false;
    public static final int MAX_RESULT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(Searcher.class);
    private Cluster cluster;

    public void init() {
        this.cluster.registerService((MessageHandler)this);
        this.start();
    }

    public static Searcher getInstance() {
        return (Searcher)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    private void start() {
        if (this.lstRecherche == null) {
            String param;
            this.lstRecherche = new ArrayList();
            int i = 1;
            while ((param = PropertyHelper.getCoreProperty("lucene.recherche" + i)) != null) {
                try {
                    Class<?> recherche = Class.forName("com.jsbsoft.jtf.textsearch.Recherche");
                    if (!recherche.isAssignableFrom(Class.forName(param))) {
                        throw new Exception("La classe " + param + " n'impl\u00e9mente pas com.jsbsoft.jtf.textsearch.Recherche");
                    }
                    this.lstRecherche.add((Recherche)Class.forName(param).newInstance());
                }
                catch (Exception e) {
                    LOG.error("Erreur dans la configuration de la recherche : " + param, (Throwable)e);
                }
                ++i;
            }
            ArrayList<File> lstRepertoire = new ArrayList<File>();
            for (Recherche recherche : this.lstRecherche) {
                lstRepertoire.addAll(recherche.getLstRepertoireRecherche());
            }
            ArrayList<IndexReader> lstReader = new ArrayList<IndexReader>(lstRepertoire.size());
            for (File f : lstRepertoire) {
                try {
                    if (!f.exists()) continue;
                    Directory directory = this.getDirectory(f);
                    if (IndexReader.indexExists((Directory)directory)) {
                        lstReader.add(IndexReader.open((Directory)directory));
                        continue;
                    }
                    LOG.warn("Index de recherche inexistant pour le path " + f.getAbsolutePath());
                }
                catch (Exception e) {
                    LOG.error("Erreur lors de la cr\u00e9ation de l'index searcher pour le r\u00e9pertoire : " + f.getAbsolutePath(), (Throwable)e);
                }
            }
            if (lstReader.size() > 0) {
                try {
                    this.indexReader = new MultiReader(lstReader.toArray(new IndexReader[lstReader.size()]));
                    this.indexSearcher = new IndexSearcher(this.indexReader);
                }
                catch (Exception exception) {
                    LOG.error("Erreur dans la configuration de la recherche", (Throwable)exception);
                }
            } else {
                LOG.warn("Aucun index de recherche trouv\u00e9");
            }
            this.isNFS = "nfs".equalsIgnoreCase(PropertyHelper.getCoreProperty("recherche.directory"));
        }
    }

    private synchronized void testReader() {
        if (this.indexReader == null) {
            this.forcerInit();
        }
        if (this.needToReOpen) {
            this.reOpen();
        }
    }

    private synchronized void reOpen() {
        if (this.needToReOpen) {
            try {
                IndexReader newReader = IndexReader.openIfChanged((IndexReader)this.indexReader);
                if (newReader != this.indexReader) {
                    this.closeAll();
                }
                this.indexReader = newReader;
                this.indexSearcher = new IndexSearcher(this.indexReader);
            }
            catch (Exception e) {
                LOG.error("erreur sur l'indexer", (Throwable)e);
            }
            this.needToReOpen = false;
        }
    }

    public void forcerInit() {
        this.lstRecherche = null;
        try {
            this.closeAll();
        }
        catch (IOException e) {
            LOG.error("impossible de fermer les index", (Throwable)e);
        }
        this.start();
        this.needToReOpen = false;
    }

    public Directory getDirectory(File f) throws IOException {
        Object directory = this.isNFS ? new SimpleFSDirectory(f, (LockFactory)new SimpleFSLockFactory()) : FSDirectory.open((File)f);
        return directory;
    }

    public void closeAll() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher = null;
        }
    }

    public IndexSearcher getSearcher() {
        this.testReader();
        return this.indexSearcher;
    }

    public void setSearcher(IndexSearcher searcher) {
        this.indexSearcher = searcher;
    }

    public IndexReader getIndexReader() {
        this.testReader();
        return this.indexReader;
    }

    public void setIndexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    @Deprecated
    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public void setIndexSearcher(IndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    public FrenchAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public void handleMessage(Serializable message) {
        this.needToReOpen = Boolean.TRUE;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

