/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch.sitesdistants;

import com.jsbsoft.jtf.textsearch.CibleRecherche;
import com.jsbsoft.jtf.textsearch.Recherche;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.Site;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RechercheSitesDistants
implements Recherche {
    private static ArrayList<File> lstRepertoireRecherche = null;
    private static Collection<CibleRecherche> lstCible = null;
    private static final Logger LOG = LoggerFactory.getLogger(RechercheSitesDistants.class);

    public Collection<CibleRecherche> getLstCible() {
        if (lstCible == null) {
            RechercheSitesDistants.init();
        }
        return lstCible;
    }

    @Override
    public Collection<File> getLstRepertoireRecherche() {
        if (lstRepertoireRecherche == null) {
            RechercheSitesDistants.init();
        }
        return lstRepertoireRecherche;
    }

    public static void init() {
        lstRepertoireRecherche = new ArrayList();
        lstCible = new ArrayList<CibleRecherche>();
        if ("1".equals(PropertyHelper.getCoreProperty("sitesdistants.activation"))) {
            ContextePage ctx = new ContextePage("");
            try {
                Site site = new Site();
                site.init();
                site.setCtx(ctx);
                site.select("");
                File fRep = null;
                while (site.nextItem()) {
                    lstCible.add(new CibleRecherche(site.getCode(), site.getLibelle()));
                    fRep = site.getRepertoireIndexation();
                    if (!fRep.exists() || !fRep.canRead() || !fRep.isDirectory() || lstRepertoireRecherche.contains(fRep)) continue;
                    lstRepertoireRecherche.add(fRep);
                }
            }
            catch (Exception e) {
                LOG.error("Exception lors de l'interrogation des sites", (Throwable)e);
            }
            finally {
                ctx.release();
            }
        }
    }

    public static CibleRecherche getCible(String code) {
        if (lstCible == null) {
            RechercheSitesDistants.init();
        }
        Iterator<CibleRecherche> it = lstCible.iterator();
        CibleRecherche cible = null;
        while (it.hasNext()) {
            cible = it.next();
            if (!cible.getCode().equals(code)) continue;
            return cible;
        }
        return null;
    }
}

