/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch.sitesdistants;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class URLQueue {
    LinkedList<String> evenQueue = new LinkedList();
    LinkedList<String> oddQueue = new LinkedList();
    Set<String> gatheredLinks = new HashSet<String>();
    Set<String> processedLinks = new HashSet<String>();
    int maxElements;
    String filenamePrefix;

    public URLQueue() {
        this.maxElements = -1;
        this.filenamePrefix = "";
    }

    public URLQueue(int _maxElements, String _filenamePrefix) {
        this.maxElements = _maxElements;
        this.filenamePrefix = _filenamePrefix;
    }

    public void setFilenamePrefix(String _filenamePrefix) {
        this.filenamePrefix = _filenamePrefix;
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public void setMaxElements(int _maxElements) {
        this.maxElements = _maxElements;
    }

    public Set<String> getGatheredElements() {
        return this.gatheredLinks;
    }

    public Set<String> getProcessedElements() {
        return this.processedLinks;
    }

    public int getQueueSize(int level) {
        int size = 0;
        size = level % 2 == 0 ? this.evenQueue.size() : this.oddQueue.size();
        return size;
    }

    public int getProcessedSize() {
        return this.processedLinks.size();
    }

    public int getGatheredSize() {
        return this.gatheredLinks.size();
    }

    public synchronized URL pop(int level) {
        String s = null;
        if (level % 2 == 0) {
            if (this.evenQueue.size() != 0) {
                s = this.evenQueue.removeFirst();
            }
        } else if (this.oddQueue.size() != 0) {
            s = this.oddQueue.removeFirst();
        }
        URL url = null;
        if (s != null) {
            try {
                url = new URL(s);
                this.processedLinks.add(s);
                return url;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public synchronized boolean push(URL url, int level) {
        if (this.maxElements != -1 && this.maxElements <= this.gatheredLinks.size()) {
            return false;
        }
        String s = url.toString();
        boolean pushed = false;
        if (this.gatheredLinks.add(s)) {
            if (level % 2 == 0) {
                this.evenQueue.addLast(s);
            } else {
                this.oddQueue.addLast(s);
            }
            pushed = true;
        }
        return pushed;
    }

    public synchronized void clear() {
        this.evenQueue.clear();
        this.oddQueue.clear();
    }
}

